<?php

    include "MySql.php";
    include "retorno.php";
    $request_method = $_SERVER["REQUEST_METHOD"];

    if($request_method != "GET"){
        $json = array('status'=>0, 'message'=>"Método de acesso inválido");
        returnJSON($json, 405);
    }
    
    $conn = new MySql();
    $cidade_id = $conn->real_escape_string($_GET['cidade_id']);
    
    if( !is_numeric($cidade_id) || $cidade_id <= 0){
        $json = array('status'=>0, 'message'=>"Formato de dados inválido");

        returnJSON($json, 400);
        exit;
    }

    $sql = "select * from tb_cidades where id = $cidade_id";
    $result = $conn->query($sql);

    if($result->num_rows == 0){
        $json = array('status'=>0, 'message'=>"Erro ao acessar dados");

        returnJSON($json, 500);
        exit;
    }


    $regional = $result->fetch_assoc();
    
    $sql_nucleos = "select nucleo.id, nucleo.nome, nucleo.responsavel, nucleo.endereco, nucleo.email, nucleo.idregional, regionais.regional
     from senuc_nucleo as nucleo 
     inner join regionais on nucleo.idregional = regionais.id
     where idregional = {$regional['regional']} order by nucleo.endereco";

    $result_nucleo = $conn->query($sql_nucleos);
    error_log($sql_nucleos);


    if($result_nucleo->num_rows == 0){
        error_log("Nenhum encontrado para {$regional['regional']} ");
        $json = array('status'=>0, 
            'message'=>"Nenhum nucleo encontrado para a regional");

        returnJSON($json, 404);
        
    }

    $json = array();
    
    while( $dados = $result_nucleo->fetch_assoc() ){
        array_push($json, 
            array( 'id'=>$dados['id'], 
                    'nome'=>utf8_encode($dados['nome']), 
                    'responsavel'=>utf8_encode($dados['responsavel']),
                    'endereco'=>utf8_encode($dados['endereco']),
                    'email' => utf8_encode($dados['email']),
                    'regional' => utf8_encode($dados['regional'])
        
        ) );
        error_log($json);
    }
    // var_dump( $json );
    
    returnJSON($json, 202);
    exit;
?>