<?php 
include("include/dbcommon.php");

@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

add_nocache_headers();
include("include/bolsistas_nucleo_variables.php");
include('include/xtempl.php');
include('classes/addpage.php');

global $globalEvents;

//	check if logged in
if(@$_SESSION["UserID"] && IsAdmin() && !CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Add"))
{
	echo "<p>"."Voc no tem permisso para acessar esta tabela"."<br>Proceed to <a href=\"admin.php\">Admin Area</a> to set up user permissions</p>";
	return;
}
if(!isLogged() || CheckPermissionsEvent($strTableName, 'A') && !CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Add"))
{ 
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	
	header("Location: login.php?message=expired"); 
	return;
}

if ((sizeof($_POST)==0) && (postvalue('ferror'))){
	if (postvalue("inline")){
		$returnJSON['success'] = false;
		$returnJSON['message'] = "Ocorreu um erro!";
		$returnJSON['fatalError'] = true;
		echo "<textarea>".htmlspecialchars(my_json_encode($returnJSON))."</textarea>";
		exit();
	}
	else if (postvalue("fly")){
		echo -1;
		exit();
	}
	else {
		$_SESSION["message_add"] = "<< "."Error occurred"." >>";
	}
}

$layout = new TLayout("add2","BreezeAqua1","MobileAqua1");
$layout->blocks["top"] = array();
$layout->containers["add"] = array();

$layout->containers["add"][] = array("name"=>"addheader","block"=>"","substyle"=>2);


$layout->containers["add"][] = array("name"=>"message","block"=>"message_block","substyle"=>1);


$layout->containers["add"][] = array("name"=>"wrapper","block"=>"","substyle"=>1, "container"=>"fields");


$layout->containers["fields"] = array();

$layout->containers["fields"][] = array("name"=>"addfields","block"=>"","substyle"=>1);


$layout->containers["fields"][] = array("name"=>"legend","block"=>"legend","substyle"=>3);


$layout->containers["fields"][] = array("name"=>"addbuttons","block"=>"","substyle"=>2);


$layout->skins["fields"] = "fields";

$layout->skins["add"] = "1";
$layout->blocks["top"][] = "add";
$layout->skins["details"] = "empty";
$layout->blocks["top"][] = "details";$page_layouts["bolsistas_nucleo_add"] = $layout;



$filename = "";
$status = "";
$message = "";
$mesClass = "";
$usermessage = "";
$error_happened = false;
$readavalues = false;

$keys = array();
$showValues = array();
$showRawValues = array();
$showFields = array();
$showDetailKeys = array();
$IsSaved = false;
$HaveData = true;
$popUpSave = false;

$sessionPrefix = $strTableName;

$onFly = false;
if(postvalue("onFly"))
	$onFly = true;

if(@$_REQUEST["editType"]=="inline")
	$inlineadd = ADD_INLINE;
elseif(@$_REQUEST["editType"]==ADD_POPUP)
{
	$inlineadd = ADD_POPUP;
	if(@$_POST["a"]=="added" && postvalue("field")=="" && postvalue("category")=="")
		$popUpSave = true;	
}
elseif(@$_REQUEST["editType"]==ADD_MASTER)
	$inlineadd = ADD_MASTER;
elseif($onFly)
{
	$inlineadd = ADD_ONTHEFLY;
	$sessionPrefix = $strTableName."_add";
}
else
	$inlineadd = ADD_SIMPLE;

if($inlineadd == ADD_INLINE)
	$templatefile = "bolsistas_nucleo_inline_add.htm";
else
	$templatefile = "bolsistas_nucleo_add.htm";

$id = postvalue("id");
if(intval($id)==0)
	$id = 1;

//If undefined session value for mastet table, but exist post value master table, than take second
//It may be happen only when use dpInline mode on page add
if(!@$_SESSION[$sessionPrefix."_mastertable"] && postvalue("mastertable"))
	$_SESSION[$sessionPrefix."_mastertable"] = postvalue("mastertable");
	
$xt = new Xtempl();
	
// assign an id
$xt->assign("id",$id);
	
$auditObj = GetAuditObject($strTableName);

//array of params for classes
$params = array("pageType" => PAGE_ADD,"id" => $id,"mode" => $inlineadd);


$params['xt'] = &$xt;
$params['tName'] = $strTableName;
$params['includes_js'] = $includes_js;
$params['locale_info'] = $locale_info;
$params['includes_css'] = $includes_css;
$params['useTabsOnAdd'] = $gSettings->useTabsOnAdd();
$params['templatefile'] = $templatefile;
$params['includes_jsreq'] = $includes_jsreq;
$params['pageAddLikeInline'] = ($inlineadd==ADD_INLINE);
$params['needSearchClauseObj'] = false;
$params['strOriginalTableName'] = $strOriginalTableName;

if($params['useTabsOnAdd'])
	$params['arrAddTabs'] = $gSettings->getAddTabs();
	
$pageObject = new AddPage($params);

if(isset($_REQUEST['afteradd'])){
		header('Location: bolsistas_nucleo_add.php');
	if($eventObj->exists("AfterAdd") && isset($_SESSION['after_add_data'][$_REQUEST['afteradd']])){
	
		$data = $_SESSION['after_add_data'][$_REQUEST['afteradd']];
		$eventObj->AfterAdd($data['avalues'], $data['keys'],$data['inlineadd'], $pageObject);
	
	}
	unset($_SESSION['after_add_data'][$_REQUEST['afteradd']]);
	
	foreach (is_array($_SESSION['after_add_data']) ? $_SESSION['after_add_data'] : array() as $k=>$v){
		if (!is_array($v) or !array_key_exists('time',$v)) {
			unset($_SESSION['after_add_data'][$k]);
			continue;
		}
		if ($v['time'] < time() - 3600){
			unset($_SESSION['after_add_data'][$k]);
		}
	}
		exit;
}

//Get detail table keys	
$detailKeys = $pageObject->detailKeysByM;

//Array of fields, which appear on add page
$addFields = $pageObject->getFieldsByPageType();

// add button events if exist
if ($inlineadd==ADD_SIMPLE)
	$pageObject->addButtonHandlers();

$url_page=substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1,12);

//For show detail tables on master page add
if($inlineadd==ADD_SIMPLE || $inlineadd==ADD_MASTER || $inlineadd==ADD_POPUP)
{
	$dpParams = array();
	if($pageObject->isShowDetailTables  && !isMobile())
	{
		$ids = $id;
		$countDetailsIsShow = 0;
		$pageObject->jsSettings['tableSettings'][$strTableName]['isShowDetails'] = $countDetailsIsShow > 0 ? true : false;
		$pageObject->jsSettings['tableSettings'][$strTableName]['dpParams'] = array('tableNames'=>$dpParams['strTableNames'], 'ids'=>$dpParams['ids']);
	}
}

//	Before Process event
if($eventObj->exists("BeforeProcessAdd"))
	$eventObj->BeforeProcessAdd($conn, $pageObject);

// proccess captcha
if ($inlineadd==ADD_SIMPLE || $inlineadd==ADD_MASTER || $inlineadd==ADD_POPUP)
	if($pageObject->captchaExists())
		$pageObject->doCaptchaCode();
	
// insert new record if we have to
if(@$_POST["a"]=="added")
{
	$afilename_values=array();
	$avalues=array();
	$blobfields=array();
//	processing nome - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_nome = $pageObject->getControl("nome", $id);
		$control_nome->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing nome - end
//	processing etnia - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_etnia = $pageObject->getControl("etnia", $id);
		$control_etnia->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing etnia - end
//	processing sexo - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_sexo = $pageObject->getControl("sexo", $id);
		$control_sexo->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing sexo - end
//	processing nascimento - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_nascimento = $pageObject->getControl("nascimento", $id);
		$control_nascimento->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing nascimento - end
//	processing cpf - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_cpf = $pageObject->getControl("cpf", $id);
		$control_cpf->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing cpf - end
//	processing email - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_email = $pageObject->getControl("email", $id);
		$control_email->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing email - end
//	processing tel_residencial - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_tel_residencial = $pageObject->getControl("tel_residencial", $id);
		$control_tel_residencial->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing tel_residencial - end
//	processing tel_cel_com - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_tel_cel_com = $pageObject->getControl("tel_cel_com", $id);
		$control_tel_cel_com->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing tel_cel_com - end
//	processing operadora - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_operadora = $pageObject->getControl("operadora", $id);
		$control_operadora->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing operadora - end
//	processing grupo - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_grupo = $pageObject->getControl("grupo", $id);
		$control_grupo->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing grupo - end
//	processing faculdade - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_faculdade = $pageObject->getControl("faculdade", $id);
		$control_faculdade->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing faculdade - end
//	processing campus - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_campus = $pageObject->getControl("campus", $id);
		$control_campus->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing campus - end
//	processing curso - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_curso = $pageObject->getControl("curso", $id);
		$control_curso->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing curso - end
//	processing Tipo de Curso - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_Tipo_de_Curso = $pageObject->getControl("Tipo de Curso", $id);
		$control_Tipo_de_Curso->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing Tipo de Curso - end
//	processing turno - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_turno = $pageObject->getControl("turno", $id);
		$control_turno->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing turno - end
//	processing bolsa - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_bolsa = $pageObject->getControl("bolsa", $id);
		$control_bolsa->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing bolsa - end
//	processing ano_ingresso - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_ano_ingresso = $pageObject->getControl("ano_ingresso", $id);
		$control_ano_ingresso->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing ano_ingresso - end
//	processing semestre_ingresso - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_semestre_ingresso = $pageObject->getControl("semestre_ingresso", $id);
		$control_semestre_ingresso->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing semestre_ingresso - end
//	processing semestre_atual - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_semestre_atual = $pageObject->getControl("semestre_atual", $id);
		$control_semestre_atual->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing semestre_atual - end




	$failed_inline_add=false;
//	add filenames to values
	foreach($afilename_values as $akey=>$value)
		$avalues[$akey]=$value;
	
//	before Add event
	$retval = true;
	if($eventObj->exists("BeforeAdd"))
		$retval = $eventObj->BeforeAdd($avalues,$usermessage,(bool)$inlineadd, $pageObject);
	if($retval && $pageObject->isCaptchaOk)
	{
		//add or set updated lat-lng values for all map fileds with 'UpdateLatLng' ticked
		setUpdatedLatLng($avalues, $pageObject->cipherer->pSet);
		
		$_SESSION[$strTableName."_count_captcha"] = $_SESSION[$strTableName."_count_captcha"]+1;
		if(DoInsertRecord($strOriginalTableName,$avalues,$blobfields,$id,$pageObject, $pageObject->cipherer))
		{
			$IsSaved=true;
//	after edit event
			if($auditObj || $eventObj->exists("AfterAdd"))
			{
				foreach($keys as $idx=>$val)
					$avalues[$idx]=$val;
			}
			
			if($auditObj)
				$auditObj->LogAdd($strTableName,$avalues,$keys);
				
// Give possibility to all edit controls to clean their data				
//	processing nome - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_nome->afterSuccessfulSave();
			}
//	processing nome - end
//	processing etnia - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_etnia->afterSuccessfulSave();
			}
//	processing etnia - end
//	processing sexo - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_sexo->afterSuccessfulSave();
			}
//	processing sexo - end
//	processing nascimento - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_nascimento->afterSuccessfulSave();
			}
//	processing nascimento - end
//	processing cpf - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_cpf->afterSuccessfulSave();
			}
//	processing cpf - end
//	processing email - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_email->afterSuccessfulSave();
			}
//	processing email - end
//	processing tel_residencial - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_tel_residencial->afterSuccessfulSave();
			}
//	processing tel_residencial - end
//	processing tel_cel_com - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_tel_cel_com->afterSuccessfulSave();
			}
//	processing tel_cel_com - end
//	processing operadora - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_operadora->afterSuccessfulSave();
			}
//	processing operadora - end
//	processing grupo - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_grupo->afterSuccessfulSave();
			}
//	processing grupo - end
//	processing faculdade - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_faculdade->afterSuccessfulSave();
			}
//	processing faculdade - end
//	processing campus - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_campus->afterSuccessfulSave();
			}
//	processing campus - end
//	processing curso - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_curso->afterSuccessfulSave();
			}
//	processing curso - end
//	processing Tipo de Curso - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_Tipo_de_Curso->afterSuccessfulSave();
			}
//	processing Tipo de Curso - end
//	processing turno - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_turno->afterSuccessfulSave();
			}
//	processing turno - end
//	processing bolsa - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_bolsa->afterSuccessfulSave();
			}
//	processing bolsa - end
//	processing ano_ingresso - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_ano_ingresso->afterSuccessfulSave();
			}
//	processing ano_ingresso - end
//	processing semestre_ingresso - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_semestre_ingresso->afterSuccessfulSave();
			}
//	processing semestre_ingresso - end
//	processing semestre_atual - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_semestre_atual->afterSuccessfulSave();
			}
//	processing semestre_atual - end

			$afterAdd_id = '';	
			if($eventObj->exists("AfterAdd") && $inlineadd!=ADD_MASTER){
				$eventObj->AfterAdd($avalues,$keys,(bool)$inlineadd, $pageObject);
			} else if ($eventObj->exists("AfterAdd") && $inlineadd==ADD_MASTER){
				if($onFly)
					$eventObj->AfterAdd($avalues,$keys,(bool)$inlineadd, $pageObject);
				else{
					$afterAdd_id = generatePassword(20);	
				
					$_SESSION['after_add_data'][$afterAdd_id] = array(
						'avalues'=>$avalues,
						'keys'=>$keys,
						'inlineadd'=>(bool)$inlineadd,
						'time' => time()
					);	
				}
			}
				
			if($inlineadd==ADD_SIMPLE || $inlineadd==ADD_MASTER)
			{
				$permis = array();
				$keylink = "";$k = 0;
				foreach($keys as $idx=>$val)
				{
					if($k!=0)
						$keylink .="&";
					$keylink .="editid".(++$k)."=".htmlspecialchars(rawurlencode(@$val));
				}
				$permis = $pageObject->getPermissions();				
				if (count($keys))
				{
					$message .="</br>";
					if($pageObject->pSet->hasEditPage() && $permis['edit'])
						$message .='&nbsp;<a href=\'bolsistas_nucleo_edit.php?'.$keylink.'\'>'."Editar".'</a>&nbsp;';
					if($pageObject->pSet->hasViewPage() && $permis['search'])
						$message .='&nbsp;<a href=\'bolsistas_nucleo_view.php?'.$keylink.'\'>'."Exibir".'</a>&nbsp;';
				}
				$mesClass = "mes_ok";	
			}
		}
		elseif($inlineadd!=ADD_INLINE)
			$mesClass = "mes_not";	
	}
	else
	{
		$message = $usermessage;
		$status = "DECLINED";
		$readavalues = true;
	}
}
if($message)
	$message = "<div class='message ".$mesClass."'>".$message."</div>";

// PRG rule, to avoid POSTDATA resend
if (no_output_done() && $inlineadd==ADD_SIMPLE && $IsSaved)
{
	// saving message
	$_SESSION["message_add"] = ($message ? $message : "");
	// redirect
	header("Location: bolsistas_nucleo_".$pageObject->getPageType().".php");
	// turned on output buffering, so we need to stop script
	exit();
}

if($inlineadd==ADD_MASTER && $IsSaved)
	$_SESSION["message_add"] = ($message ? $message : "");
	
// for PRG rule, to avoid POSTDATA resend. Saving mess in session
if($inlineadd==ADD_SIMPLE && isset($_SESSION["message_add"]))
{
	$message = $_SESSION["message_add"];
	unset($_SESSION["message_add"]);
}

$defvalues=array();

//	copy record
if(array_key_exists("copyid1",$_REQUEST) || array_key_exists("editid1",$_REQUEST))
{
	$copykeys=array();
	if(array_key_exists("copyid1",$_REQUEST))
	{
		$copykeys["cpf"]=postvalue("copyid1");
		$copykeys["email"]=postvalue("copyid2");
	}
	else
	{
		$copykeys["cpf"]=postvalue("editid1");
		$copykeys["email"]=postvalue("editid2");
	}
	$strWhere=KeyWhere($copykeys);
	$strSQL = $gQuery->gSQLWhere($strWhere);

	LogInfo($strSQL);
	$rs = db_query($strSQL,$conn);
	$defvalues = $pageObject->cipherer->DecryptFetchedArray($rs);
	if(!$defvalues)
		$defvalues=array();
//	clear key fields
	$defvalues["cpf"]="";
	$defvalues["email"]="";
//call CopyOnLoad event
	if($eventObj->exists("CopyOnLoad"))
		$eventObj->CopyOnLoad($defvalues,$strWhere, $pageObject);
}
else
{
}



if($readavalues)
{
	$defvalues["nome"]=@$avalues["nome"];
	$defvalues["etnia"]=@$avalues["etnia"];
	$defvalues["sexo"]=@$avalues["sexo"];
	$defvalues["nascimento"]=@$avalues["nascimento"];
	$defvalues["cpf"]=@$avalues["cpf"];
	$defvalues["email"]=@$avalues["email"];
	$defvalues["tel_residencial"]=@$avalues["tel_residencial"];
	$defvalues["tel_cel_com"]=@$avalues["tel_cel_com"];
	$defvalues["operadora"]=@$avalues["operadora"];
	$defvalues["grupo"]=@$avalues["grupo"];
	$defvalues["faculdade"]=@$avalues["faculdade"];
	$defvalues["campus"]=@$avalues["campus"];
	$defvalues["curso"]=@$avalues["curso"];
	$defvalues["Tipo de Curso"]=@$avalues["Tipo de Curso"];
	$defvalues["turno"]=@$avalues["turno"];
	$defvalues["bolsa"]=@$avalues["bolsa"];
	$defvalues["ano_ingresso"]=@$avalues["ano_ingresso"];
	$defvalues["semestre_ingresso"]=@$avalues["semestre_ingresso"];
	$defvalues["semestre_atual"]=@$avalues["semestre_atual"];
}

if($eventObj->exists("ProcessValuesAdd"))
	$eventObj->ProcessValuesAdd($defvalues, $pageObject);


//for basic files
$includes="";

if($inlineadd!=ADD_INLINE)
{
	if($inlineadd!=ADD_ONTHEFLY && $inlineadd!=ADD_POPUP)
	{
		$includes .="<script language=\"JavaScript\" src=\"include/loadfirst.js\"></script>\r\n";
				$includes.="<script type=\"text/javascript\" src=\"include/lang/".getLangFileName(mlang_getcurrentlang()).".js\"></script>";
		if (!isMobile())
			$includes.="<div id=\"search_suggest\"></div>\r\n";
	}
	
	if(!$pageObject->isAppearOnTabs("nome"))
		$xt->assign("nome_fieldblock",true);
	else
		$xt->assign("nome_tabfieldblock",true);
	$xt->assign("nome_label",true);
	if(isEnableSection508())
		$xt->assign_section("nome_label","<label for=\"".GetInputElementId("nome", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("etnia"))
		$xt->assign("etnia_fieldblock",true);
	else
		$xt->assign("etnia_tabfieldblock",true);
	$xt->assign("etnia_label",true);
	if(isEnableSection508())
		$xt->assign_section("etnia_label","<label for=\"".GetInputElementId("etnia", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("sexo"))
		$xt->assign("sexo_fieldblock",true);
	else
		$xt->assign("sexo_tabfieldblock",true);
	$xt->assign("sexo_label",true);
	if(isEnableSection508())
		$xt->assign_section("sexo_label","<label for=\"".GetInputElementId("sexo", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("nascimento"))
		$xt->assign("nascimento_fieldblock",true);
	else
		$xt->assign("nascimento_tabfieldblock",true);
	$xt->assign("nascimento_label",true);
	if(isEnableSection508())
		$xt->assign_section("nascimento_label","<label for=\"".GetInputElementId("nascimento", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("cpf"))
		$xt->assign("cpf_fieldblock",true);
	else
		$xt->assign("cpf_tabfieldblock",true);
	$xt->assign("cpf_label",true);
	if(isEnableSection508())
		$xt->assign_section("cpf_label","<label for=\"".GetInputElementId("cpf", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("email"))
		$xt->assign("email_fieldblock",true);
	else
		$xt->assign("email_tabfieldblock",true);
	$xt->assign("email_label",true);
	if(isEnableSection508())
		$xt->assign_section("email_label","<label for=\"".GetInputElementId("email", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("tel_residencial"))
		$xt->assign("tel_residencial_fieldblock",true);
	else
		$xt->assign("tel_residencial_tabfieldblock",true);
	$xt->assign("tel_residencial_label",true);
	if(isEnableSection508())
		$xt->assign_section("tel_residencial_label","<label for=\"".GetInputElementId("tel_residencial", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("tel_cel_com"))
		$xt->assign("tel_cel_com_fieldblock",true);
	else
		$xt->assign("tel_cel_com_tabfieldblock",true);
	$xt->assign("tel_cel_com_label",true);
	if(isEnableSection508())
		$xt->assign_section("tel_cel_com_label","<label for=\"".GetInputElementId("tel_cel_com", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("operadora"))
		$xt->assign("operadora_fieldblock",true);
	else
		$xt->assign("operadora_tabfieldblock",true);
	$xt->assign("operadora_label",true);
	if(isEnableSection508())
		$xt->assign_section("operadora_label","<label for=\"".GetInputElementId("operadora", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("grupo"))
		$xt->assign("grupo_fieldblock",true);
	else
		$xt->assign("grupo_tabfieldblock",true);
	$xt->assign("grupo_label",true);
	if(isEnableSection508())
		$xt->assign_section("grupo_label","<label for=\"".GetInputElementId("grupo", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("faculdade"))
		$xt->assign("faculdade_fieldblock",true);
	else
		$xt->assign("faculdade_tabfieldblock",true);
	$xt->assign("faculdade_label",true);
	if(isEnableSection508())
		$xt->assign_section("faculdade_label","<label for=\"".GetInputElementId("faculdade", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("campus"))
		$xt->assign("campus_fieldblock",true);
	else
		$xt->assign("campus_tabfieldblock",true);
	$xt->assign("campus_label",true);
	if(isEnableSection508())
		$xt->assign_section("campus_label","<label for=\"".GetInputElementId("campus", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("curso"))
		$xt->assign("curso_fieldblock",true);
	else
		$xt->assign("curso_tabfieldblock",true);
	$xt->assign("curso_label",true);
	if(isEnableSection508())
		$xt->assign_section("curso_label","<label for=\"".GetInputElementId("curso", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("Tipo de Curso"))
		$xt->assign("Tipo_de_Curso_fieldblock",true);
	else
		$xt->assign("Tipo_de_Curso_tabfieldblock",true);
	$xt->assign("Tipo_de_Curso_label",true);
	if(isEnableSection508())
		$xt->assign_section("Tipo_de_Curso_label","<label for=\"".GetInputElementId("Tipo de Curso", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("turno"))
		$xt->assign("turno_fieldblock",true);
	else
		$xt->assign("turno_tabfieldblock",true);
	$xt->assign("turno_label",true);
	if(isEnableSection508())
		$xt->assign_section("turno_label","<label for=\"".GetInputElementId("turno", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("bolsa"))
		$xt->assign("bolsa_fieldblock",true);
	else
		$xt->assign("bolsa_tabfieldblock",true);
	$xt->assign("bolsa_label",true);
	if(isEnableSection508())
		$xt->assign_section("bolsa_label","<label for=\"".GetInputElementId("bolsa", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("ano_ingresso"))
		$xt->assign("ano_ingresso_fieldblock",true);
	else
		$xt->assign("ano_ingresso_tabfieldblock",true);
	$xt->assign("ano_ingresso_label",true);
	if(isEnableSection508())
		$xt->assign_section("ano_ingresso_label","<label for=\"".GetInputElementId("ano_ingresso", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("semestre_ingresso"))
		$xt->assign("semestre_ingresso_fieldblock",true);
	else
		$xt->assign("semestre_ingresso_tabfieldblock",true);
	$xt->assign("semestre_ingresso_label",true);
	if(isEnableSection508())
		$xt->assign_section("semestre_ingresso_label","<label for=\"".GetInputElementId("semestre_ingresso", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("semestre_atual"))
		$xt->assign("semestre_atual_fieldblock",true);
	else
		$xt->assign("semestre_atual_tabfieldblock",true);
	$xt->assign("semestre_atual_label",true);
	if(isEnableSection508())
		$xt->assign_section("semestre_atual_label","<label for=\"".GetInputElementId("semestre_atual", $id, PAGE_ADD)."\">","</label>");
	
	
	
	if($inlineadd!=ADD_ONTHEFLY && $inlineadd!=ADD_POPUP)
	{
		$pageObject->body["begin"] .= $includes;
				$xt->assign("backbutton_attrs","id=\"backButton".$id."\"");
		$xt->assign("back_button",true);
	}
	else
	{		
		$xt->assign("cancelbutton_attrs", "id=\"cancelButton".$id."\"");
		$xt->assign("cancel_button",true);
		$xt->assign("header","");
	}
	$xt->assign("save_button",true);
}
$xt->assign("savebutton_attrs","id=\"saveButton".$id."\"");
$xt->assign("message_block",true);
$xt->assign("message",$message);
if(!strlen($message))
{
	$xt->displayBrickHidden("message");
}

//	show readonly fields
$linkdata="";

$i = 0;
$jsKeys = array();
$keyFields = array();
foreach($keys as $field=>$value)
{
	$keyFields[$i] = $field;
	$jsKeys[$i++] = $value;
}

if(@$_POST["a"]=="added" && $inlineadd==ADD_ONTHEFLY)
{
	if( !$error_happened && $status!="DECLINED")
	{
		$addedData = GetAddedDataLookupQuery($pageObject, $keys, false);
		$data =& $addedData[0];	
		
		if($data)
		{
			$respData = array($addedData[1]["linkField"] => @$data[$addedData[1]["linkFieldIndex"]], $addedData[1]["displayField"] => @$data[$addedData[1]["displayFieldIndex"]]);
		}
		else
		{
			$respData = array($addedData[1]["linkField"] => @$avalues[$addedData[1]["linkField"]], $addedData[1]["displayField"] => @$avalues[$addedData[1]["displayField"]]);
		}		
		$returnJSON['success'] = true;
		$returnJSON['keys'] = $jsKeys;
		$returnJSON['keyFields'] = $keyFields;
		$returnJSON['vals'] = $respData;
		$returnJSON['fields'] = $showFields;
	}
	else
	{
		$returnJSON['success'] = false;
		$returnJSON['message'] = $message;
	}
	echo "<textarea>".htmlspecialchars(my_json_encode($returnJSON))."</textarea>";
	exit();
}

if(@$_POST["a"]=="added" && ($inlineadd == ADD_INLINE || $inlineadd == ADD_MASTER || $inlineadd==ADD_POPUP)) 
{
	//Preparation   view values
	//	get current values and show edit controls
	$dispFieldAlias = "";
	$data=0;
	$linkAndDispVals = array();
	if(count($keys))
	{
		$where=KeyWhere($keys);
			
		$forLookup = postvalue('forLookup');
		if ($forLookup)
		{
			$addedData = GetAddedDataLookupQuery($pageObject, $keys, true);
			$data =& $addedData[0];
			$linkAndDispVals = array('linkField' => $addedData[0][$addedData[1]["linkField"]], 'displayField' => $addedData[0][$addedData[1]["displayField"]]);
		}
		else
		{
			$strSQL = $gQuery->gSQLWhere_having_fromQuery('', $where, '');		
		
			LogInfo($strSQL);
			$rs=db_query($strSQL,$conn);
			$data = $pageObject->cipherer->DecryptFetchedArray($rs);
		}
	}
	if(!$data)
	{
		$data=$avalues;
		$HaveData=false;
	}
	//check if correct values added

	$keylink="";
	$keylink.="&key1=".htmlspecialchars(rawurlencode(@$data["cpf"]));
	$keylink.="&key2=".htmlspecialchars(rawurlencode(@$data["email"]));
	
////////////////////////////////////////////
//	nome
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("nome", $data, $keylink);
		$showValues["nome"] = $value;
		$showFields[] = "nome";
	}	
//	etnia
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("etnia", $data, $keylink);
		$showValues["etnia"] = $value;
		$showFields[] = "etnia";
	}	
//	sexo
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("sexo", $data, $keylink);
		$showValues["sexo"] = $value;
		$showFields[] = "sexo";
	}	
//	nascimento
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("nascimento", $data, $keylink);
		$showValues["nascimento"] = $value;
		$showFields[] = "nascimento";
	}	
//	cpf
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("cpf", $data, $keylink);
		$showValues["cpf"] = $value;
		$showFields[] = "cpf";
	}	
//	email
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("email", $data, $keylink);
		$showValues["email"] = $value;
		$showFields[] = "email";
	}	
//	tel_residencial
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("tel_residencial", $data, $keylink);
		$showValues["tel_residencial"] = $value;
		$showFields[] = "tel_residencial";
	}	
//	tel_cel_com
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("tel_cel_com", $data, $keylink);
		$showValues["tel_cel_com"] = $value;
		$showFields[] = "tel_cel_com";
	}	
//	operadora
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("operadora", $data, $keylink);
		$showValues["operadora"] = $value;
		$showFields[] = "operadora";
	}	
//	grupo
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("grupo", $data, $keylink);
		$showValues["grupo"] = $value;
		$showFields[] = "grupo";
	}	
//	faculdade
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("faculdade", $data, $keylink);
		$showValues["faculdade"] = $value;
		$showFields[] = "faculdade";
	}	
//	campus
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("campus", $data, $keylink);
		$showValues["campus"] = $value;
		$showFields[] = "campus";
	}	
//	curso
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("curso", $data, $keylink);
		$showValues["curso"] = $value;
		$showFields[] = "curso";
	}	
//	Tipo de Curso
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("Tipo de Curso", $data, $keylink);
		$showValues["Tipo de Curso"] = $value;
		$showFields[] = "Tipo de Curso";
	}	
//	turno
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("turno", $data, $keylink);
		$showValues["turno"] = $value;
		$showFields[] = "turno";
	}	
//	bolsa
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("bolsa", $data, $keylink);
		$showValues["bolsa"] = $value;
		$showFields[] = "bolsa";
	}	
//	ano_ingresso
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("ano_ingresso", $data, $keylink);
		$showValues["ano_ingresso"] = $value;
		$showFields[] = "ano_ingresso";
	}	
//	semestre_ingresso
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("semestre_ingresso", $data, $keylink);
		$showValues["semestre_ingresso"] = $value;
		$showFields[] = "semestre_ingresso";
	}	
//	semestre_atual
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("semestre_atual", $data, $keylink);
		$showValues["semestre_atual"] = $value;
		$showFields[] = "semestre_atual";
	}	
		$showRawValues["nome"] = substr($data["nome"],0,100);
		$showRawValues["etnia"] = substr($data["etnia"],0,100);
		$showRawValues["sexo"] = substr($data["sexo"],0,100);
		$showRawValues["nascimento"] = substr($data["nascimento"],0,100);
		$showRawValues["cpf"] = substr($data["cpf"],0,100);
		$showRawValues["email"] = substr($data["email"],0,100);
		$showRawValues["tel_residencial"] = substr($data["tel_residencial"],0,100);
		$showRawValues["tel_cel_com"] = substr($data["tel_cel_com"],0,100);
		$showRawValues["operadora"] = substr($data["operadora"],0,100);
		$showRawValues["grupo"] = substr($data["grupo"],0,100);
		$showRawValues["faculdade"] = substr($data["faculdade"],0,100);
		$showRawValues["campus"] = substr($data["campus"],0,100);
		$showRawValues["curso"] = substr($data["curso"],0,100);
		$showRawValues["Tipo de Curso"] = substr($data["Tipo de Curso"],0,100);
		$showRawValues["turno"] = substr($data["turno"],0,100);
		$showRawValues["bolsa"] = substr($data["bolsa"],0,100);
		$showRawValues["ano_ingresso"] = substr($data["ano_ingresso"],0,100);
		$showRawValues["semestre_ingresso"] = substr($data["semestre_ingresso"],0,100);
		$showRawValues["semestre_atual"] = substr($data["semestre_atual"],0,100);
	
	// for custom expression for display field
	if ($dispFieldAlias)
	{
		$showValues[] = $data[$dispFieldAlias];	
		$showFields[] = $dispFieldAlias;
		$showRawValues[] = substr($data[$dispFieldAlias],0,100);
	}
	
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_POPUP)
	{	
		if($IsSaved && count($showValues))
		{
			$returnJSON['success'] = true;
			if($HaveData){
				$returnJSON['noKeys'] = false;
			}else{
				$returnJSON['noKeys'] = true;
			}
			
			$returnJSON['keys'] = $jsKeys;
			$returnJSON['keyFields'] = $keyFields;
			$returnJSON['vals'] = $showValues;
			$returnJSON['fields'] = $showFields;
			$returnJSON['rawVals'] = $showRawValues;
			$returnJSON['detKeys'] = $showDetailKeys;
			$returnJSON['userMess'] = $usermessage;
			$returnJSON['hrefs'] = $pageObject->buildDetailGridLinks($showDetailKeys);
			// add link and display value if list page is lookup with search
			if(array_key_exists('linkField', $linkAndDispVals))
			{
				$returnJSON['linkValue'] = $linkAndDispVals['linkField'];
				$returnJSON['displayValue'] = $linkAndDispVals['displayField'];
			}
			if($globalEvents->exists("IsRecordEditable", $strTableName))
			{ 
				if(!$globalEvents->IsRecordEditable($showRawValues, true, $strTableName))
					$returnJSON['nonEditable'] = true;
			}
			
			if($inlineadd==ADD_POPUP && isset($_SESSION[$strTableName."_count_captcha"]) || $_SESSION[$strTableName."_count_captcha"]>0 || $_SESSION[$strTableName."_count_captcha"]<5)
				$returnJSON['hideCaptcha'] = true;
		}
		else
		{
			$returnJSON['success'] = false;
			$returnJSON['message'] = $message;
			if(!$pageObject->isCaptchaOk)
				$returnJSON['captcha'] = false;
		}
		echo "<textarea>".htmlspecialchars(my_json_encode($returnJSON))."</textarea>";
		exit();
	}
} 

/////////////////////////////////////////////////////////////
if($inlineadd==ADD_MASTER)
{
	$respJSON = array();
	if(($_POST["a"]=="added" && $IsSaved))
	{
		$respJSON['afterAddId'] = $afterAdd_id;
		$respJSON['success'] = true;
		$respJSON['fields'] = $showFields;
		$respJSON['vals'] = $showValues;
		if($onFly){
			if($HaveData)
				$respJSON['noKeys'] = false;
			else
				$respJSON['noKeys'] = true;
			$respJSON['keys'] = $jsKeys;
			$respJSON['keyFields'] = $keyFields;
			$respJSON['rawVals'] = $showRawValues;
			$respJSON['detKeys'] = $showDetailKeys;
			$respJSON['userMess'] = $usermessage;
			$respJSON['hrefs'] = $pageObject->buildDetailGridLinks($showDetailKeys);
			if($globalEvents->exists("IsRecordEditable", $strTableName))
			{
				if(!$globalEvents->IsRecordEditable($showRawValues, true, $strTableName))
					$respJSON['nonEditable'] = true;
			}
		}
		$respJSON['mKeys'] = array();
		for($i=0;$i<count($dpParams['ids']);$i++)
		{
			$data=0;
			if(count($keys))
			{
				$where=KeyWhere($keys);
							$strSQL = $gQuery->gSQLWhere($where);
				LogInfo($strSQL);
				$rs = db_query($strSQL,$conn);
				$data = $pageObject->cipherer->DecryptFetchedArray($rs);
			}
			if(!$data)
				$data=$avalues;
			
			$mKeyId = 1;
			foreach($mKeys[$dpParams['strTableNames'][$i]] as $mk)
			{
				if($data[$mk])
					$respJSON['mKeys'][$dpParams['strTableNames'][$i]]['masterkey'.$mKeyId++] = $data[$mk];
				else
					$respJSON['mKeys'][$dpParams['strTableNames'][$i]]['masterkey'.$mKeyId++] = '';
			}
		}
		if(isset($_SESSION[$strTableName."_count_captcha"]) || $_SESSION[$strTableName."_count_captcha"]>0 || $_SESSION[$strTableName."_count_captcha"]<5)
			$respJSON['hidecaptcha'] = true;
	}
	else{
			$respJSON['success'] = false;
			if(!$pageObject->isCaptchaOk)
				$respJSON['captcha'] = false;
			else
				$respJSON['error'] = $message;
			if($onFly)
				$respJSON['message'] = $message;
		}
	echo "<textarea>".htmlspecialchars(my_json_encode($respJSON))."</textarea>";
	exit();
}

/////////////////////////////////////////////////////////////
//	prepare Edit Controls
/////////////////////////////////////////////////////////////

//	validation stuff
$regex='';
$regexmessage='';
$regextype = '';
$control = array();

foreach($addFields as $fName)
{
	$gfName = GoodFieldName($fName);
	$controls = array('controls'=>array());
	if(!$detailKeys || !in_array($fName, $detailKeys) || $fName == postvalue("category"))
	{
		$control[$gfName] = array();
		$control[$gfName]["func"] = "xt_buildeditcontrol";
		$control[$gfName]["params"] = array();
		$control[$gfName]["params"]["id"] = $id;
		$control[$gfName]["params"]["ptype"] = PAGE_ADD;
		$control[$gfName]["params"]["field"] = $fName;
		$control[$gfName]["params"]["value"] = @$defvalues[$fName];
		$control[$gfName]["params"]["pageObj"] = $pageObject;
		if($pageObject->pSet->isUseRTE($fName))
			$_SESSION[$strTableName."_".$fName."_rte"] = @$defvalues[$fName];
		
		//	Begin Add validation
		$arrValidate = $pageObject->pSet->getValidation($fName);
		$control[$gfName]["params"]["validate"] = $arrValidate;
		//	End Add validation
	}
	$controls["controls"]['ctrlInd'] = 0;
	$controls["controls"]['id'] = $id;
	$controls["controls"]['fieldName'] = $fName;
	//if richEditor for field
	if($pageObject->pSet->isUseRTE($fName))
	{
		if(!$detailKeys || !in_array($fName, $detailKeys))
			$control[$gfName]["params"]["mode"]="add";
		$controls["controls"]['mode'] = "add";
	}
	else
	{
		if($inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		{
			if(!$detailKeys || !in_array($fName, $detailKeys) || $fName == postvalue("category"))	
				$control[$gfName]["params"]["mode"]="inline_add";
			$controls["controls"]['mode'] = "inline_add";
		}
		else
		{
			if(!$detailKeys || !in_array($fName, $detailKeys) || $fName == postvalue("category"))	
				$control[$gfName]["params"]["mode"]="add";
			$controls["controls"]['mode'] = "add";
		}
	}
	
	if(!$detailKeys || !in_array($fName, $detailKeys))
		$xt->assignbyref($gfName."_editcontrol",$control[$gfName]);
	elseif($detailKeys && in_array($fName, $detailKeys))
		$controls["controls"]['value'] = @$defvalues[$fName];
	
	// category control field
	$strCategoryControl = $pageObject->isDependOnField($fName);
	
	if($strCategoryControl!==false && in_array($strCategoryControl, $addFields))
		$vals = array($fName => @$defvalues[$fName], $strCategoryControl => @$defvalues[$strCategoryControl]);
	else
		$vals = array($fName => @$defvalues[$fName]);
	
	$preload = $pageObject->fillPreload($fName, $vals);
	if($preload!==false)
	{
		$controls["controls"]['preloadData'] = $preload;
		if(!@$defvalues[$fName] && count($preload["vals"])>0)
			$defvalues[$fName] = $preload["vals"][0];
	}
	$pageObject->fillControlsMap($controls);
	
	//fill field tool tips
	$pageObject->fillFieldToolTips($fName);
	
	// fill special settings for timepicker
	if($pageObject->pSet->getEditFormat($fName) == 'Time')
		$pageObject->fillTimePickSettings($fName, @$defvalues[$fName]);
	
	if((($detailKeys && in_array($fName, $detailKeys)) || $fName == postvalue("category")) && array_key_exists($fName, $defvalues))
	{
		$value = $pageObject->showDBValue($fName, $defvalues);
		
		$xt->assign($gfName."_editcontrol", $value);
	}
}

//fill tab groups name and sections name to controls
$pageObject->fillCntrlTabGroups();

/////////////////////////////////////////////////////////////
if($pageObject->isShowDetailTables && ($inlineadd==ADD_SIMPLE || $inlineadd==ADD_POPUP) && !isMobile())
{
	if(count($dpParams['ids']))
	{
		$xt->assign("detail_tables",true);
		include('classes/listpage.php');
		include('classes/listpage_embed.php');
		include('classes/listpage_dpinline.php');
		include("classes/searchclause.php");
	}
	
	$dControlsMap = array();
	$dViewControlsMap = array();
		
	$flyId = $ids+1;
	for($d=0;$d<count($dpParams['ids']);$d++)
	{
		$options = array();
		//array of params for classes
		$options["mode"] = LIST_DETAILS;
		$options["pageType"] = PAGE_LIST;
		$options["masterPageType"] = PAGE_ADD;
		$options["mainMasterPageType"] = PAGE_ADD;
		$options['masterTable'] = "bolsistas_nucleo";
		$options['firstTime'] = 1;
		
		$strTableName = $dpParams['strTableNames'][$d];
		include_once("include/".GetTableURL($strTableName)."_settings.php");
		
		$layout = GetPageLayout(GoodFieldName($strTableName), PAGE_LIST);
		if($layout)
		{
			$rtl = $xt->getReadingOrder() == 'RTL' ? 'RTL' : '';
			$xt->cssFiles[] = array("stylepath" => "styles/".$layout->style.'/style'.$rtl.".css"
				, "pagestylepath" => "pagestyles/".$layout->name.$rtl.".css");
			$xt->IEcssFiles[] = array("stylepathIE" => "styles/".$layout->style.'/styleIE'.".css");
		}	
			
		$options['xt'] = new Xtempl();
		$options['id'] = $dpParams['ids'][$d];
		$options['flyId'] = $flyId++;
		$mkr = 1;
		
		foreach($mKeys[$strTableName] as $mk)
		{
			if($defvalues[$mk])
				$options['masterKeysReq'][$mkr++] = $defvalues[$mk];
			else
				$options['masterKeysReq'][$mkr++] = '';
		}
		$listPageObject = ListPage::createListPage($strTableName,$options);
		
		// prepare code
		$listPageObject->prepareForBuildPage();
		$flyId = $listPageObject->recId+1;
		
		//set page events
		foreach($listPageObject->eventsObject->events as $event => $name)
			$listPageObject->xt->assign_event($event, $listPageObject->eventsObject, $event, array());
		
		//add detail settings to master settings
		$listPageObject->addControlsJSAndCSS();
		$listPageObject->fillSetCntrlMaps();
		$pageObject->jsSettings['tableSettings'][$strTableName]	= $listPageObject->jsSettings['tableSettings'][$strTableName];

		$dControlsMap[$strTableName] = $listPageObject->controlsMap;
		$dViewControlsMap[$strTableName] = $listPageObject->viewControlsMap;
		
		foreach($listPageObject->jsSettings["global"]["shortTNames"] as $tName => $shortTName){
			$pageObject->settingsMap["globalSettings"]["shortTNames"][$tName] = $shortTName;
		}
		
		//Add detail's js files to master's files
		$pageObject->copyAllJSFiles($listPageObject->grabAllJSFiles());
		
		//Add detail's css files to master's files
		$pageObject->copyAllCSSFiles($listPageObject->grabAllCSSFiles());
		
		$xtParams = array("method"=>'showPage', "params"=> false);
		$xtParams['object'] = $listPageObject;
		$xt->assign("displayDetailTable_".GoodFieldName($listPageObject->tName), $xtParams);
		$pageObject->controlsMap['dpTablesParams'][] = array('tName'=>$strTableName, 'id'=>$options['id']);
	}
	$pageObject->controlsMap['dControlsMap'] = $dControlsMap;
	$pageObject->viewControlsMap['dViewControlsMap'] = $dViewControlsMap;
	$strTableName = "bolsistas_nucleo";
}
/////////////////////////////////////////////////////////////
//fill jsSettings and ControlsHTMLMap
$pageObject->fillSetCntrlMaps();

$pageObject->addCommonJs();

//For mobile version in apple device

if($inlineadd == ADD_SIMPLE)
{
	$pageObject->body['end'] = array();
	$pageObject->body['end']["method"] = "assignBodyEnd";
	$pageObject->body['end']["object"] = &$pageObject;
	$xt->assign("body", $pageObject->body);
	$xt->assign("flybody",true);
}

if($inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_MASTER || $inlineadd==ADD_POPUP)
{ 
	$xt->assign("footer",false);
	$xt->assign("header",false);
	$xt->assign("flybody", $pageObject->body);
	$xt->assign("body",true);
}	

$xt->assign("style_block",true);
$pageObject->xt->assign("legend", true);

if($eventObj->exists("BeforeShowAdd"))
	$eventObj->BeforeShowAdd($xt, $templatefile, $pageObject);
	
if($inlineadd != ADD_SIMPLE)
{
	$returnJSON['controlsMap'] = $pageObject->controlsHTMLMap;
	$returnJSON['viewControlsMap'] = $pageObject->viewControlsHTMLMap;
	$returnJSON['settings'] = $pageObject->jsSettings;	
}

if($inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
{
	$xt->load_template($templatefile);
	$returnJSON['html'] = $xt->fetch_loaded('style_block').$xt->fetch_loaded('body');
	if(count($pageObject->includes_css))
		$returnJSON['CSSFiles'] = array_unique($pageObject->includes_css);
	if(count($pageObject->includes_cssIE))
		$returnJSON['CSSFilesIE'] = array_unique($pageObject->includes_cssIE);
	$returnJSON["additionalJS"] = $pageObject->grabAllJsFiles();
	$returnJSON['idStartFrom'] = $id+1;	
	echo (my_json_encode($returnJSON)); 
}
elseif ($inlineadd == ADD_INLINE)
{
	$xt->load_template($templatefile);
	$returnJSON["html"] = array();
	foreach($addFields as $fName)
	{
		$returnJSON["html"][$fName] = $xt->fetchVar(GoodFieldName($fName)."_editcontrol");	
	}	
	$returnJSON["additionalJS"] = $pageObject->grabAllJsFiles();
	$returnJSON["additionalCSS"] = $pageObject->grabAllCSSFiles();
	echo (my_json_encode($returnJSON)); 
}
else
	$xt->display($templatefile);

function GetAddedDataLookupQuery($pageObject, $keys, $forLookup)
{
	global $conn, $strTableName, $strOriginalTableName;
	
	$LookupSQL = "";
	$linkfield = "";
	$dispfield = "";
	$noBlobReplace = false;
	$lookupFieldName = "";
	
	if($LookupSQL && $nLookupType != LT_QUERY)
		$LookupSQL.=" from ".AddTableWrappers($strOriginalTableName);
		
	$data = 0;
	$lookupIndexes = array("linkFieldIndex" => 0, "displayFieldIndex" => 0);
	if(count($keys))
	{
		$where = KeyWhere($keys);
		if($nLookupType == LT_QUERY){
			$LookupSQL = $lookupQueryObj->toSql(whereAdd($lookupQueryObj->m_where->toSql($lookupQueryObj), $where));
		}else 
			$LookupSQL.=" where ".$where;
		$lookupIndexes = GetLookupFieldsIndexes($lookupPSet, $lookupFieldName);
		LogInfo($LookupSQL);
		if($forLookup){
			$rs=db_query($LookupSQL,$conn);
			$data = $pageObject->cipherer->DecryptFetchedArray($rs);
		}else if($LookupSQL)
		{
			$rs = db_query($LookupSQL,$conn);
			$data = db_fetch_numarray($rs);
			$data[$lookupIndexes["linkFieldIndex"]] = $pageObject->cipherer->DecryptField($linkFieldName, $data[$lookupIndexes["linkFieldIndex"]]);
			if($nLookupType == LT_QUERY)
				$data[$lookupIndexes["displayFieldIndex"]] = $pageObject->cipherer->DecryptField($dispfield, $data[$lookupIndexes["displayFieldIndex"]]);		
		}
	}

	return array($data, array("linkField" => $linkFieldName, "displayField" => $dispfield
		, "linkFieldIndex" => $lookupIndexes["linkFieldIndex"], "displayFieldIndex" => $lookupIndexes["displayFieldIndex"]));
}	
	
?>
