<?php

$dal_info=array();


function CustomQuery($dalSQL)
{
	global $conn;
	$rs = db_query($dalSQL,$conn);
	  return $rs;
}

function UsersTableName()
{
	return "`senuc_login`";
}

function DBLookup($sql)
{
	
	global $conn;
	$rs = db_query($sql,$conn);
	$data = db_fetch_array($rs);
	if ($data)
		return reset($data);
	  
	return null;
}

/**
  * Data Access Layer.
  */
class tDAL
{
	var $senuc_aluno;
	var $senuc_coordenador;
	var $senucnovo_ugrights;
	var $senuc_login;
	var $professor;
	var $senuc_professores;
	var $senuc_frequencias;
	var $senuc_config;
	var $senuc_nucleo;
	var $senuc_score;
	var $senuc_score_geral;
	var $senuc_atividades;
	var $senuc_atividades_aluno;
	var $senuc_plantoes;
	var $senuc_plantoes_aluno;
	var $senuc_contribuicoes;
	var $senuc_aprovacoes;
	var $senuc_turmas;
	var $senuc_descomplica;
	var $senuc_descomplica_avaliacao;
	var $senuc_descomplica_logins;
	var $senuc_aluno_acessos_descomplica;
	var $senuc_certificados_voluntario;
	var $senuc_tipo_coordenador;
	var $regiao;
	var $senuc_professor_tipo;
	var $senuc_tipo;
	var $senuc_preparar;
	var $operadora;
	var $etnia;
	var $renda;
	var $tb_estados;
	var $tb_cidades;
	var $escolaridade;
	var $cursos;
	var $senuc_motivos;
	var $senuc_categoria;
	var $senuc_tipo_atividade;
	var $materias;
	var $semana;
	var $associados;
	var $senuc_tipo_voluntario;
	var $regionais;
	var $senuc_audit;
	var $senucnovo_uggroups;
	var $senucnovo_ugmembers;
	var $lstTables;
	var $Table=array();

	function FillTablesList()
	{
		if($this->lstTables)
			return;
	  $this->lstTables[]=array("name"=>"senuc_aluno","varname"=>"senuc_aluno");
	  $this->lstTables[]=array("name"=>"senuc_coordenador","varname"=>"senuc_coordenador");
	  $this->lstTables[]=array("name"=>"senucnovo_ugrights","varname"=>"senucnovo_ugrights");
	  $this->lstTables[]=array("name"=>"senuc_login","varname"=>"senuc_login");
	  $this->lstTables[]=array("name"=>"professor","varname"=>"professor");
	  $this->lstTables[]=array("name"=>"senuc_professores","varname"=>"senuc_professores");
	  $this->lstTables[]=array("name"=>"senuc_frequencias","varname"=>"senuc_frequencias");
	  $this->lstTables[]=array("name"=>"senuc_config","varname"=>"senuc_config");
	  $this->lstTables[]=array("name"=>"senuc_nucleo","varname"=>"senuc_nucleo");
	  $this->lstTables[]=array("name"=>"senuc_score","varname"=>"senuc_score");
	  $this->lstTables[]=array("name"=>"senuc_score_geral","varname"=>"senuc_score_geral");
	  $this->lstTables[]=array("name"=>"senuc_atividades","varname"=>"senuc_atividades");
	  $this->lstTables[]=array("name"=>"senuc_atividades_aluno","varname"=>"senuc_atividades_aluno");
	  $this->lstTables[]=array("name"=>"senuc_plantoes","varname"=>"senuc_plantoes");
	  $this->lstTables[]=array("name"=>"senuc_plantoes_aluno","varname"=>"senuc_plantoes_aluno");
	  $this->lstTables[]=array("name"=>"senuc_contribuicoes","varname"=>"senuc_contribuicoes");
	  $this->lstTables[]=array("name"=>"senuc_aprovacoes","varname"=>"senuc_aprovacoes");
	  $this->lstTables[]=array("name"=>"senuc_turmas","varname"=>"senuc_turmas");
	  $this->lstTables[]=array("name"=>"senuc_descomplica","varname"=>"senuc_descomplica");
	  $this->lstTables[]=array("name"=>"senuc_descomplica_avaliacao","varname"=>"senuc_descomplica_avaliacao");
	  $this->lstTables[]=array("name"=>"senuc_descomplica_logins","varname"=>"senuc_descomplica_logins");
	  $this->lstTables[]=array("name"=>"senuc_aluno_acessos_descomplica","varname"=>"senuc_aluno_acessos_descomplica");
	  $this->lstTables[]=array("name"=>"senuc_certificados_voluntario","varname"=>"senuc_certificados_voluntario");
	  $this->lstTables[]=array("name"=>"senuc_tipo_coordenador","varname"=>"senuc_tipo_coordenador");
	  $this->lstTables[]=array("name"=>"regiao","varname"=>"regiao");
	  $this->lstTables[]=array("name"=>"senuc_professor_tipo","varname"=>"senuc_professor_tipo");
	  $this->lstTables[]=array("name"=>"senuc_tipo","varname"=>"senuc_tipo");
	  $this->lstTables[]=array("name"=>"senuc_preparar","varname"=>"senuc_preparar");
	  $this->lstTables[]=array("name"=>"operadora","varname"=>"operadora");
	  $this->lstTables[]=array("name"=>"etnia","varname"=>"etnia");
	  $this->lstTables[]=array("name"=>"renda","varname"=>"renda");
	  $this->lstTables[]=array("name"=>"tb_estados","varname"=>"tb_estados");
	  $this->lstTables[]=array("name"=>"tb_cidades","varname"=>"tb_cidades");
	  $this->lstTables[]=array("name"=>"escolaridade","varname"=>"escolaridade");
	  $this->lstTables[]=array("name"=>"cursos","varname"=>"cursos");
	  $this->lstTables[]=array("name"=>"senuc_motivos","varname"=>"senuc_motivos");
	  $this->lstTables[]=array("name"=>"senuc_categoria","varname"=>"senuc_categoria");
	  $this->lstTables[]=array("name"=>"senuc_tipo_atividade","varname"=>"senuc_tipo_atividade");
	  $this->lstTables[]=array("name"=>"materias","varname"=>"materias");
	  $this->lstTables[]=array("name"=>"semana","varname"=>"semana");
	  $this->lstTables[]=array("name"=>"associados","varname"=>"associados");
	  $this->lstTables[]=array("name"=>"senuc_tipo_voluntario","varname"=>"senuc_tipo_voluntario");
	  $this->lstTables[]=array("name"=>"regionais","varname"=>"regionais");
	  $this->lstTables[]=array("name"=>"senuc_audit","varname"=>"senuc_audit");
	  $this->lstTables[]=array("name"=>"senucnovo_uggroups","varname"=>"senucnovo_uggroups");
	  $this->lstTables[]=array("name"=>"senucnovo_ugmembers","varname"=>"senucnovo_ugmembers");
	}

	/**
      * Returns table object by table name.
      * @intellisense
      */
	function & Table($strTable)
	{
		$this->FillTablesList();
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper($strTable)==strtoupper($tbl["name"]))
			{
				$this->CreateClass($tbl);
				return $this->{$tbl["varname"]};
			}
		}
//	check table names without dbo. and other prefixes
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper(cutprefix($strTable))==strtoupper(cutprefix($tbl["name"])))
			{
				$this->CreateClass($tbl);
				return $this->{$tbl["varname"]};
			}
		}
		$dummy=null;
		return $dummy;
	}
	function CreateClass(&$tbl)
	{
		if($this->{$tbl["varname"]})
			return;
//	load table info
		global $dal_info;
		include(getabspath("include/dal/".GoodFieldName($tbl["name"]).".php"));
//	create class and object

		$str = "class class_".GoodFieldName($tbl["name"])." extends tDALTable  {";
		foreach($dal_info[$tbl["name"]] as $fld)
		{
			$str.=' var $'.$fld["varname"].'; ';
		}
		$str.=' function class_'.GoodFieldName($tbl["name"]).'()
			{
				$this->m_TableName = \''.escapesq($tbl["name"]).'\';
			}
		};';
		eval($str);
		$classname="class_".GoodFieldName($tbl["name"]);
		$this->{$tbl["varname"]} = new $classname;
		$this->Table[$tbl["name"]]=&$this->{$tbl["varname"]};
	}
	
	/**
      * Returns list of table names.
      * @intellisense
      */
	function GetTablesList()
	{
		$this->FillTablesList();
		$res=array();
		foreach($this->lstTables as $tbl)
			$res[]=$tbl["name"];
		return $res;
	}
	
	/**
      * Get list of table fields by table name.
      * @intellisense
      */
	function GetFieldsList($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldsList();
	}
	
	/**
      * Get field type by table name and field name.
      * @intellisense
      */
	function GetFieldType($table,$field)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldType($field);
	}

	/**
      * Get table key fields by table name.
      * @intellisense
      */
	function GetDBTableKeys($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetDBTableKeys();
	}
}

$dal = new tDAL;

/**
  *  Data Access Layer table class.
  */ 
class tDALTable
{
	var $m_TableName;
	var $Param = array();
	var $Value = array();

	/**
      * Get table key fields.
      * @intellisense
      */
	function GetDBTableKeys()
	{
		global $dal_info;
		if(!array_key_exists($this->m_TableName,$dal_info) || !is_array($dal_info[$this->m_TableName]))
		{
			return array();
		}
		$ret=array();
		foreach($dal_info[$this->m_TableName] as $fname=>$f)
		{
			if(@$f["key"])
				$ret[]=$fname;
		}
		return $ret;
	}
	
	/**
      * Get list of table fields.
      * @intellisense
      */
	function GetFieldsList()
	{
		global $dal_info;
		return array_keys($dal_info[$this->m_TableName]);
	}

	/**
      * Get field type.
      * @intellisense
      */
	function GetFieldType($field)
	{
		global $dal_info;
		if(!array_key_exists($field,$dal_info[$this->m_TableName]))
			return 200;
		return $dal_info[$this->m_TableName][$field]["type"];
	}
	
	function PrepareValue($value,$type)
	{
	
		if(IsDateFieldType($type))
			return db_datequotes($value);
		if (NeedQuotes($type))
			return db_prepare_string($value);
		else
			return (0+$value);
	}
	
	/**
      * Get table name.
      * @intellisense
      */
	function TableName()
	{
		return AddTableWrappers($this->m_TableName);
	} 

	function Execute_Query($blobs,$dalSQL,$tableinfo)
	{
	global $conn;
				db_exec($dalSQL,$conn);
	}

	/**
      * Add new record to the table.
      * @intellisense
      */
	function Add() 
	{
		global $conn,$dal_info;
		$insertFields="";
		$insertValues="";
		$tableinfo = &$dal_info[$this->m_TableName];
		$blobs = array();
//	prepare parameters		
		foreach($tableinfo as $fieldname=>$fld)
		{
			if(isset($this->{$fld['varname']}))
			{
				$this->Value[$fieldname] = $this->{$fld['varname']};
			}
			foreach($this->Value as $field=>$value)
			{
				if (strtoupper($field)!=strtoupper($fieldname))
					continue;
				$insertFields.= AddFieldWrappers($fieldname).",";
				$insertValues.= $this->PrepareValue($value,$fld["type"]) . ",";
				break;
			}
		}
//	prepare and exec SQL
		if ($insertFields!="" && $insertValues!="")		
		{
			$insertFields = substr($insertFields,0,-1);
			$insertValues = substr($insertValues,0,-1);
			$dalSQL = "insert into ".AddTableWrappers($this->m_TableName)." (".$insertFields.") values (".$insertValues.")";
			$this->Execute_Query($blobs,$dalSQL,$tableinfo);
		}
//	cleanup		
	    $this->Reset();
	}

	/**
      * Query all records from the table.
      * @intellisense
      */
	function QueryAll()
	{
		global $conn;
		$dalSQL = "select * from ".AddTableWrappers($this->m_TableName);
		$rs = db_query($dalSQL,$conn);
		return $rs;
	}

	/**
      * Do a custom query on the table.
      * @intellisense
      */
	function Query($swhere="",$orderby="")
	{
		global $conn;
		if ($swhere)
			$swhere = " where ".$swhere;
		if ($orderby)
			$orderby = " order by ".$orderby;
		$dalSQL = "select * from ".AddTableWrappers($this->m_TableName).$swhere.$orderby;
		$rs = db_query($dalSQL,$conn);
		return $rs;
	}

	/**
      * Delete a record from the table.
      * @intellisense
      */
	function Delete()
	{
		global $conn,$dal_info;
		$deleteFields="";
		$tableinfo = &$dal_info[$this->m_TableName];
//	prepare parameters		
		foreach($tableinfo as $fieldname=>$fld)
		{
			if(isset($this->{$fld['varname']}))
			{
				$this->Param[$fieldname] = $this->{$fld['varname']};
			}
			
			foreach($this->Param as $field=>$value)
			{
				if (strtoupper($field)!=strtoupper($fieldname))
					continue;
				$deleteFields.= AddFieldWrappers($fieldname)."=". $this->PrepareValue($value,$fld["type"]) . " and ";
				break;
			}
		}
//	do delete
		if ($deleteFields)
		{
			$deleteFields = substr($deleteFields,0,-5);
			$dalSQL = "delete from ".AddTableWrappers($this->m_TableName)." where ".$deleteFields;
			db_exec($dalSQL,$conn);
		}
	
//	cleanup
	    $this->Reset();
	}

	/**
      * Reset table object.
      * @intellisense
      */
	function Reset()
	{
		$this->Value=array();
		$this->Param=array();
		global $dal_info;
		$tableinfo = &$dal_info[$this->m_TableName];
//	prepare parameters		
		foreach($tableinfo as $fieldname=>$fld)
		{
			unset($this->{$fld["varname"]});
		}
	}	

	/**
      * Update record in the table.
      * @intellisense
      */
	function Update()
	{
		global $conn,$dal_info;
		$tableinfo = &$dal_info[$this->m_TableName];
		$updateParam = "";
		$updateValue = "";
		$blobs = array();

		foreach($tableinfo as $fieldname=>$fld)
		{
			$command='if(isset($this->'.$fld['varname'].')) { ';
			if($fld["key"])
				$command.='$this->Param[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			else
				$command.='$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.=' }';
			eval($command);
			if(!$fld["key"] && !array_key_exists(strtoupper($fieldname),array_change_key_case($this->Param,CASE_UPPER)))
			{
				foreach($this->Value as $field=>$value)
				{
					if (strtoupper($field)!=strtoupper($fieldname))
						continue;
					$updateValue.= AddFieldWrappers($fieldname)."=".$this->PrepareValue($value,$fld["type"]) . ", ";
					break;
				}
			}
			else
			{
				foreach($this->Param as $field=>$value)
				{
					if (strtoupper($field)!=strtoupper($fieldname))
						continue;
					$updateParam.= AddFieldWrappers($fieldname)."=".$this->PrepareValue($value,$fld["type"]) . " and ";
					break;
				}
			}
		}

//	construct SQL and do update	
		if ($updateParam)
			$updateParam = substr($updateParam,0,-5);
		if ($updateValue)
			$updateValue = substr($updateValue,0,-2);
		if ($updateValue && $updateParam)
		{
			$dalSQL = "update ".AddTableWrappers($this->m_TableName)." set ".$updateValue." where ".$updateParam;
			$this->Execute_Query($blobs,$dalSQL,$tableinfo);
		}

//	cleanup
		$this->Reset();
	}

	function FetchByID()
	{
		global $conn,$dal_info;
		$tableinfo = &$dal_info[$this->m_TableName];

		$dal_where="";
		foreach($tableinfo as $fieldname=>$fld)
		{
			$command='if(isset($this->'.$fld['varname'].')) { ';
			$command.='$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.=' }';
			eval($command);
			foreach($this->Param as $field=>$value)
			{
				if (strtoupper($field)!=strtoupper($fieldname))
				continue;
				$dal_where.= AddFieldWrappers($fieldname)."=".$this->PrepareValue($value,$fld["type"]) . " and ";
				break;
			}
		}
		// cleanup
		$this->Reset();
		// construct and run SQL
		if ($dal_where)
			$dal_where = " where ".substr($dal_where,0,-5);
		$dalSQL = "select * from ".AddTableWrappers($this->m_TableName).$dal_where;
		$rs = db_query($dalSQL,$conn);
		return $rs;
	}
}


class DalRecordset
{
	
	var $m_rs;
	var $m_fields;
	var $m_eof;
	
	function Fields($field="")
	{
		if(!$field)
			return $this->m_fields;
		return $this->Field($field);
	}
	
	function Field($field)
	{
		if($this->m_eof)
			return false;
		foreach($this->m_fields as $name=>$value)
		{
			if(!strcasecmp($name,$field))
				return $value;
		}
		return false;
	}
	function DalRecordset($rs)
	{
		$this->m_rs=$rs;
		$this->MoveNext();
	}
	function EOF()
	{
		return $this->m_eof;
	}
	
	function MoveNext()
	{
		if(!$this->m_eof)
			$this->m_fields=db_fetch_array($this->m_rs);
		$this->m_eof = !$this->m_fields;
		return !$this->m_eof;
	}
}

function cutprefix($table)
{
	$pos=strpos($table,".");
	if($pos===false)
		return $table;
	return substr($table,$pos+1);
}

function escapesq($str)
{
	return str_replace(array("\\","'"),array("\\\\","\\'"),$str);
}

?>