<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

	$lookupTableLinks["senuc_nucleo"]["senuc_aluno.idnucleo"]["edit"] = array("table" => "senuc_aluno", "field" => "idnucleo", "page" => "edit");
	$lookupTableLinks["associados"]["senuc_aluno.cpf"]["edit"] = array("table" => "senuc_aluno", "field" => "cpf", "page" => "edit");
	$lookupTableLinks["operadora"]["senuc_aluno.operadora"]["edit"] = array("table" => "senuc_aluno", "field" => "operadora", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["senuc_aluno.cidade"]["edit"] = array("table" => "senuc_aluno", "field" => "cidade", "page" => "edit");
	$lookupTableLinks["tb_estados"]["senuc_aluno.estado"]["edit"] = array("table" => "senuc_aluno", "field" => "estado", "page" => "edit");
	$lookupTableLinks["etnia"]["senuc_aluno.etnia"]["edit"] = array("table" => "senuc_aluno", "field" => "etnia", "page" => "edit");
	$lookupTableLinks["renda"]["senuc_aluno.renda"]["edit"] = array("table" => "senuc_aluno", "field" => "renda", "page" => "edit");
	$lookupTableLinks["escolaridade"]["senuc_aluno.escolaridade"]["edit"] = array("table" => "senuc_aluno", "field" => "escolaridade", "page" => "edit");
	$lookupTableLinks["senuc_preparar"]["senuc_aluno.preparar_para"]["edit"] = array("table" => "senuc_aluno", "field" => "preparar_para", "page" => "edit");
	$lookupTableLinks["senuc_motivos"]["senuc_aluno.motivo"]["edit"] = array("table" => "senuc_aluno", "field" => "motivo", "page" => "edit");
	$lookupTableLinks["regionais"]["senuc_aluno.idregional"]["edit"] = array("table" => "senuc_aluno", "field" => "idregional", "page" => "edit");
	$lookupTableLinks["senuc_turmas"]["senuc_aluno.id_turma"]["edit"] = array("table" => "senuc_aluno", "field" => "id_turma", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_coordenador.idnucleo"]["edit"] = array("table" => "senuc_coordenador", "field" => "idnucleo", "page" => "edit");
	$lookupTableLinks["associados"]["senuc_coordenador.cpf"]["edit"] = array("table" => "senuc_coordenador", "field" => "cpf", "page" => "edit");
	$lookupTableLinks["senuc_tipo_coordenador"]["senuc_coordenador.tipo_coordenador"]["edit"] = array("table" => "senuc_coordenador", "field" => "tipo_coordenador", "page" => "edit");
	$lookupTableLinks["tb_estados"]["senuc_coordenador.estado"]["edit"] = array("table" => "senuc_coordenador", "field" => "estado", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["senuc_coordenador.cidade"]["edit"] = array("table" => "senuc_coordenador", "field" => "cidade", "page" => "edit");
	$lookupTableLinks["operadora"]["senuc_coordenador.operadora"]["edit"] = array("table" => "senuc_coordenador", "field" => "operadora", "page" => "edit");
	$lookupTableLinks["etnia"]["senuc_coordenador.etnia"]["edit"] = array("table" => "senuc_coordenador", "field" => "etnia", "page" => "edit");
	$lookupTableLinks["renda"]["senuc_coordenador.renda"]["edit"] = array("table" => "senuc_coordenador", "field" => "renda", "page" => "edit");
	$lookupTableLinks["escolaridade"]["senuc_coordenador.escolaridade"]["edit"] = array("table" => "senuc_coordenador", "field" => "escolaridade", "page" => "edit");
	$lookupTableLinks["senuc_motivos"]["senuc_coordenador.motivo"]["edit"] = array("table" => "senuc_coordenador", "field" => "motivo", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["admin_members.idnucleo"]["edit"] = array("table" => "admin_members", "field" => "idnucleo", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["admin_users.idnucleo"]["edit"] = array("table" => "admin_users", "field" => "idnucleo", "page" => "edit");
	$lookupTableLinks["operadora"]["professor.operadora"]["edit"] = array("table" => "professor", "field" => "operadora", "page" => "edit");
	$lookupTableLinks["regiao"]["professor.regiao"]["edit"] = array("table" => "professor", "field" => "regiao", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["professor.cidade"]["edit"] = array("table" => "professor", "field" => "cidade", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["professor.cidade"]["search"] = array("table" => "professor", "field" => "cidade", "page" => "search");
	$lookupTableLinks["tb_estados"]["professor.estado"]["edit"] = array("table" => "professor", "field" => "estado", "page" => "edit");
	$lookupTableLinks["escolaridade"]["professor.grupo"]["edit"] = array("table" => "professor", "field" => "grupo", "page" => "edit");
	$lookupTableLinks["cursos"]["professor.curso"]["edit"] = array("table" => "professor", "field" => "curso", "page" => "edit");
	$lookupTableLinks["materias"]["professor.materias"]["edit"] = array("table" => "professor", "field" => "materias", "page" => "edit");
	$lookupTableLinks["semana"]["professor.manha"]["edit"] = array("table" => "professor", "field" => "manha", "page" => "edit");
	$lookupTableLinks["semana"]["professor.tarde"]["edit"] = array("table" => "professor", "field" => "tarde", "page" => "edit");
	$lookupTableLinks["semana"]["professor.noite"]["edit"] = array("table" => "professor", "field" => "noite", "page" => "edit");
	$lookupTableLinks["associados"]["senuc_professores.cpf"]["edit"] = array("table" => "senuc_professores", "field" => "cpf", "page" => "edit");
	$lookupTableLinks["operadora"]["senuc_professores.operadora"]["edit"] = array("table" => "senuc_professores", "field" => "operadora", "page" => "edit");
	$lookupTableLinks["etnia"]["senuc_professores.etnia"]["edit"] = array("table" => "senuc_professores", "field" => "etnia", "page" => "edit");
	$lookupTableLinks["renda"]["senuc_professores.renda"]["edit"] = array("table" => "senuc_professores", "field" => "renda", "page" => "edit");
	$lookupTableLinks["tb_estados"]["senuc_professores.estado"]["edit"] = array("table" => "senuc_professores", "field" => "estado", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["senuc_professores.cidade"]["edit"] = array("table" => "senuc_professores", "field" => "cidade", "page" => "edit");
	$lookupTableLinks["escolaridade"]["senuc_professores.escolaridade"]["edit"] = array("table" => "senuc_professores", "field" => "escolaridade", "page" => "edit");
	$lookupTableLinks["cursos"]["senuc_professores.curso"]["edit"] = array("table" => "senuc_professores", "field" => "curso", "page" => "edit");
	$lookupTableLinks["materias"]["senuc_professores.materias"]["edit"] = array("table" => "senuc_professores", "field" => "materias", "page" => "edit");
	$lookupTableLinks["senuc_motivos"]["senuc_professores.motivo"]["edit"] = array("table" => "senuc_professores", "field" => "motivo", "page" => "edit");
	$lookupTableLinks["senuc_professor_tipo"]["senuc_professores.tipo"]["edit"] = array("table" => "senuc_professores", "field" => "tipo", "page" => "edit");
	$lookupTableLinks["senuc_categoria"]["senuc_frequencias.categoria"]["edit"] = array("table" => "senuc_frequencias", "field" => "categoria", "page" => "edit");
	$lookupTableLinks["regionais"]["senuc_nucleo.idregional"]["edit"] = array("table" => "senuc_nucleo", "field" => "idregional", "page" => "edit");
	$lookupTableLinks["tb_estados"]["senuc_nucleo.estado"]["edit"] = array("table" => "senuc_nucleo", "field" => "estado", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["senuc_nucleo.cidade"]["edit"] = array("table" => "senuc_nucleo", "field" => "cidade", "page" => "edit");
	$lookupTableLinks["senuc_tipo"]["senuc_nucleo.tipo"]["edit"] = array("table" => "senuc_nucleo", "field" => "tipo", "page" => "edit");
	$lookupTableLinks["operadora"]["senuc_nucleo.operadora"]["edit"] = array("table" => "senuc_nucleo", "field" => "operadora", "page" => "edit");
	$lookupTableLinks["senuc_preparar"]["senuc_nucleo.prepara_para"]["edit"] = array("table" => "senuc_nucleo", "field" => "prepara_para", "page" => "edit");
	$lookupTableLinks["semana"]["senuc_nucleo.funciona_em"]["edit"] = array("table" => "senuc_nucleo", "field" => "funciona_em", "page" => "edit");
	$lookupTableLinks["senuc_motivos"]["senuc_nucleo.motivo"]["edit"] = array("table" => "senuc_nucleo", "field" => "motivo", "page" => "edit");
	$lookupTableLinks["tb_estados"]["nucleos_presenciais.estado"]["edit"] = array("table" => "nucleos_presenciais", "field" => "estado", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["nucleos_presenciais.cidade"]["edit"] = array("table" => "nucleos_presenciais", "field" => "cidade", "page" => "edit");
	$lookupTableLinks["senuc_tipo"]["nucleos_presenciais.tipo"]["edit"] = array("table" => "nucleos_presenciais", "field" => "tipo", "page" => "edit");
	$lookupTableLinks["operadora"]["nucleos_presenciais.operadora"]["edit"] = array("table" => "nucleos_presenciais", "field" => "operadora", "page" => "edit");
	$lookupTableLinks["senuc_preparar"]["nucleos_presenciais.prepara_para"]["edit"] = array("table" => "nucleos_presenciais", "field" => "prepara_para", "page" => "edit");
	$lookupTableLinks["semana"]["nucleos_presenciais.funciona_em"]["edit"] = array("table" => "nucleos_presenciais", "field" => "funciona_em", "page" => "edit");
	$lookupTableLinks["senuc_motivos"]["nucleos_presenciais.motivo"]["edit"] = array("table" => "nucleos_presenciais", "field" => "motivo", "page" => "edit");
	$lookupTableLinks["tb_estados"]["nucleos_virtuais.estado"]["edit"] = array("table" => "nucleos_virtuais", "field" => "estado", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["nucleos_virtuais.cidade"]["edit"] = array("table" => "nucleos_virtuais", "field" => "cidade", "page" => "edit");
	$lookupTableLinks["senuc_tipo"]["nucleos_virtuais.tipo"]["edit"] = array("table" => "nucleos_virtuais", "field" => "tipo", "page" => "edit");
	$lookupTableLinks["operadora"]["nucleos_virtuais.operadora"]["edit"] = array("table" => "nucleos_virtuais", "field" => "operadora", "page" => "edit");
	$lookupTableLinks["senuc_preparar"]["nucleos_virtuais.prepara_para"]["edit"] = array("table" => "nucleos_virtuais", "field" => "prepara_para", "page" => "edit");
	$lookupTableLinks["semana"]["nucleos_virtuais.funciona_em"]["edit"] = array("table" => "nucleos_virtuais", "field" => "funciona_em", "page" => "edit");
	$lookupTableLinks["senuc_motivos"]["nucleos_virtuais.motivo"]["edit"] = array("table" => "nucleos_virtuais", "field" => "motivo", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_login.idnucleo"]["edit"] = array("table" => "senuc_login", "field" => "idnucleo", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_aluno_regional.idnucleo"]["edit"] = array("table" => "senuc_aluno_regional", "field" => "idnucleo", "page" => "edit");
	$lookupTableLinks["operadora"]["senuc_aluno_regional.operadora"]["edit"] = array("table" => "senuc_aluno_regional", "field" => "operadora", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["senuc_aluno_regional.cidade"]["edit"] = array("table" => "senuc_aluno_regional", "field" => "cidade", "page" => "edit");
	$lookupTableLinks["tb_estados"]["senuc_aluno_regional.estado"]["edit"] = array("table" => "senuc_aluno_regional", "field" => "estado", "page" => "edit");
	$lookupTableLinks["etnia"]["senuc_aluno_regional.etnia"]["edit"] = array("table" => "senuc_aluno_regional", "field" => "etnia", "page" => "edit");
	$lookupTableLinks["renda"]["senuc_aluno_regional.renda"]["edit"] = array("table" => "senuc_aluno_regional", "field" => "renda", "page" => "edit");
	$lookupTableLinks["escolaridade"]["senuc_aluno_regional.escolaridade"]["edit"] = array("table" => "senuc_aluno_regional", "field" => "escolaridade", "page" => "edit");
	$lookupTableLinks["senuc_preparar"]["senuc_aluno_regional.preparar_para"]["edit"] = array("table" => "senuc_aluno_regional", "field" => "preparar_para", "page" => "edit");
	$lookupTableLinks["senuc_motivos"]["senuc_aluno_regional.motivo"]["edit"] = array("table" => "senuc_aluno_regional", "field" => "motivo", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_coordenador_regional.idnucleo"]["edit"] = array("table" => "senuc_coordenador_regional", "field" => "idnucleo", "page" => "edit");
	$lookupTableLinks["tb_estados"]["senuc_coordenador_regional.estado"]["edit"] = array("table" => "senuc_coordenador_regional", "field" => "estado", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["senuc_coordenador_regional.cidade"]["edit"] = array("table" => "senuc_coordenador_regional", "field" => "cidade", "page" => "edit");
	$lookupTableLinks["operadora"]["senuc_coordenador_regional.operadora"]["edit"] = array("table" => "senuc_coordenador_regional", "field" => "operadora", "page" => "edit");
	$lookupTableLinks["etnia"]["senuc_coordenador_regional.etnia"]["edit"] = array("table" => "senuc_coordenador_regional", "field" => "etnia", "page" => "edit");
	$lookupTableLinks["renda"]["senuc_coordenador_regional.renda"]["edit"] = array("table" => "senuc_coordenador_regional", "field" => "renda", "page" => "edit");
	$lookupTableLinks["escolaridade"]["senuc_coordenador_regional.escolaridade"]["edit"] = array("table" => "senuc_coordenador_regional", "field" => "escolaridade", "page" => "edit");
	$lookupTableLinks["senuc_motivos"]["senuc_coordenador_regional.motivo"]["edit"] = array("table" => "senuc_coordenador_regional", "field" => "motivo", "page" => "edit");
	$lookupTableLinks["operadora"]["senuc_professores_regional.operadora"]["edit"] = array("table" => "senuc_professores_regional", "field" => "operadora", "page" => "edit");
	$lookupTableLinks["etnia"]["senuc_professores_regional.etnia"]["edit"] = array("table" => "senuc_professores_regional", "field" => "etnia", "page" => "edit");
	$lookupTableLinks["renda"]["senuc_professores_regional.renda"]["edit"] = array("table" => "senuc_professores_regional", "field" => "renda", "page" => "edit");
	$lookupTableLinks["tb_estados"]["senuc_professores_regional.estado"]["edit"] = array("table" => "senuc_professores_regional", "field" => "estado", "page" => "edit");
	$lookupTableLinks["tb_cidades"]["senuc_professores_regional.cidade"]["edit"] = array("table" => "senuc_professores_regional", "field" => "cidade", "page" => "edit");
	$lookupTableLinks["escolaridade"]["senuc_professores_regional.escolaridade"]["edit"] = array("table" => "senuc_professores_regional", "field" => "escolaridade", "page" => "edit");
	$lookupTableLinks["cursos"]["senuc_professores_regional.curso"]["edit"] = array("table" => "senuc_professores_regional", "field" => "curso", "page" => "edit");
	$lookupTableLinks["materias"]["senuc_professores_regional.materias"]["edit"] = array("table" => "senuc_professores_regional", "field" => "materias", "page" => "edit");
	$lookupTableLinks["senuc_motivos"]["senuc_professores_regional.motivo"]["edit"] = array("table" => "senuc_professores_regional", "field" => "motivo", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_score.idnucleo"]["edit"] = array("table" => "senuc_score", "field" => "idnucleo", "page" => "edit");
	$lookupTableLinks["senuc_categoria"]["senuc_frequencia_regional.categoria"]["edit"] = array("table" => "senuc_frequencia_regional", "field" => "categoria", "page" => "edit");
	$lookupTableLinks["senuc_tipo_atividade"]["senuc_atividades.tipo_atividade"]["edit"] = array("table" => "senuc_atividades", "field" => "tipo_atividade", "page" => "edit");
	$lookupTableLinks["materias"]["senuc_atividades.materia_atividade"]["edit"] = array("table" => "senuc_atividades", "field" => "materia_atividade", "page" => "edit");
	$lookupTableLinks["senuc_professores"]["senuc_atividades.id_professor"]["edit"] = array("table" => "senuc_atividades", "field" => "id_professor", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_atividades.id_nucleo"]["edit"] = array("table" => "senuc_atividades", "field" => "id_nucleo", "page" => "edit");
	$lookupTableLinks["senuc_turmas"]["senuc_atividades.id_turma"]["edit"] = array("table" => "senuc_atividades", "field" => "id_turma", "page" => "edit");
	$lookupTableLinks["senuc_atividades"]["senuc_atividades_aluno.id_atividade"]["edit"] = array("table" => "senuc_atividades_aluno", "field" => "id_atividade", "page" => "edit");
	$lookupTableLinks["senuc_aluno"]["senuc_atividades_aluno.id_aluno"]["edit"] = array("table" => "senuc_atividades_aluno", "field" => "id_aluno", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_atividades_aluno.id_nucleo"]["edit"] = array("table" => "senuc_atividades_aluno", "field" => "id_nucleo", "page" => "edit");
	$lookupTableLinks["senuc_professores"]["senuc_plantoes.id_professor"]["edit"] = array("table" => "senuc_plantoes", "field" => "id_professor", "page" => "edit");
	$lookupTableLinks["materias"]["senuc_plantoes.materia"]["edit"] = array("table" => "senuc_plantoes", "field" => "materia", "page" => "edit");
	$lookupTableLinks["semana"]["senuc_plantoes.dias_semana"]["edit"] = array("table" => "senuc_plantoes", "field" => "dias_semana", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_plantoes.id_nucleo"]["edit"] = array("table" => "senuc_plantoes", "field" => "id_nucleo", "page" => "edit");
	$lookupTableLinks["senuc_plantoes"]["senuc_plantoes_aluno.id_plantao"]["edit"] = array("table" => "senuc_plantoes_aluno", "field" => "id_plantao", "page" => "edit");
	$lookupTableLinks["senuc_aluno"]["senuc_plantoes_aluno.id_aluno"]["edit"] = array("table" => "senuc_plantoes_aluno", "field" => "id_aluno", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_plantoes_aluno.id_nucleo"]["edit"] = array("table" => "senuc_plantoes_aluno", "field" => "id_nucleo", "page" => "edit");
	$lookupTableLinks["senuc_login"]["senuc_plantoes_aluno.operador"]["edit"] = array("table" => "senuc_plantoes_aluno", "field" => "operador", "page" => "edit");
	$lookupTableLinks["senuc_aluno"]["senuc_contribuicoes.id_aluno"]["edit"] = array("table" => "senuc_contribuicoes", "field" => "id_aluno", "page" => "edit");
	$lookupTableLinks["senuc_login"]["senuc_contribuicoes.operador"]["edit"] = array("table" => "senuc_contribuicoes", "field" => "operador", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_contribuicoes.id_nucleo"]["edit"] = array("table" => "senuc_contribuicoes", "field" => "id_nucleo", "page" => "edit");
	$lookupTableLinks["senuc_aluno"]["senuc_aprovacoes.id_aluno"]["edit"] = array("table" => "senuc_aprovacoes", "field" => "id_aluno", "page" => "edit");
	$lookupTableLinks["senuc_tipo_instituicao"]["senuc_aprovacoes.tipo_instituicao"]["edit"] = array("table" => "senuc_aprovacoes", "field" => "tipo_instituicao", "page" => "edit");
	$lookupTableLinks["senuc_login"]["senuc_aprovacoes.usuario"]["edit"] = array("table" => "senuc_aprovacoes", "field" => "usuario", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_turmas.idnucleo"]["edit"] = array("table" => "senuc_turmas", "field" => "idnucleo", "page" => "edit");
	$lookupTableLinks["senuc_aluno"]["senuc_descomplica.cpf"]["edit"] = array("table" => "senuc_descomplica", "field" => "cpf", "page" => "edit");
	$lookupTableLinks["senuc_aluno"]["senuc_descomplica.id_aluno"]["edit"] = array("table" => "senuc_descomplica", "field" => "id_aluno", "page" => "edit");
	$lookupTableLinks["senuc_aluno"]["senuc_descomplica.id_aluno"]["add"] = array("table" => "senuc_descomplica", "field" => "id_aluno", "page" => "add");
	$lookupTableLinks["senuc_aluno"]["senuc_descomplica.id_aluno"]["search"] = array("table" => "senuc_descomplica", "field" => "id_aluno", "page" => "search");
	$lookupTableLinks["senuc_descomplica_logins"]["senuc_descomplica.login"]["edit"] = array("table" => "senuc_descomplica", "field" => "login", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_descomplica.id_nucleo"]["edit"] = array("table" => "senuc_descomplica", "field" => "id_nucleo", "page" => "edit");
	$lookupTableLinks["regionais"]["senuc_descomplica.id_regional"]["edit"] = array("table" => "senuc_descomplica", "field" => "id_regional", "page" => "edit");
	$lookupTableLinks["senuc_aluno"]["senuc_descomplica_avaliacao.id_aluno"]["edit"] = array("table" => "senuc_descomplica_avaliacao", "field" => "id_aluno", "page" => "edit");
	$lookupTableLinks["senuc_login"]["senuc_descomplica_avaliacao.operador"]["edit"] = array("table" => "senuc_descomplica_avaliacao", "field" => "operador", "page" => "edit");
	$lookupTableLinks["senuc_aluno"]["senuc_descomplica_logins.id_aluno"]["edit"] = array("table" => "senuc_descomplica_logins", "field" => "id_aluno", "page" => "edit");
	$lookupTableLinks["senuc_nucleo"]["senuc_descomplica_logins.id_nucleo"]["edit"] = array("table" => "senuc_descomplica_logins", "field" => "id_nucleo", "page" => "edit");
	$lookupTableLinks["regionais"]["senuc_descomplica_logins.id_regional"]["edit"] = array("table" => "senuc_descomplica_logins", "field" => "id_regional", "page" => "edit");
	$lookupTableLinks["senuc_login"]["senuc_descomplica_logins.operador"]["edit"] = array("table" => "senuc_descomplica_logins", "field" => "operador", "page" => "edit");
	$lookupTableLinks["senuc_aluno"]["senuc_aluno_acessos_descomplica.id_aluno"]["edit"] = array("table" => "senuc_aluno_acessos_descomplica", "field" => "id_aluno", "page" => "edit");
	$lookupTableLinks["associados"]["senuc_certificados_voluntario.cpf"]["edit"] = array("table" => "senuc_certificados_voluntario", "field" => "cpf", "page" => "edit");
	$lookupTableLinks["senuc_tipo_voluntario"]["senuc_certificados_voluntario.tipo_voluntario"]["edit"] = array("table" => "senuc_certificados_voluntario", "field" => "tipo_voluntario", "page" => "edit");
}

?>