<?php 
include("include/dbcommon.php");

@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

add_nocache_headers();
include("include/professor_variables.php");
include('include/xtempl.php');
include('classes/addpage.php');

global $globalEvents;

//	check if logged in
if(@$_SESSION["UserID"] && IsAdmin() && !CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Add"))
{
	echo "<p>"."Voc no tem permisso para acessar esta tabela"."<br>Proceed to <a href=\"admin.php\">Admin Area</a> to set up user permissions</p>";
	return;
}
if(!isLogged() || CheckPermissionsEvent($strTableName, 'A') && !CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Add"))
{ 
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	
	header("Location: login.php?message=expired"); 
	return;
}

if ((sizeof($_POST)==0) && (postvalue('ferror'))){
	if (postvalue("inline")){
		$returnJSON['success'] = false;
		$returnJSON['message'] = "Ocorreu um erro!";
		$returnJSON['fatalError'] = true;
		echo "<textarea>".htmlspecialchars(my_json_encode($returnJSON))."</textarea>";
		exit();
	}
	else if (postvalue("fly")){
		echo -1;
		exit();
	}
	else {
		$_SESSION["message_add"] = "<< "."Error occurred"." >>";
	}
}

$layout = new TLayout("add2","FusionOrange","MobileOrange");
$layout->blocks["top"] = array();
$layout->containers["add"] = array();

$layout->containers["add"][] = array("name"=>"addheader","block"=>"","substyle"=>2);


$layout->containers["add"][] = array("name"=>"message","block"=>"message_block","substyle"=>1);


$layout->containers["add"][] = array("name"=>"wrapper","block"=>"","substyle"=>1, "container"=>"fields");


$layout->containers["fields"] = array();

$layout->containers["fields"][] = array("name"=>"addfields","block"=>"","substyle"=>1);


$layout->containers["fields"][] = array("name"=>"legend","block"=>"legend","substyle"=>3);


$layout->containers["fields"][] = array("name"=>"addbuttons","block"=>"","substyle"=>2);


$layout->skins["fields"] = "fields";

$layout->skins["add"] = "1";
$layout->blocks["top"][] = "add";
$layout->skins["details"] = "empty";
$layout->blocks["top"][] = "details";$page_layouts["professor_add"] = $layout;



$filename = "";
$status = "";
$message = "";
$mesClass = "";
$usermessage = "";
$error_happened = false;
$readavalues = false;

$keys = array();
$showValues = array();
$showRawValues = array();
$showFields = array();
$showDetailKeys = array();
$IsSaved = false;
$HaveData = true;
$popUpSave = false;

$sessionPrefix = $strTableName;

$onFly = false;
if(postvalue("onFly"))
	$onFly = true;

if(@$_REQUEST["editType"]=="inline")
	$inlineadd = ADD_INLINE;
elseif(@$_REQUEST["editType"]==ADD_POPUP)
{
	$inlineadd = ADD_POPUP;
	if(@$_POST["a"]=="added" && postvalue("field")=="" && postvalue("category")=="")
		$popUpSave = true;	
}
elseif(@$_REQUEST["editType"]==ADD_MASTER)
	$inlineadd = ADD_MASTER;
elseif($onFly)
{
	$inlineadd = ADD_ONTHEFLY;
	$sessionPrefix = $strTableName."_add";
}
else
	$inlineadd = ADD_SIMPLE;

if($inlineadd == ADD_INLINE)
	$templatefile = "professor_inline_add.htm";
else
	$templatefile = "professor_add.htm";

$id = postvalue("id");
if(intval($id)==0)
	$id = 1;

//If undefined session value for mastet table, but exist post value master table, than take second
//It may be happen only when use dpInline mode on page add
if(!@$_SESSION[$sessionPrefix."_mastertable"] && postvalue("mastertable"))
	$_SESSION[$sessionPrefix."_mastertable"] = postvalue("mastertable");
	
$xt = new Xtempl();
	
// assign an id
$xt->assign("id",$id);
	
$auditObj = GetAuditObject($strTableName);

//array of params for classes
$params = array("pageType" => PAGE_ADD,"id" => $id,"mode" => $inlineadd);


$params['xt'] = &$xt;
$params['tName'] = $strTableName;
$params['includes_js'] = $includes_js;
$params['locale_info'] = $locale_info;
$params['includes_css'] = $includes_css;
$params['useTabsOnAdd'] = $gSettings->useTabsOnAdd();
$params['templatefile'] = $templatefile;
$params['includes_jsreq'] = $includes_jsreq;
$params['pageAddLikeInline'] = ($inlineadd==ADD_INLINE);
$params['needSearchClauseObj'] = false;
$params['strOriginalTableName'] = $strOriginalTableName;

if($params['useTabsOnAdd'])
	$params['arrAddTabs'] = $gSettings->getAddTabs();
	
$pageObject = new AddPage($params);

if(isset($_REQUEST['afteradd'])){
		header('Location: professor_add.php');
	if($eventObj->exists("AfterAdd") && isset($_SESSION['after_add_data'][$_REQUEST['afteradd']])){
	
		$data = $_SESSION['after_add_data'][$_REQUEST['afteradd']];
		$eventObj->AfterAdd($data['avalues'], $data['keys'],$data['inlineadd'], $pageObject);
	
	}
	unset($_SESSION['after_add_data'][$_REQUEST['afteradd']]);
	
	foreach (is_array($_SESSION['after_add_data']) ? $_SESSION['after_add_data'] : array() as $k=>$v){
		if (!is_array($v) or !array_key_exists('time',$v)) {
			unset($_SESSION['after_add_data'][$k]);
			continue;
		}
		if ($v['time'] < time() - 3600){
			unset($_SESSION['after_add_data'][$k]);
		}
	}
		exit;
}

//Get detail table keys	
$detailKeys = $pageObject->detailKeysByM;

//Array of fields, which appear on add page
$addFields = $pageObject->getFieldsByPageType();

// add button events if exist
if ($inlineadd==ADD_SIMPLE)
	$pageObject->addButtonHandlers();

$url_page=substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1,12);

//For show detail tables on master page add
if($inlineadd==ADD_SIMPLE || $inlineadd==ADD_MASTER || $inlineadd==ADD_POPUP)
{
	$dpParams = array();
	if($pageObject->isShowDetailTables  && !isMobile())
	{
		$ids = $id;
		$countDetailsIsShow = 0;
		$pageObject->jsSettings['tableSettings'][$strTableName]['isShowDetails'] = $countDetailsIsShow > 0 ? true : false;
		$pageObject->jsSettings['tableSettings'][$strTableName]['dpParams'] = array('tableNames'=>$dpParams['strTableNames'], 'ids'=>$dpParams['ids']);
	}
}

//	Before Process event
if($eventObj->exists("BeforeProcessAdd"))
	$eventObj->BeforeProcessAdd($conn, $pageObject);

// proccess captcha
if ($inlineadd==ADD_SIMPLE || $inlineadd==ADD_MASTER || $inlineadd==ADD_POPUP)
	if($pageObject->captchaExists())
		$pageObject->doCaptchaCode();
	
// insert new record if we have to
if(@$_POST["a"]=="added")
{
	$afilename_values=array();
	$avalues=array();
	$blobfields=array();
//	processing nome - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_nome = $pageObject->getControl("nome", $id);
		$control_nome->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing nome - end
//	processing email - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_email = $pageObject->getControl("email", $id);
		$control_email->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing email - end
//	processing cpf - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_cpf = $pageObject->getControl("cpf", $id);
		$control_cpf->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing cpf - end
//	processing telefone - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_telefone = $pageObject->getControl("telefone", $id);
		$control_telefone->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing telefone - end
//	processing celular - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_celular = $pageObject->getControl("celular", $id);
		$control_celular->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing celular - end
//	processing operadora - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_operadora = $pageObject->getControl("operadora", $id);
		$control_operadora->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing operadora - end
//	processing bairro - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_bairro = $pageObject->getControl("bairro", $id);
		$control_bairro->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing bairro - end
//	processing regiao - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_regiao = $pageObject->getControl("regiao", $id);
		$control_regiao->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing regiao - end
//	processing cidade - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_cidade = $pageObject->getControl("cidade", $id);
		$control_cidade->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing cidade - end
//	processing estado - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_estado = $pageObject->getControl("estado", $id);
		$control_estado->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing estado - end
//	processing grupo - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_grupo = $pageObject->getControl("grupo", $id);
		$control_grupo->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing grupo - end
//	processing curso - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_curso = $pageObject->getControl("curso", $id);
		$control_curso->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing curso - end
//	processing materias - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_materias = $pageObject->getControl("materias", $id);
		$control_materias->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing materias - end
//	processing manha - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_manha = $pageObject->getControl("manha", $id);
		$control_manha->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing manha - end
//	processing tarde - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_tarde = $pageObject->getControl("tarde", $id);
		$control_tarde->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing tarde - end
//	processing noite - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_noite = $pageObject->getControl("noite", $id);
		$control_noite->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing noite - end
//	processing aulas - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_aulas = $pageObject->getControl("aulas", $id);
		$control_aulas->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing aulas - end
//	processing aulas_onde - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_aulas_onde = $pageObject->getControl("aulas_onde", $id);
		$control_aulas_onde->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing aulas_onde - end
//	processing bolsista - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_bolsista = $pageObject->getControl("bolsista", $id);
		$control_bolsista->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing bolsista - end
//	processing motivos - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_motivos = $pageObject->getControl("motivos", $id);
		$control_motivos->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing motivos - end
//	processing ano - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_ano = $pageObject->getControl("ano", $id);
		$control_ano->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing ano - end
//	processing historico - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_historico = $pageObject->getControl("historico", $id);
		$control_historico->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing historico - end
//	processing atualizado - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_atualizado = $pageObject->getControl("atualizado", $id);
		$control_atualizado->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing atualizado - end
//	processing em_quantos_nucleos - start
	$inlineAddOption = true;
	if($inlineAddOption)
	{
		$control_em_quantos_nucleos = $pageObject->getControl("em_quantos_nucleos", $id);
		$control_em_quantos_nucleos->readWebValue($avalues, $blobfields, "", false, $afilename_values);
	}
//	processing em_quantos_nucleos - end




	$failed_inline_add=false;
//	add filenames to values
	foreach($afilename_values as $akey=>$value)
		$avalues[$akey]=$value;
	
//	before Add event
	$retval = true;
	if($eventObj->exists("BeforeAdd"))
		$retval = $eventObj->BeforeAdd($avalues,$usermessage,(bool)$inlineadd, $pageObject);
	if($retval && $pageObject->isCaptchaOk)
	{
		//add or set updated lat-lng values for all map fileds with 'UpdateLatLng' ticked
		setUpdatedLatLng($avalues, $pageObject->cipherer->pSet);
		
		$_SESSION[$strTableName."_count_captcha"] = $_SESSION[$strTableName."_count_captcha"]+1;
		if(DoInsertRecord($strOriginalTableName,$avalues,$blobfields,$id,$pageObject, $pageObject->cipherer))
		{
			$IsSaved=true;
//	after edit event
			if($auditObj || $eventObj->exists("AfterAdd"))
			{
				foreach($keys as $idx=>$val)
					$avalues[$idx]=$val;
			}
			
			if($auditObj)
				$auditObj->LogAdd($strTableName,$avalues,$keys);
				
// Give possibility to all edit controls to clean their data				
//	processing nome - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_nome->afterSuccessfulSave();
			}
//	processing nome - end
//	processing email - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_email->afterSuccessfulSave();
			}
//	processing email - end
//	processing cpf - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_cpf->afterSuccessfulSave();
			}
//	processing cpf - end
//	processing telefone - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_telefone->afterSuccessfulSave();
			}
//	processing telefone - end
//	processing celular - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_celular->afterSuccessfulSave();
			}
//	processing celular - end
//	processing operadora - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_operadora->afterSuccessfulSave();
			}
//	processing operadora - end
//	processing bairro - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_bairro->afterSuccessfulSave();
			}
//	processing bairro - end
//	processing regiao - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_regiao->afterSuccessfulSave();
			}
//	processing regiao - end
//	processing cidade - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_cidade->afterSuccessfulSave();
			}
//	processing cidade - end
//	processing estado - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_estado->afterSuccessfulSave();
			}
//	processing estado - end
//	processing grupo - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_grupo->afterSuccessfulSave();
			}
//	processing grupo - end
//	processing curso - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_curso->afterSuccessfulSave();
			}
//	processing curso - end
//	processing materias - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_materias->afterSuccessfulSave();
			}
//	processing materias - end
//	processing manha - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_manha->afterSuccessfulSave();
			}
//	processing manha - end
//	processing tarde - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_tarde->afterSuccessfulSave();
			}
//	processing tarde - end
//	processing noite - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_noite->afterSuccessfulSave();
			}
//	processing noite - end
//	processing aulas - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_aulas->afterSuccessfulSave();
			}
//	processing aulas - end
//	processing aulas_onde - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_aulas_onde->afterSuccessfulSave();
			}
//	processing aulas_onde - end
//	processing bolsista - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_bolsista->afterSuccessfulSave();
			}
//	processing bolsista - end
//	processing motivos - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_motivos->afterSuccessfulSave();
			}
//	processing motivos - end
//	processing ano - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_ano->afterSuccessfulSave();
			}
//	processing ano - end
//	processing historico - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_historico->afterSuccessfulSave();
			}
//	processing historico - end
//	processing atualizado - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_atualizado->afterSuccessfulSave();
			}
//	processing atualizado - end
//	processing em_quantos_nucleos - start
			$inlineAddOption = true;
			if($inlineAddOption)
			{
				$control_em_quantos_nucleos->afterSuccessfulSave();
			}
//	processing em_quantos_nucleos - end

			$afterAdd_id = '';	
			if($eventObj->exists("AfterAdd") && $inlineadd!=ADD_MASTER){
				$eventObj->AfterAdd($avalues,$keys,(bool)$inlineadd, $pageObject);
			} else if ($eventObj->exists("AfterAdd") && $inlineadd==ADD_MASTER){
				if($onFly)
					$eventObj->AfterAdd($avalues,$keys,(bool)$inlineadd, $pageObject);
				else{
					$afterAdd_id = generatePassword(20);	
				
					$_SESSION['after_add_data'][$afterAdd_id] = array(
						'avalues'=>$avalues,
						'keys'=>$keys,
						'inlineadd'=>(bool)$inlineadd,
						'time' => time()
					);	
				}
			}
				
			if($inlineadd==ADD_SIMPLE || $inlineadd==ADD_MASTER)
			{
				$permis = array();
				$keylink = "";$k = 0;
				foreach($keys as $idx=>$val)
				{
					if($k!=0)
						$keylink .="&";
					$keylink .="editid".(++$k)."=".htmlspecialchars(rawurlencode(@$val));
				}
				$permis = $pageObject->getPermissions();				
				if (count($keys))
				{
					$message .="</br>";
					if($pageObject->pSet->hasEditPage() && $permis['edit'])
						$message .='&nbsp;<a href=\'professor_edit.php?'.$keylink.'\'>'."Editar".'</a>&nbsp;';
					if($pageObject->pSet->hasViewPage() && $permis['search'])
						$message .='&nbsp;<a href=\'professor_view.php?'.$keylink.'\'>'."Exibir".'</a>&nbsp;';
				}
				$mesClass = "mes_ok";	
			}
		}
		elseif($inlineadd!=ADD_INLINE)
			$mesClass = "mes_not";	
	}
	else
	{
		$message = $usermessage;
		$status = "DECLINED";
		$readavalues = true;
	}
}
if($message)
	$message = "<div class='message ".$mesClass."'>".$message."</div>";

// PRG rule, to avoid POSTDATA resend
if (no_output_done() && $inlineadd==ADD_SIMPLE && $IsSaved)
{
	// saving message
	$_SESSION["message_add"] = ($message ? $message : "");
	// redirect
	header("Location: professor_".$pageObject->getPageType().".php");
	// turned on output buffering, so we need to stop script
	exit();
}

if($inlineadd==ADD_MASTER && $IsSaved)
	$_SESSION["message_add"] = ($message ? $message : "");
	
// for PRG rule, to avoid POSTDATA resend. Saving mess in session
if($inlineadd==ADD_SIMPLE && isset($_SESSION["message_add"]))
{
	$message = $_SESSION["message_add"];
	unset($_SESSION["message_add"]);
}

$defvalues=array();

//	copy record
if(array_key_exists("copyid1",$_REQUEST) || array_key_exists("editid1",$_REQUEST))
{
	$copykeys=array();
	if(array_key_exists("copyid1",$_REQUEST))
	{
		$copykeys["id"]=postvalue("copyid1");
	}
	else
	{
		$copykeys["id"]=postvalue("editid1");
	}
	$strWhere=KeyWhere($copykeys);
	$strSQL = $gQuery->gSQLWhere($strWhere);

	LogInfo($strSQL);
	$rs = db_query($strSQL,$conn);
	$defvalues = $pageObject->cipherer->DecryptFetchedArray($rs);
	if(!$defvalues)
		$defvalues=array();
//	clear key fields
	$defvalues["id"]="";
//call CopyOnLoad event
	if($eventObj->exists("CopyOnLoad"))
		$eventObj->CopyOnLoad($defvalues,$strWhere, $pageObject);
}
else
{
}



if($readavalues)
{
	$defvalues["nome"]=@$avalues["nome"];
	$defvalues["email"]=@$avalues["email"];
	$defvalues["cpf"]=@$avalues["cpf"];
	$defvalues["telefone"]=@$avalues["telefone"];
	$defvalues["celular"]=@$avalues["celular"];
	$defvalues["operadora"]=@$avalues["operadora"];
	$defvalues["bairro"]=@$avalues["bairro"];
	$defvalues["regiao"]=@$avalues["regiao"];
	$defvalues["cidade"]=@$avalues["cidade"];
	$defvalues["estado"]=@$avalues["estado"];
	$defvalues["grupo"]=@$avalues["grupo"];
	$defvalues["curso"]=@$avalues["curso"];
	$defvalues["materias"]=@$avalues["materias"];
	$defvalues["manha"]=@$avalues["manha"];
	$defvalues["tarde"]=@$avalues["tarde"];
	$defvalues["noite"]=@$avalues["noite"];
	$defvalues["aulas"]=@$avalues["aulas"];
	$defvalues["aulas_onde"]=@$avalues["aulas_onde"];
	$defvalues["bolsista"]=@$avalues["bolsista"];
	$defvalues["motivos"]=@$avalues["motivos"];
	$defvalues["ano"]=@$avalues["ano"];
	$defvalues["historico"]=@$avalues["historico"];
	$defvalues["atualizado"]=@$avalues["atualizado"];
	$defvalues["em_quantos_nucleos"]=@$avalues["em_quantos_nucleos"];
}

if($eventObj->exists("ProcessValuesAdd"))
	$eventObj->ProcessValuesAdd($defvalues, $pageObject);


//for basic files
$includes="";

if($inlineadd!=ADD_INLINE)
{
	if($inlineadd!=ADD_ONTHEFLY && $inlineadd!=ADD_POPUP)
	{
		$includes .="<script language=\"JavaScript\" src=\"include/loadfirst.js\"></script>\r\n";
				$includes.="<script type=\"text/javascript\" src=\"include/lang/".getLangFileName(mlang_getcurrentlang()).".js\"></script>";
		if (!isMobile())
			$includes.="<div id=\"search_suggest\"></div>\r\n";
	}
	
	if(!$pageObject->isAppearOnTabs("nome"))
		$xt->assign("nome_fieldblock",true);
	else
		$xt->assign("nome_tabfieldblock",true);
	$xt->assign("nome_label",true);
	if(isEnableSection508())
		$xt->assign_section("nome_label","<label for=\"".GetInputElementId("nome", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("email"))
		$xt->assign("email_fieldblock",true);
	else
		$xt->assign("email_tabfieldblock",true);
	$xt->assign("email_label",true);
	if(isEnableSection508())
		$xt->assign_section("email_label","<label for=\"".GetInputElementId("email", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("cpf"))
		$xt->assign("cpf_fieldblock",true);
	else
		$xt->assign("cpf_tabfieldblock",true);
	$xt->assign("cpf_label",true);
	if(isEnableSection508())
		$xt->assign_section("cpf_label","<label for=\"".GetInputElementId("cpf", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("telefone"))
		$xt->assign("telefone_fieldblock",true);
	else
		$xt->assign("telefone_tabfieldblock",true);
	$xt->assign("telefone_label",true);
	if(isEnableSection508())
		$xt->assign_section("telefone_label","<label for=\"".GetInputElementId("telefone", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("celular"))
		$xt->assign("celular_fieldblock",true);
	else
		$xt->assign("celular_tabfieldblock",true);
	$xt->assign("celular_label",true);
	if(isEnableSection508())
		$xt->assign_section("celular_label","<label for=\"".GetInputElementId("celular", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("operadora"))
		$xt->assign("operadora_fieldblock",true);
	else
		$xt->assign("operadora_tabfieldblock",true);
	$xt->assign("operadora_label",true);
	if(isEnableSection508())
		$xt->assign_section("operadora_label","<label for=\"".GetInputElementId("operadora", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("bairro"))
		$xt->assign("bairro_fieldblock",true);
	else
		$xt->assign("bairro_tabfieldblock",true);
	$xt->assign("bairro_label",true);
	if(isEnableSection508())
		$xt->assign_section("bairro_label","<label for=\"".GetInputElementId("bairro", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("regiao"))
		$xt->assign("regiao_fieldblock",true);
	else
		$xt->assign("regiao_tabfieldblock",true);
	$xt->assign("regiao_label",true);
	if(isEnableSection508())
		$xt->assign_section("regiao_label","<label for=\"".GetInputElementId("regiao", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("cidade"))
		$xt->assign("cidade_fieldblock",true);
	else
		$xt->assign("cidade_tabfieldblock",true);
	$xt->assign("cidade_label",true);
	if(isEnableSection508())
		$xt->assign_section("cidade_label","<label for=\"".GetInputElementId("cidade", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("estado"))
		$xt->assign("estado_fieldblock",true);
	else
		$xt->assign("estado_tabfieldblock",true);
	$xt->assign("estado_label",true);
	if(isEnableSection508())
		$xt->assign_section("estado_label","<label for=\"".GetInputElementId("estado", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("grupo"))
		$xt->assign("grupo_fieldblock",true);
	else
		$xt->assign("grupo_tabfieldblock",true);
	$xt->assign("grupo_label",true);
	if(isEnableSection508())
		$xt->assign_section("grupo_label","<label for=\"".GetInputElementId("grupo", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("curso"))
		$xt->assign("curso_fieldblock",true);
	else
		$xt->assign("curso_tabfieldblock",true);
	$xt->assign("curso_label",true);
	if(isEnableSection508())
		$xt->assign_section("curso_label","<label for=\"".GetInputElementId("curso", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("materias"))
		$xt->assign("materias_fieldblock",true);
	else
		$xt->assign("materias_tabfieldblock",true);
	$xt->assign("materias_label",true);
	if(isEnableSection508())
		$xt->assign_section("materias_label","<label for=\"".GetInputElementId("materias", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("manha"))
		$xt->assign("manha_fieldblock",true);
	else
		$xt->assign("manha_tabfieldblock",true);
	$xt->assign("manha_label",true);
	if(isEnableSection508())
		$xt->assign_section("manha_label","<label for=\"".GetInputElementId("manha", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("tarde"))
		$xt->assign("tarde_fieldblock",true);
	else
		$xt->assign("tarde_tabfieldblock",true);
	$xt->assign("tarde_label",true);
	if(isEnableSection508())
		$xt->assign_section("tarde_label","<label for=\"".GetInputElementId("tarde", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("noite"))
		$xt->assign("noite_fieldblock",true);
	else
		$xt->assign("noite_tabfieldblock",true);
	$xt->assign("noite_label",true);
	if(isEnableSection508())
		$xt->assign_section("noite_label","<label for=\"".GetInputElementId("noite", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("aulas"))
		$xt->assign("aulas_fieldblock",true);
	else
		$xt->assign("aulas_tabfieldblock",true);
	$xt->assign("aulas_label",true);
	if(isEnableSection508())
		$xt->assign_section("aulas_label","<label for=\"".GetInputElementId("aulas", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("aulas_onde"))
		$xt->assign("aulas_onde_fieldblock",true);
	else
		$xt->assign("aulas_onde_tabfieldblock",true);
	$xt->assign("aulas_onde_label",true);
	if(isEnableSection508())
		$xt->assign_section("aulas_onde_label","<label for=\"".GetInputElementId("aulas_onde", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("bolsista"))
		$xt->assign("bolsista_fieldblock",true);
	else
		$xt->assign("bolsista_tabfieldblock",true);
	$xt->assign("bolsista_label",true);
	if(isEnableSection508())
		$xt->assign_section("bolsista_label","<label for=\"".GetInputElementId("bolsista", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("motivos"))
		$xt->assign("motivos_fieldblock",true);
	else
		$xt->assign("motivos_tabfieldblock",true);
	$xt->assign("motivos_label",true);
	if(isEnableSection508())
		$xt->assign_section("motivos_label","<label for=\"".GetInputElementId("motivos", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("ano"))
		$xt->assign("ano_fieldblock",true);
	else
		$xt->assign("ano_tabfieldblock",true);
	$xt->assign("ano_label",true);
	if(isEnableSection508())
		$xt->assign_section("ano_label","<label for=\"".GetInputElementId("ano", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("historico"))
		$xt->assign("historico_fieldblock",true);
	else
		$xt->assign("historico_tabfieldblock",true);
	$xt->assign("historico_label",true);
	if(isEnableSection508())
		$xt->assign_section("historico_label","<label for=\"".GetInputElementId("historico", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("atualizado"))
		$xt->assign("atualizado_fieldblock",true);
	else
		$xt->assign("atualizado_tabfieldblock",true);
	$xt->assign("atualizado_label",true);
	if(isEnableSection508())
		$xt->assign_section("atualizado_label","<label for=\"".GetInputElementId("atualizado", $id, PAGE_ADD)."\">","</label>");
	
	if(!$pageObject->isAppearOnTabs("em_quantos_nucleos"))
		$xt->assign("em_quantos_nucleos_fieldblock",true);
	else
		$xt->assign("em_quantos_nucleos_tabfieldblock",true);
	$xt->assign("em_quantos_nucleos_label",true);
	if(isEnableSection508())
		$xt->assign_section("em_quantos_nucleos_label","<label for=\"".GetInputElementId("em_quantos_nucleos", $id, PAGE_ADD)."\">","</label>");
	
	
	
	if($inlineadd!=ADD_ONTHEFLY && $inlineadd!=ADD_POPUP)
	{
		$pageObject->body["begin"] .= $includes;
				$xt->assign("backbutton_attrs","id=\"backButton".$id."\"");
		$xt->assign("back_button",true);
	}
	else
	{		
		$xt->assign("cancelbutton_attrs", "id=\"cancelButton".$id."\"");
		$xt->assign("cancel_button",true);
		$xt->assign("header","");
	}
	$xt->assign("save_button",true);
}
$xt->assign("savebutton_attrs","id=\"saveButton".$id."\"");
$xt->assign("message_block",true);
$xt->assign("message",$message);
if(!strlen($message))
{
	$xt->displayBrickHidden("message");
}

//	show readonly fields
$linkdata="";

$i = 0;
$jsKeys = array();
$keyFields = array();
foreach($keys as $field=>$value)
{
	$keyFields[$i] = $field;
	$jsKeys[$i++] = $value;
}

if(@$_POST["a"]=="added" && $inlineadd==ADD_ONTHEFLY)
{
	if( !$error_happened && $status!="DECLINED")
	{
		$addedData = GetAddedDataLookupQuery($pageObject, $keys, false);
		$data =& $addedData[0];	
		
		if($data)
		{
			$respData = array($addedData[1]["linkField"] => @$data[$addedData[1]["linkFieldIndex"]], $addedData[1]["displayField"] => @$data[$addedData[1]["displayFieldIndex"]]);
		}
		else
		{
			$respData = array($addedData[1]["linkField"] => @$avalues[$addedData[1]["linkField"]], $addedData[1]["displayField"] => @$avalues[$addedData[1]["displayField"]]);
		}		
		$returnJSON['success'] = true;
		$returnJSON['keys'] = $jsKeys;
		$returnJSON['keyFields'] = $keyFields;
		$returnJSON['vals'] = $respData;
		$returnJSON['fields'] = $showFields;
	}
	else
	{
		$returnJSON['success'] = false;
		$returnJSON['message'] = $message;
	}
	echo "<textarea>".htmlspecialchars(my_json_encode($returnJSON))."</textarea>";
	exit();
}

if(@$_POST["a"]=="added" && ($inlineadd == ADD_INLINE || $inlineadd == ADD_MASTER || $inlineadd==ADD_POPUP)) 
{
	//Preparation   view values
	//	get current values and show edit controls
	$dispFieldAlias = "";
	$data=0;
	$linkAndDispVals = array();
	if(count($keys))
	{
		$where=KeyWhere($keys);
			
		$forLookup = postvalue('forLookup');
		if ($forLookup)
		{
			$addedData = GetAddedDataLookupQuery($pageObject, $keys, true);
			$data =& $addedData[0];
			$linkAndDispVals = array('linkField' => $addedData[0][$addedData[1]["linkField"]], 'displayField' => $addedData[0][$addedData[1]["displayField"]]);
		}
		else
		{
			$strSQL = $gQuery->gSQLWhere_having_fromQuery('', $where, '');		
		
			LogInfo($strSQL);
			$rs=db_query($strSQL,$conn);
			$data = $pageObject->cipherer->DecryptFetchedArray($rs);
		}
	}
	if(!$data)
	{
		$data=$avalues;
		$HaveData=false;
	}
	//check if correct values added

	$keylink="";
	$keylink.="&key1=".htmlspecialchars(rawurlencode(@$data["id"]));
	
////////////////////////////////////////////
//	id
	$display = false;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("id", $data, $keylink);
		$showValues["id"] = $value;
		$showFields[] = "id";
	}	
//	nome
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("nome", $data, $keylink);
		$showValues["nome"] = $value;
		$showFields[] = "nome";
	}	
//	email
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("email", $data, $keylink);
		$showValues["email"] = $value;
		$showFields[] = "email";
	}	
//	cpf
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("cpf", $data, $keylink);
		$showValues["cpf"] = $value;
		$showFields[] = "cpf";
	}	
//	telefone
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("telefone", $data, $keylink);
		$showValues["telefone"] = $value;
		$showFields[] = "telefone";
	}	
//	celular
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("celular", $data, $keylink);
		$showValues["celular"] = $value;
		$showFields[] = "celular";
	}	
//	operadora
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("operadora", $data, $keylink);
		$showValues["operadora"] = $value;
		$showFields[] = "operadora";
	}	
//	bairro
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("bairro", $data, $keylink);
		$showValues["bairro"] = $value;
		$showFields[] = "bairro";
	}	
//	regiao
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("regiao", $data, $keylink);
		$showValues["regiao"] = $value;
		$showFields[] = "regiao";
	}	
//	cidade
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("cidade", $data, $keylink);
		$showValues["cidade"] = $value;
		$showFields[] = "cidade";
	}	
//	estado
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("estado", $data, $keylink);
		$showValues["estado"] = $value;
		$showFields[] = "estado";
	}	
//	grupo
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("grupo", $data, $keylink);
		$showValues["grupo"] = $value;
		$showFields[] = "grupo";
	}	
//	curso
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("curso", $data, $keylink);
		$showValues["curso"] = $value;
		$showFields[] = "curso";
	}	
//	materias
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("materias", $data, $keylink);
		$showValues["materias"] = $value;
		$showFields[] = "materias";
	}	
//	manha
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("manha", $data, $keylink);
		$showValues["manha"] = $value;
		$showFields[] = "manha";
	}	
//	tarde
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("tarde", $data, $keylink);
		$showValues["tarde"] = $value;
		$showFields[] = "tarde";
	}	
//	noite
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("noite", $data, $keylink);
		$showValues["noite"] = $value;
		$showFields[] = "noite";
	}	
//	aulas
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("aulas", $data, $keylink);
		$showValues["aulas"] = $value;
		$showFields[] = "aulas";
	}	
//	aulas_onde
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("aulas_onde", $data, $keylink);
		$showValues["aulas_onde"] = $value;
		$showFields[] = "aulas_onde";
	}	
//	bolsista
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("bolsista", $data, $keylink);
		$showValues["bolsista"] = $value;
		$showFields[] = "bolsista";
	}	
//	motivos
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("motivos", $data, $keylink);
		$showValues["motivos"] = $value;
		$showFields[] = "motivos";
	}	
//	ano
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("ano", $data, $keylink);
		$showValues["ano"] = $value;
		$showFields[] = "ano";
	}	
//	historico
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("historico", $data, $keylink);
		$showValues["historico"] = $value;
		$showFields[] = "historico";
	}	
//	atualizado
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("atualizado", $data, $keylink);
		$showValues["atualizado"] = $value;
		$showFields[] = "atualizado";
	}	
//	em_quantos_nucleos
	$display = false;
	if($inlineadd==ADD_MASTER)
		$display = true;
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		$display = true;
	if($display)
	{	
		$value = $pageObject->showDBValue("em_quantos_nucleos", $data, $keylink);
		$showValues["em_quantos_nucleos"] = $value;
		$showFields[] = "em_quantos_nucleos";
	}	
		$showRawValues["id"] = substr($data["id"],0,100);
		$showRawValues["nome"] = substr($data["nome"],0,100);
		$showRawValues["email"] = substr($data["email"],0,100);
		$showRawValues["cpf"] = substr($data["cpf"],0,100);
		$showRawValues["telefone"] = substr($data["telefone"],0,100);
		$showRawValues["celular"] = substr($data["celular"],0,100);
		$showRawValues["operadora"] = substr($data["operadora"],0,100);
		$showRawValues["bairro"] = substr($data["bairro"],0,100);
		$showRawValues["regiao"] = substr($data["regiao"],0,100);
		$showRawValues["cidade"] = substr($data["cidade"],0,100);
		$showRawValues["estado"] = substr($data["estado"],0,100);
		$showRawValues["grupo"] = substr($data["grupo"],0,100);
		$showRawValues["curso"] = substr($data["curso"],0,100);
		$showRawValues["materias"] = substr($data["materias"],0,100);
		$showRawValues["manha"] = substr($data["manha"],0,100);
		$showRawValues["tarde"] = substr($data["tarde"],0,100);
		$showRawValues["noite"] = substr($data["noite"],0,100);
		$showRawValues["aulas"] = substr($data["aulas"],0,100);
		$showRawValues["aulas_onde"] = substr($data["aulas_onde"],0,100);
		$showRawValues["bolsista"] = substr($data["bolsista"],0,100);
		$showRawValues["motivos"] = substr($data["motivos"],0,100);
		$showRawValues["ano"] = substr($data["ano"],0,100);
		$showRawValues["historico"] = substr($data["historico"],0,100);
		$showRawValues["atualizado"] = substr($data["atualizado"],0,100);
		$showRawValues["em_quantos_nucleos"] = substr($data["em_quantos_nucleos"],0,100);
	
	// for custom expression for display field
	if ($dispFieldAlias)
	{
		$showValues[] = $data[$dispFieldAlias];	
		$showFields[] = $dispFieldAlias;
		$showRawValues[] = substr($data[$dispFieldAlias],0,100);
	}
	
	if($inlineadd==ADD_INLINE || $inlineadd==ADD_POPUP)
	{	
		if($IsSaved && count($showValues))
		{
			$returnJSON['success'] = true;
			if($HaveData){
				$returnJSON['noKeys'] = false;
			}else{
				$returnJSON['noKeys'] = true;
			}
			
			$returnJSON['keys'] = $jsKeys;
			$returnJSON['keyFields'] = $keyFields;
			$returnJSON['vals'] = $showValues;
			$returnJSON['fields'] = $showFields;
			$returnJSON['rawVals'] = $showRawValues;
			$returnJSON['detKeys'] = $showDetailKeys;
			$returnJSON['userMess'] = $usermessage;
			$returnJSON['hrefs'] = $pageObject->buildDetailGridLinks($showDetailKeys);
			// add link and display value if list page is lookup with search
			if(array_key_exists('linkField', $linkAndDispVals))
			{
				$returnJSON['linkValue'] = $linkAndDispVals['linkField'];
				$returnJSON['displayValue'] = $linkAndDispVals['displayField'];
			}
			if($globalEvents->exists("IsRecordEditable", $strTableName))
			{ 
				if(!$globalEvents->IsRecordEditable($showRawValues, true, $strTableName))
					$returnJSON['nonEditable'] = true;
			}
			
			if($inlineadd==ADD_POPUP && isset($_SESSION[$strTableName."_count_captcha"]) || $_SESSION[$strTableName."_count_captcha"]>0 || $_SESSION[$strTableName."_count_captcha"]<5)
				$returnJSON['hideCaptcha'] = true;
		}
		else
		{
			$returnJSON['success'] = false;
			$returnJSON['message'] = $message;
			if(!$pageObject->isCaptchaOk)
				$returnJSON['captcha'] = false;
		}
		echo "<textarea>".htmlspecialchars(my_json_encode($returnJSON))."</textarea>";
		exit();
	}
} 

/////////////////////////////////////////////////////////////
if($inlineadd==ADD_MASTER)
{
	$respJSON = array();
	if(($_POST["a"]=="added" && $IsSaved))
	{
		$respJSON['afterAddId'] = $afterAdd_id;
		$respJSON['success'] = true;
		$respJSON['fields'] = $showFields;
		$respJSON['vals'] = $showValues;
		if($onFly){
			if($HaveData)
				$respJSON['noKeys'] = false;
			else
				$respJSON['noKeys'] = true;
			$respJSON['keys'] = $jsKeys;
			$respJSON['keyFields'] = $keyFields;
			$respJSON['rawVals'] = $showRawValues;
			$respJSON['detKeys'] = $showDetailKeys;
			$respJSON['userMess'] = $usermessage;
			$respJSON['hrefs'] = $pageObject->buildDetailGridLinks($showDetailKeys);
			if($globalEvents->exists("IsRecordEditable", $strTableName))
			{
				if(!$globalEvents->IsRecordEditable($showRawValues, true, $strTableName))
					$respJSON['nonEditable'] = true;
			}
		}
		$respJSON['mKeys'] = array();
		for($i=0;$i<count($dpParams['ids']);$i++)
		{
			$data=0;
			if(count($keys))
			{
				$where=KeyWhere($keys);
							$strSQL = $gQuery->gSQLWhere($where);
				LogInfo($strSQL);
				$rs = db_query($strSQL,$conn);
				$data = $pageObject->cipherer->DecryptFetchedArray($rs);
			}
			if(!$data)
				$data=$avalues;
			
			$mKeyId = 1;
			foreach($mKeys[$dpParams['strTableNames'][$i]] as $mk)
			{
				if($data[$mk])
					$respJSON['mKeys'][$dpParams['strTableNames'][$i]]['masterkey'.$mKeyId++] = $data[$mk];
				else
					$respJSON['mKeys'][$dpParams['strTableNames'][$i]]['masterkey'.$mKeyId++] = '';
			}
		}
		if(isset($_SESSION[$strTableName."_count_captcha"]) || $_SESSION[$strTableName."_count_captcha"]>0 || $_SESSION[$strTableName."_count_captcha"]<5)
			$respJSON['hidecaptcha'] = true;
	}
	else{
			$respJSON['success'] = false;
			if(!$pageObject->isCaptchaOk)
				$respJSON['captcha'] = false;
			else
				$respJSON['error'] = $message;
			if($onFly)
				$respJSON['message'] = $message;
		}
	echo "<textarea>".htmlspecialchars(my_json_encode($respJSON))."</textarea>";
	exit();
}

/////////////////////////////////////////////////////////////
//	prepare Edit Controls
/////////////////////////////////////////////////////////////

//	validation stuff
$regex='';
$regexmessage='';
$regextype = '';
$control = array();

foreach($addFields as $fName)
{
	$gfName = GoodFieldName($fName);
	$controls = array('controls'=>array());
	if(!$detailKeys || !in_array($fName, $detailKeys) || $fName == postvalue("category"))
	{
		$control[$gfName] = array();
		$control[$gfName]["func"] = "xt_buildeditcontrol";
		$control[$gfName]["params"] = array();
		$control[$gfName]["params"]["id"] = $id;
		$control[$gfName]["params"]["ptype"] = PAGE_ADD;
		$control[$gfName]["params"]["field"] = $fName;
		$control[$gfName]["params"]["value"] = @$defvalues[$fName];
		$control[$gfName]["params"]["pageObj"] = $pageObject;
		if($pageObject->pSet->isUseRTE($fName))
			$_SESSION[$strTableName."_".$fName."_rte"] = @$defvalues[$fName];
		
		//	Begin Add validation
		$arrValidate = $pageObject->pSet->getValidation($fName);
		$control[$gfName]["params"]["validate"] = $arrValidate;
		//	End Add validation
	}
	$controls["controls"]['ctrlInd'] = 0;
	$controls["controls"]['id'] = $id;
	$controls["controls"]['fieldName'] = $fName;
	//if richEditor for field
	if($pageObject->pSet->isUseRTE($fName))
	{
		if(!$detailKeys || !in_array($fName, $detailKeys))
			$control[$gfName]["params"]["mode"]="add";
		$controls["controls"]['mode'] = "add";
	}
	else
	{
		if($inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
		{
			if(!$detailKeys || !in_array($fName, $detailKeys) || $fName == postvalue("category"))	
				$control[$gfName]["params"]["mode"]="inline_add";
			$controls["controls"]['mode'] = "inline_add";
		}
		else
		{
			if(!$detailKeys || !in_array($fName, $detailKeys) || $fName == postvalue("category"))	
				$control[$gfName]["params"]["mode"]="add";
			$controls["controls"]['mode'] = "add";
		}
	}
	
	if(!$detailKeys || !in_array($fName, $detailKeys))
		$xt->assignbyref($gfName."_editcontrol",$control[$gfName]);
	elseif($detailKeys && in_array($fName, $detailKeys))
		$controls["controls"]['value'] = @$defvalues[$fName];
	
	// category control field
	$strCategoryControl = $pageObject->isDependOnField($fName);
	
	if($strCategoryControl!==false && in_array($strCategoryControl, $addFields))
		$vals = array($fName => @$defvalues[$fName], $strCategoryControl => @$defvalues[$strCategoryControl]);
	else
		$vals = array($fName => @$defvalues[$fName]);
	
	$preload = $pageObject->fillPreload($fName, $vals);
	if($preload!==false)
	{
		$controls["controls"]['preloadData'] = $preload;
		if(!@$defvalues[$fName] && count($preload["vals"])>0)
			$defvalues[$fName] = $preload["vals"][0];
	}
	$pageObject->fillControlsMap($controls);
	
	//fill field tool tips
	$pageObject->fillFieldToolTips($fName);
	
	// fill special settings for timepicker
	if($pageObject->pSet->getEditFormat($fName) == 'Time')
		$pageObject->fillTimePickSettings($fName, @$defvalues[$fName]);
	
	if((($detailKeys && in_array($fName, $detailKeys)) || $fName == postvalue("category")) && array_key_exists($fName, $defvalues))
	{
		$value = $pageObject->showDBValue($fName, $defvalues);
		
		$xt->assign($gfName."_editcontrol", $value);
	}
}

//fill tab groups name and sections name to controls
$pageObject->fillCntrlTabGroups();

/////////////////////////////////////////////////////////////
if($pageObject->isShowDetailTables && ($inlineadd==ADD_SIMPLE || $inlineadd==ADD_POPUP) && !isMobile())
{
	if(count($dpParams['ids']))
	{
		$xt->assign("detail_tables",true);
		include('classes/listpage.php');
		include('classes/listpage_embed.php');
		include('classes/listpage_dpinline.php');
		include("classes/searchclause.php");
	}
	
	$dControlsMap = array();
	$dViewControlsMap = array();
		
	$flyId = $ids+1;
	for($d=0;$d<count($dpParams['ids']);$d++)
	{
		$options = array();
		//array of params for classes
		$options["mode"] = LIST_DETAILS;
		$options["pageType"] = PAGE_LIST;
		$options["masterPageType"] = PAGE_ADD;
		$options["mainMasterPageType"] = PAGE_ADD;
		$options['masterTable'] = "professor";
		$options['firstTime'] = 1;
		
		$strTableName = $dpParams['strTableNames'][$d];
		include_once("include/".GetTableURL($strTableName)."_settings.php");
		
		$layout = GetPageLayout(GoodFieldName($strTableName), PAGE_LIST);
		if($layout)
		{
			$rtl = $xt->getReadingOrder() == 'RTL' ? 'RTL' : '';
			$xt->cssFiles[] = array("stylepath" => "styles/".$layout->style.'/style'.$rtl.".css"
				, "pagestylepath" => "pagestyles/".$layout->name.$rtl.".css");
			$xt->IEcssFiles[] = array("stylepathIE" => "styles/".$layout->style.'/styleIE'.".css");
		}	
			
		$options['xt'] = new Xtempl();
		$options['id'] = $dpParams['ids'][$d];
		$options['flyId'] = $flyId++;
		$mkr = 1;
		
		foreach($mKeys[$strTableName] as $mk)
		{
			if($defvalues[$mk])
				$options['masterKeysReq'][$mkr++] = $defvalues[$mk];
			else
				$options['masterKeysReq'][$mkr++] = '';
		}
		$listPageObject = ListPage::createListPage($strTableName,$options);
		
		// prepare code
		$listPageObject->prepareForBuildPage();
		$flyId = $listPageObject->recId+1;
		
		//set page events
		foreach($listPageObject->eventsObject->events as $event => $name)
			$listPageObject->xt->assign_event($event, $listPageObject->eventsObject, $event, array());
		
		//add detail settings to master settings
		$listPageObject->addControlsJSAndCSS();
		$listPageObject->fillSetCntrlMaps();
		$pageObject->jsSettings['tableSettings'][$strTableName]	= $listPageObject->jsSettings['tableSettings'][$strTableName];

		$dControlsMap[$strTableName] = $listPageObject->controlsMap;
		$dViewControlsMap[$strTableName] = $listPageObject->viewControlsMap;
		
		foreach($listPageObject->jsSettings["global"]["shortTNames"] as $tName => $shortTName){
			$pageObject->settingsMap["globalSettings"]["shortTNames"][$tName] = $shortTName;
		}
		
		//Add detail's js files to master's files
		$pageObject->copyAllJSFiles($listPageObject->grabAllJSFiles());
		
		//Add detail's css files to master's files
		$pageObject->copyAllCSSFiles($listPageObject->grabAllCSSFiles());
		
		$xtParams = array("method"=>'showPage', "params"=> false);
		$xtParams['object'] = $listPageObject;
		$xt->assign("displayDetailTable_".GoodFieldName($listPageObject->tName), $xtParams);
		$pageObject->controlsMap['dpTablesParams'][] = array('tName'=>$strTableName, 'id'=>$options['id']);
	}
	$pageObject->controlsMap['dControlsMap'] = $dControlsMap;
	$pageObject->viewControlsMap['dViewControlsMap'] = $dViewControlsMap;
	$strTableName = "professor";
}
/////////////////////////////////////////////////////////////
//fill jsSettings and ControlsHTMLMap
$pageObject->fillSetCntrlMaps();

$pageObject->addCommonJs();

//For mobile version in apple device

if($inlineadd == ADD_SIMPLE)
{
	$pageObject->body['end'] = array();
	$pageObject->body['end']["method"] = "assignBodyEnd";
	$pageObject->body['end']["object"] = &$pageObject;
	$xt->assign("body", $pageObject->body);
	$xt->assign("flybody",true);
}

if($inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_MASTER || $inlineadd==ADD_POPUP)
{ 
	$xt->assign("footer",false);
	$xt->assign("header",false);
	$xt->assign("flybody", $pageObject->body);
	$xt->assign("body",true);
}	

$xt->assign("style_block",true);
$pageObject->xt->assign("legend", true);

if($eventObj->exists("BeforeShowAdd"))
	$eventObj->BeforeShowAdd($xt, $templatefile, $pageObject);
	
if($inlineadd != ADD_SIMPLE)
{
	$returnJSON['controlsMap'] = $pageObject->controlsHTMLMap;
	$returnJSON['viewControlsMap'] = $pageObject->viewControlsHTMLMap;
	$returnJSON['settings'] = $pageObject->jsSettings;	
}

if($inlineadd==ADD_ONTHEFLY || $inlineadd==ADD_POPUP)
{
	$xt->load_template($templatefile);
	$returnJSON['html'] = $xt->fetch_loaded('style_block').$xt->fetch_loaded('body');
	if(count($pageObject->includes_css))
		$returnJSON['CSSFiles'] = array_unique($pageObject->includes_css);
	if(count($pageObject->includes_cssIE))
		$returnJSON['CSSFilesIE'] = array_unique($pageObject->includes_cssIE);
	$returnJSON["additionalJS"] = $pageObject->grabAllJsFiles();
	$returnJSON['idStartFrom'] = $id+1;	
	echo (my_json_encode($returnJSON)); 
}
elseif ($inlineadd == ADD_INLINE)
{
	$xt->load_template($templatefile);
	$returnJSON["html"] = array();
	foreach($addFields as $fName)
	{
		$returnJSON["html"][$fName] = $xt->fetchVar(GoodFieldName($fName)."_editcontrol");	
	}	
	$returnJSON["additionalJS"] = $pageObject->grabAllJsFiles();
	$returnJSON["additionalCSS"] = $pageObject->grabAllCSSFiles();
	echo (my_json_encode($returnJSON)); 
}
else
	$xt->display($templatefile);

function GetAddedDataLookupQuery($pageObject, $keys, $forLookup)
{
	global $conn, $strTableName, $strOriginalTableName;
	
	$LookupSQL = "";
	$linkfield = "";
	$dispfield = "";
	$noBlobReplace = false;
	$lookupFieldName = "";
	
	if($LookupSQL && $nLookupType != LT_QUERY)
		$LookupSQL.=" from ".AddTableWrappers($strOriginalTableName);
		
	$data = 0;
	$lookupIndexes = array("linkFieldIndex" => 0, "displayFieldIndex" => 0);
	if(count($keys))
	{
		$where = KeyWhere($keys);
		if($nLookupType == LT_QUERY){
			$LookupSQL = $lookupQueryObj->toSql(whereAdd($lookupQueryObj->m_where->toSql($lookupQueryObj), $where));
		}else 
			$LookupSQL.=" where ".$where;
		$lookupIndexes = GetLookupFieldsIndexes($lookupPSet, $lookupFieldName);
		LogInfo($LookupSQL);
		if($forLookup){
			$rs=db_query($LookupSQL,$conn);
			$data = $pageObject->cipherer->DecryptFetchedArray($rs);
		}else if($LookupSQL)
		{
			$rs = db_query($LookupSQL,$conn);
			$data = db_fetch_numarray($rs);
			$data[$lookupIndexes["linkFieldIndex"]] = $pageObject->cipherer->DecryptField($linkFieldName, $data[$lookupIndexes["linkFieldIndex"]]);
			if($nLookupType == LT_QUERY)
				$data[$lookupIndexes["displayFieldIndex"]] = $pageObject->cipherer->DecryptField($dispfield, $data[$lookupIndexes["displayFieldIndex"]]);		
		}
	}

	return array($data, array("linkField" => $linkFieldName, "displayField" => $dispfield
		, "linkFieldIndex" => $lookupIndexes["linkFieldIndex"], "displayFieldIndex" => $lookupIndexes["displayFieldIndex"]));
}	
	
?>
