<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

include("include/dbcommon.php");
include("classes/searchclause.php");

add_nocache_headers();

include("include/professor_variables.php");

if(!isLogged())
{ 
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	header("Location: login.php?message=expired"); 
	return;
}
if(CheckPermissionsEvent($strTableName, 'P') && !CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Export"))
{
	echo "<p>"."Voc no tem permisso para acessar esta tabela"."<a href=\"login.php\">"."Voltar  pgina de Login"."</a></p>";
	return;
}

$layout = new TLayout("print","FusionOrange","MobileOrange");
$layout->blocks["center"] = array();
$layout->containers["grid"] = array();

$layout->containers["grid"][] = array("name"=>"printgrid","block"=>"grid_block","substyle"=>1);


$layout->skins["grid"] = "empty";
$layout->blocks["center"][] = "grid";$layout->blocks["top"] = array();
$layout->skins["master"] = "empty";
$layout->blocks["top"][] = "master";
$layout->skins["pdf"] = "empty";
$layout->blocks["top"][] = "pdf";$page_layouts["professor_print"] = $layout;


include('include/xtempl.php');
include('classes/runnerpage.php');

$cipherer = new RunnerCipherer($strTableName);

$xt = new Xtempl();
$id = postvalue("id") != "" ? postvalue("id") : 1;
$all = postvalue("all");
$pageName = "print.php";

//array of params for classes
$params = array("id" => $id,
				"tName" => $strTableName,
				"pageType" => PAGE_PRINT);
$params["xt"] = &$xt;
			
$pageObject = new RunnerPage($params);

// add button events if exist
$pageObject->addButtonHandlers();

// Modify query: remove blob fields from fieldlist.
// Blob fields on a print page are shown using imager.php (for example).
// They don't need to be selected from DB in print.php itself.
$noBlobReplace = false;
if(!postvalue("pdf") && !$noBlobReplace)
	$gQuery->ReplaceFieldsWithDummies($pageObject->pSet->getBinaryFieldsIndices());

//	Before Process event
if($eventObj->exists("BeforeProcessPrint"))
	$eventObj->BeforeProcessPrint($conn, $pageObject);

$strWhereClause="";
$strHavingClause="";
$strSearchCriteria="and";

$selected_recs=array();
if (@$_REQUEST["a"]!="") 
{
	$sWhere = "1=0";	
	
//	process selection
	if (@$_REQUEST["mdelete"])
	{
		foreach(@$_REQUEST["mdelete"] as $ind)
		{
			$keys=array();
			$keys["id"]=refine($_REQUEST["mdelete1"][mdeleteIndex($ind)]);
			$selected_recs[]=$keys;
		}
	}
	elseif(@$_REQUEST["selection"])
	{
		foreach(@$_REQUEST["selection"] as $keyblock)
		{
			$arr=explode("&",refine($keyblock));
			if(count($arr)<1)
				continue;
			$keys=array();
			$keys["id"]=urldecode($arr[0]);
			$selected_recs[]=$keys;
		}
	}

	foreach($selected_recs as $keys)
	{
		$sWhere = $sWhere . " or ";
		$sWhere.=KeyWhere($keys);
	}
	$strSQL = $gQuery->gSQLWhere($sWhere);
	$strWhereClause=$sWhere;
}
else
{
	$strWhereClause=@$_SESSION[$strTableName."_where"];
	$strHavingClause=@$_SESSION[$strTableName."_having"];
	$strSearchCriteria=@$_SESSION[$strTableName."_criteria"];
	$strSQL = $gQuery->gSQLWhere($strWhereClause, $strHavingClause, $strSearchCriteria);
}
if(postvalue("pdf"))
	$strWhereClause = @$_SESSION[$strTableName."_pdfwhere"];

$_SESSION[$strTableName."_pdfwhere"] = $strWhereClause;


$strOrderBy = $_SESSION[$strTableName."_order"];
if(!$strOrderBy)
	$strOrderBy=$gstrOrderBy;
$strSQL.=" ".trim($strOrderBy);

$strSQLbak = $strSQL;
if($eventObj->exists("BeforeQueryPrint"))
	$eventObj->BeforeQueryPrint($strSQL,$strWhereClause,$strOrderBy, $pageObject);

//	Rebuild SQL if needed

if($strSQL!=$strSQLbak)
{
//	changed $strSQL - old style	
	$numrows=GetRowCount($strSQL);
}
else
{
	$strSQL = $gQuery->gSQLWhere($strWhereClause, $strHavingClause, $strSearchCriteria);
	$strSQL.=" ".trim($strOrderBy);
	
	$rowcount=false;
	if($eventObj->exists("ListGetRowCount"))
	{
		$masterKeysReq=array();
		for($i = 0; $i < count($pageObject->detailKeysByM); $i ++)
			$masterKeysReq[]=$_SESSION[$strTableName."_masterkey".($i + 1)];
			$rowcount=$eventObj->ListGetRowCount($pageObject->searchClauseObj,$_SESSION[$strTableName."_mastertable"],$masterKeysReq,$selected_recs, $pageObject);
	}
	if($rowcount!==false)
		$numrows=$rowcount;
	else
	{
		$numrows = $gQuery->gSQLRowCount($strWhereClause, $strHavingClause, $strSearchCriteria);
	}
}

LogInfo($strSQL);

$mypage=(integer)$_SESSION[$strTableName."_pagenumber"];
if(!$mypage)
	$mypage=1;

//	page size
$PageSize=(integer)$_SESSION[$strTableName."_pagesize"];
if(!$PageSize)
	$PageSize = $pageObject->pSet->getInitialPageSize();

if($PageSize<0)
	$all = 1;	
	
$recno = 1;
$records = 0;	
$maxpages = 1;
$pageindex = 1;
$pageno=1;

// build arrays for sort (to support old code in user-defined events)
if($eventObj->exists("ListQuery"))
{
	$arrFieldForSort = array();
	$arrHowFieldSort = array();
	require_once getabspath('classes/orderclause.php');
	$fieldList = unserialize($_SESSION[$strTableName."_orderFieldsList"]);
	for($i = 0; $i < count($fieldList); $i++)
	{
		$arrFieldForSort[] = $fieldList[$i]->fieldIndex; 
		$arrHowFieldSort[] = $fieldList[$i]->orderDirection; 
	}
}

if(!$all)
{	
	if($numrows)
	{
		$maxRecords = $numrows;
		$maxpages = ceil($maxRecords/$PageSize);
					
		if($mypage > $maxpages)
			$mypage = $maxpages;
		
		if($mypage < 1) 
			$mypage = 1;
		
		$maxrecs = $PageSize;
	}
	$listarray = false;
	if($eventObj->exists("ListQuery"))
		$listarray = $eventObj->ListQuery($pageObject->searchClauseObj, $arrFieldForSort, $arrHowFieldSort, 
			$_SESSION[$strTableName."_mastertable"], $masterKeysReq, $selected_recs, $PageSize, $mypage, $pageObject);
	if($listarray!==false)
		$rs = $listarray;
	else
	{
			if($numrows)
		{
			$strSQL.=" limit ".(($mypage-1)*$PageSize).",".$PageSize;
		}
		$rs = db_query($strSQL,$conn);
	}
	
	//	hide colunm headers if needed
	$recordsonpage = $numrows-($mypage-1)*$PageSize;
	if($recordsonpage>$PageSize)
		$recordsonpage = $PageSize;
		
	$xt->assign("page_number",true);
	$xt->assign("maxpages",$maxpages);
	$xt->assign("pageno",$mypage);
}
else
{
	$listarray = false;
	if($eventObj->exists("ListQuery"))
		$listarray=$eventObj->ListQuery($pageObject->searchClauseObj, $arrFieldForSort, $arrHowFieldSort,
			$_SESSION[$strTableName."_mastertable"], $masterKeysReq, $selected_recs, $PageSize, $mypage, $pageObject);
	if($listarray!==false)
		$rs = $listarray;
	else
		$rs = db_query($strSQL,$conn);
	$recordsonpage = $numrows;
	$maxpages = ceil($recordsonpage/30);
	$xt->assign("page_number",true);
	$xt->assign("maxpages",$maxpages);
}


$fieldsArr = array();
$arr = array();
$arr['fName'] = "id";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("id");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "nome";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("nome");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "email";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("email");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "cpf";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("cpf");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "telefone";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("telefone");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "celular";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("celular");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "operadora";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("operadora");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "bairro";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("bairro");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "regiao";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("regiao");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "cidade";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("cidade");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "estado";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("estado");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "grupo";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("grupo");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "curso";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("curso");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "materias";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("materias");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "manha";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("manha");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "tarde";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("tarde");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "noite";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("noite");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "aulas";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("aulas");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "aulas_onde";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("aulas_onde");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "bolsista";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("bolsista");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "motivos";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("motivos");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "ano";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("ano");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "historico";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("historico");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "atualizado";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("atualizado");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "em_quantos_nucleos";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("em_quantos_nucleos");
$fieldsArr[] = $arr;
$pageObject->setGoogleMapsParams($fieldsArr);

$colsonpage=1;
if($colsonpage>$recordsonpage)
	$colsonpage=$recordsonpage;
if($colsonpage<1)
	$colsonpage=1;


//	fill $rowinfo array
	$pages = array();
	$rowinfo = array();
	$rowinfo["data"] = array();
	if($eventObj->exists("ListFetchArray"))
		$data = $eventObj->ListFetchArray($rs, $pageObject);
	else
		$data = $cipherer->DecryptFetchedArray($rs);

	while($data)
	{
		if($eventObj->exists("BeforeProcessRowPrint"))
		{
			if(!$eventObj->BeforeProcessRowPrint($data, $pageObject))
			{
				if($eventObj->exists("ListFetchArray"))
					$data = $eventObj->ListFetchArray($rs, $pageObject);
				else
					$data = $cipherer->DecryptFetchedArray($rs);
				continue;
			}
		}
		break;
	}
	
	while($data && ($all || $recno<=$PageSize))
	{
		$row = array();
		$row["grid_record"] = array();
		$row["grid_record"]["data"] = array();
		for($col=1;$data && ($all || $recno<=$PageSize) && $col<=1;$col++)
		{
			$record = array();
			$recno++;
			$records++;
			$keylink="";
			$keylink.="&key1=".htmlspecialchars(rawurlencode(@$data["id"]));

//	id - 
			$record["id_value"] = $pageObject->showDBValue("id", $data, $keylink);
			$record["id_class"] = $pageObject->fieldClass("id");
//	nome - 
			$record["nome_value"] = $pageObject->showDBValue("nome", $data, $keylink);
			$record["nome_class"] = $pageObject->fieldClass("nome");
//	email - 
			$record["email_value"] = $pageObject->showDBValue("email", $data, $keylink);
			$record["email_class"] = $pageObject->fieldClass("email");
//	cpf - 
			$record["cpf_value"] = $pageObject->showDBValue("cpf", $data, $keylink);
			$record["cpf_class"] = $pageObject->fieldClass("cpf");
//	telefone - 
			$record["telefone_value"] = $pageObject->showDBValue("telefone", $data, $keylink);
			$record["telefone_class"] = $pageObject->fieldClass("telefone");
//	celular - 
			$record["celular_value"] = $pageObject->showDBValue("celular", $data, $keylink);
			$record["celular_class"] = $pageObject->fieldClass("celular");
//	operadora - 
			$record["operadora_value"] = $pageObject->showDBValue("operadora", $data, $keylink);
			$record["operadora_class"] = $pageObject->fieldClass("operadora");
//	bairro - 
			$record["bairro_value"] = $pageObject->showDBValue("bairro", $data, $keylink);
			$record["bairro_class"] = $pageObject->fieldClass("bairro");
//	regiao - 
			$record["regiao_value"] = $pageObject->showDBValue("regiao", $data, $keylink);
			$record["regiao_class"] = $pageObject->fieldClass("regiao");
//	cidade - 
			$record["cidade_value"] = $pageObject->showDBValue("cidade", $data, $keylink);
			$record["cidade_class"] = $pageObject->fieldClass("cidade");
//	estado - 
			$record["estado_value"] = $pageObject->showDBValue("estado", $data, $keylink);
			$record["estado_class"] = $pageObject->fieldClass("estado");
//	grupo - 
			$record["grupo_value"] = $pageObject->showDBValue("grupo", $data, $keylink);
			$record["grupo_class"] = $pageObject->fieldClass("grupo");
//	curso - 
			$record["curso_value"] = $pageObject->showDBValue("curso", $data, $keylink);
			$record["curso_class"] = $pageObject->fieldClass("curso");
//	materias - 
			$record["materias_value"] = $pageObject->showDBValue("materias", $data, $keylink);
			$record["materias_class"] = $pageObject->fieldClass("materias");
//	manha - 
			$record["manha_value"] = $pageObject->showDBValue("manha", $data, $keylink);
			$record["manha_class"] = $pageObject->fieldClass("manha");
//	tarde - 
			$record["tarde_value"] = $pageObject->showDBValue("tarde", $data, $keylink);
			$record["tarde_class"] = $pageObject->fieldClass("tarde");
//	noite - 
			$record["noite_value"] = $pageObject->showDBValue("noite", $data, $keylink);
			$record["noite_class"] = $pageObject->fieldClass("noite");
//	aulas - 
			$record["aulas_value"] = $pageObject->showDBValue("aulas", $data, $keylink);
			$record["aulas_class"] = $pageObject->fieldClass("aulas");
//	aulas_onde - 
			$record["aulas_onde_value"] = $pageObject->showDBValue("aulas_onde", $data, $keylink);
			$record["aulas_onde_class"] = $pageObject->fieldClass("aulas_onde");
//	bolsista - 
			$record["bolsista_value"] = $pageObject->showDBValue("bolsista", $data, $keylink);
			$record["bolsista_class"] = $pageObject->fieldClass("bolsista");
//	motivos - 
			$record["motivos_value"] = $pageObject->showDBValue("motivos", $data, $keylink);
			$record["motivos_class"] = $pageObject->fieldClass("motivos");
//	ano - 
			$record["ano_value"] = $pageObject->showDBValue("ano", $data, $keylink);
			$record["ano_class"] = $pageObject->fieldClass("ano");
//	historico - 
			$record["historico_value"] = $pageObject->showDBValue("historico", $data, $keylink);
			$record["historico_class"] = $pageObject->fieldClass("historico");
//	atualizado - 
			$record["atualizado_value"] = $pageObject->showDBValue("atualizado", $data, $keylink);
			$record["atualizado_class"] = $pageObject->fieldClass("atualizado");
//	em_quantos_nucleos - 
			$record["em_quantos_nucleos_value"] = $pageObject->showDBValue("em_quantos_nucleos", $data, $keylink);
			$record["em_quantos_nucleos_class"] = $pageObject->fieldClass("em_quantos_nucleos");
			if($col<$colsonpage)
				$record["endrecord_block"] = true;
			$record["grid_recordheader"] = true;
			$record["grid_vrecord"] = true;
			
			if($eventObj->exists("BeforeMoveNextPrint"))
				$eventObj->BeforeMoveNextPrint($data,$row,$record, $pageObject);
				
			$row["grid_record"]["data"][] = $record;
			
			if($eventObj->exists("ListFetchArray"))
				$data = $eventObj->ListFetchArray($rs, $pageObject);
			else
				$data = $cipherer->DecryptFetchedArray($rs);
				
			while($data)
			{
				if($eventObj->exists("BeforeProcessRowPrint"))
				{
					if(!$eventObj->BeforeProcessRowPrint($data, $pageObject))
					{
						if($eventObj->exists("ListFetchArray"))
							$data = $eventObj->ListFetchArray($rs, $pageObject);
						else
							$data = $cipherer->DecryptFetchedArray($rs);
						continue;
					}
				}
				break;
			}
		}
		if($col <= $colsonpage)
		{
			$row["grid_record"]["data"][count($row["grid_record"]["data"])-1]["endrecord_block"] = false;
		}
		$row["grid_rowspace"]=true;
		$row["grid_recordspace"] = array("data"=>array());
		for($i=0;$i<$colsonpage*2-1;$i++)
			$row["grid_recordspace"]["data"][]=true;
		
		$rowinfo["data"][]=$row;
		
		if($all && $records>=30)
		{
			$page=array("grid_row" =>$rowinfo);
			$page["pageno"]=$pageindex;
			$pageindex++;
			$pages[] = $page;
			$records=0;
			$rowinfo=array();
		}
		
	}
	if(count($rowinfo))
	{
		$page=array("grid_row" =>$rowinfo);
		if($all)
			$page["pageno"]=$pageindex;
		$pages[] = $page;
	}
	
	for($i=0;$i<count($pages);$i++)
	{
	 	if($i<count($pages)-1)
			$pages[$i]["begin"]="<div name=page class=printpage>";
		else
		    $pages[$i]["begin"]="<div name=page>";
			
		$pages[$i]["end"]="</div>";
	}

	$page = array();
	$page["data"] = &$pages;
	$xt->assignbyref("page",$page);

	

$strSQL = $_SESSION[$strTableName."_sql"];

$isPdfView = false;
$hasEvents = false;
if ($pageObject->pSet->isUsebuttonHandlers() || $isPdfView || $hasEvents)
{
	$pageObject->body["begin"] .="<script type=\"text/javascript\" src=\"include/loadfirst.js\"></script>\r\n";
		$pageObject->body["begin"] .= "<script type=\"text/javascript\" src=\"include/lang/".getLangFileName(mlang_getcurrentlang()).".js\"></script>";
	
	$pageObject->fillSetCntrlMaps();
	$pageObject->body['end'] .= '<script>';
	$pageObject->body['end'] .= "window.controlsMap = ".my_json_encode($pageObject->controlsHTMLMap).";";
	$pageObject->body['end'] .= "window.viewControlsMap = ".my_json_encode($pageObject->viewControlsHTMLMap).";";
	$pageObject->body['end'] .= "window.settings = ".my_json_encode($pageObject->jsSettings).";";
	$pageObject->body['end'] .= '</script>';
		$pageObject->body["end"] .= "<script language=\"JavaScript\" src=\"include/runnerJS/RunnerAll.js\"></script>\r\n";
	$pageObject->addCommonJs();
}


if ($pageObject->pSet->isUsebuttonHandlers() || $isPdfView || $hasEvents)
	$pageObject->body["end"] .= "<script>".$pageObject->PrepareJS()."</script>";

$xt->assignbyref("body",$pageObject->body);
$xt->assign("grid_block",true);

$xt->assign("id_fieldheadercolumn",true);
$xt->assign("id_fieldheader",true);
$xt->assign("id_fieldcolumn",true);
$xt->assign("id_fieldfootercolumn",true);
$xt->assign("nome_fieldheadercolumn",true);
$xt->assign("nome_fieldheader",true);
$xt->assign("nome_fieldcolumn",true);
$xt->assign("nome_fieldfootercolumn",true);
$xt->assign("email_fieldheadercolumn",true);
$xt->assign("email_fieldheader",true);
$xt->assign("email_fieldcolumn",true);
$xt->assign("email_fieldfootercolumn",true);
$xt->assign("cpf_fieldheadercolumn",true);
$xt->assign("cpf_fieldheader",true);
$xt->assign("cpf_fieldcolumn",true);
$xt->assign("cpf_fieldfootercolumn",true);
$xt->assign("telefone_fieldheadercolumn",true);
$xt->assign("telefone_fieldheader",true);
$xt->assign("telefone_fieldcolumn",true);
$xt->assign("telefone_fieldfootercolumn",true);
$xt->assign("celular_fieldheadercolumn",true);
$xt->assign("celular_fieldheader",true);
$xt->assign("celular_fieldcolumn",true);
$xt->assign("celular_fieldfootercolumn",true);
$xt->assign("operadora_fieldheadercolumn",true);
$xt->assign("operadora_fieldheader",true);
$xt->assign("operadora_fieldcolumn",true);
$xt->assign("operadora_fieldfootercolumn",true);
$xt->assign("bairro_fieldheadercolumn",true);
$xt->assign("bairro_fieldheader",true);
$xt->assign("bairro_fieldcolumn",true);
$xt->assign("bairro_fieldfootercolumn",true);
$xt->assign("regiao_fieldheadercolumn",true);
$xt->assign("regiao_fieldheader",true);
$xt->assign("regiao_fieldcolumn",true);
$xt->assign("regiao_fieldfootercolumn",true);
$xt->assign("cidade_fieldheadercolumn",true);
$xt->assign("cidade_fieldheader",true);
$xt->assign("cidade_fieldcolumn",true);
$xt->assign("cidade_fieldfootercolumn",true);
$xt->assign("estado_fieldheadercolumn",true);
$xt->assign("estado_fieldheader",true);
$xt->assign("estado_fieldcolumn",true);
$xt->assign("estado_fieldfootercolumn",true);
$xt->assign("grupo_fieldheadercolumn",true);
$xt->assign("grupo_fieldheader",true);
$xt->assign("grupo_fieldcolumn",true);
$xt->assign("grupo_fieldfootercolumn",true);
$xt->assign("curso_fieldheadercolumn",true);
$xt->assign("curso_fieldheader",true);
$xt->assign("curso_fieldcolumn",true);
$xt->assign("curso_fieldfootercolumn",true);
$xt->assign("materias_fieldheadercolumn",true);
$xt->assign("materias_fieldheader",true);
$xt->assign("materias_fieldcolumn",true);
$xt->assign("materias_fieldfootercolumn",true);
$xt->assign("manha_fieldheadercolumn",true);
$xt->assign("manha_fieldheader",true);
$xt->assign("manha_fieldcolumn",true);
$xt->assign("manha_fieldfootercolumn",true);
$xt->assign("tarde_fieldheadercolumn",true);
$xt->assign("tarde_fieldheader",true);
$xt->assign("tarde_fieldcolumn",true);
$xt->assign("tarde_fieldfootercolumn",true);
$xt->assign("noite_fieldheadercolumn",true);
$xt->assign("noite_fieldheader",true);
$xt->assign("noite_fieldcolumn",true);
$xt->assign("noite_fieldfootercolumn",true);
$xt->assign("aulas_fieldheadercolumn",true);
$xt->assign("aulas_fieldheader",true);
$xt->assign("aulas_fieldcolumn",true);
$xt->assign("aulas_fieldfootercolumn",true);
$xt->assign("aulas_onde_fieldheadercolumn",true);
$xt->assign("aulas_onde_fieldheader",true);
$xt->assign("aulas_onde_fieldcolumn",true);
$xt->assign("aulas_onde_fieldfootercolumn",true);
$xt->assign("bolsista_fieldheadercolumn",true);
$xt->assign("bolsista_fieldheader",true);
$xt->assign("bolsista_fieldcolumn",true);
$xt->assign("bolsista_fieldfootercolumn",true);
$xt->assign("motivos_fieldheadercolumn",true);
$xt->assign("motivos_fieldheader",true);
$xt->assign("motivos_fieldcolumn",true);
$xt->assign("motivos_fieldfootercolumn",true);
$xt->assign("ano_fieldheadercolumn",true);
$xt->assign("ano_fieldheader",true);
$xt->assign("ano_fieldcolumn",true);
$xt->assign("ano_fieldfootercolumn",true);
$xt->assign("historico_fieldheadercolumn",true);
$xt->assign("historico_fieldheader",true);
$xt->assign("historico_fieldcolumn",true);
$xt->assign("historico_fieldfootercolumn",true);
$xt->assign("atualizado_fieldheadercolumn",true);
$xt->assign("atualizado_fieldheader",true);
$xt->assign("atualizado_fieldcolumn",true);
$xt->assign("atualizado_fieldfootercolumn",true);
$xt->assign("em_quantos_nucleos_fieldheadercolumn",true);
$xt->assign("em_quantos_nucleos_fieldheader",true);
$xt->assign("em_quantos_nucleos_fieldcolumn",true);
$xt->assign("em_quantos_nucleos_fieldfootercolumn",true);

	$record_header=array("data"=>array());
	$record_footer=array("data"=>array());
	for($i=0;$i<$colsonpage;$i++)
	{
		$rheader=array();
		$rfooter=array();
		if($i<$colsonpage-1)
		{
			$rheader["endrecordheader_block"]=true;
			$rfooter["endrecordheader_block"]=true;
		}
		$record_header["data"][]=$rheader;
		$record_footer["data"][]=$rfooter;
	}
	$xt->assignbyref("record_header",$record_header);
	$xt->assignbyref("record_footer",$record_footer);
	$xt->assign("grid_header",true);
	$xt->assign("grid_footer",true);

if($eventObj->exists("BeforeShowPrint"))
	$eventObj->BeforeShowPrint($xt,$pageObject->templatefile, $pageObject);

if(!postvalue("pdf"))
	$xt->display($pageObject->templatefile);
else
{
	$xt->load_template($pageObject->templatefile);
	$page = $xt->fetch_loaded();
	$pagewidth=postvalue("width")*1.05;
	$pageheight=postvalue("height")*1.05;
	$landscape=false;
		if($pagewidth>$pageheight)
		{
			$landscape=true;
			if($pagewidth/$pageheight<297/210)
				$pagewidth = 297/210*$pageheight;
		}
		else
		{
			if($pagewidth/$pageheight<210/297)
				$pagewidth = 210/297*$pageheight;
		}
}
?>
