<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

include("include/dbcommon.php");
include("classes/searchclause.php");

add_nocache_headers();

include("include/registros_variables.php");

if(!isLogged())
{ 
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	header("Location: login.php?message=expired"); 
	return;
}
if(CheckPermissionsEvent($strTableName, 'P') && !CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Export"))
{
	echo "<p>"."Voc no tem permisso para acessar esta tabela"."<a href=\"login.php\">"."Voltar  pgina de Login"."</a></p>";
	return;
}

$layout = new TLayout("print","BreezeAqua1","MobileAqua1");
$layout->blocks["center"] = array();
$layout->containers["grid"] = array();

$layout->containers["grid"][] = array("name"=>"printgrid","block"=>"grid_block","substyle"=>1);


$layout->skins["grid"] = "empty";
$layout->blocks["center"][] = "grid";$layout->blocks["top"] = array();
$layout->containers["master"] = array();

$layout->containers["master"][] = array("name"=>"masterinfoprint","block"=>"mastertable_block","substyle"=>1);


$layout->skins["master"] = "empty";
$layout->blocks["top"][] = "master";
$layout->skins["pdf"] = "empty";
$layout->blocks["top"][] = "pdf";$page_layouts["registros_print"] = $layout;


include('include/xtempl.php');
include('classes/runnerpage.php');

$cipherer = new RunnerCipherer($strTableName);

$xt = new Xtempl();
$id = postvalue("id") != "" ? postvalue("id") : 1;
$all = postvalue("all");
$pageName = "print.php";

//array of params for classes
$params = array("id" => $id,
				"tName" => $strTableName,
				"pageType" => PAGE_PRINT);
$params["xt"] = &$xt;
			
$pageObject = new RunnerPage($params);

// add button events if exist
$pageObject->addButtonHandlers();

// Modify query: remove blob fields from fieldlist.
// Blob fields on a print page are shown using imager.php (for example).
// They don't need to be selected from DB in print.php itself.
$noBlobReplace = false;
if(!postvalue("pdf") && !$noBlobReplace)
	$gQuery->ReplaceFieldsWithDummies($pageObject->pSet->getBinaryFieldsIndices());

//	Before Process event
if($eventObj->exists("BeforeProcessPrint"))
	$eventObj->BeforeProcessPrint($conn, $pageObject);

$strWhereClause="";
$strHavingClause="";
$strSearchCriteria="and";

$selected_recs=array();
if (@$_REQUEST["a"]!="") 
{
	$sWhere = "1=0";	
	
//	process selection
	if (@$_REQUEST["mdelete"])
	{
		foreach(@$_REQUEST["mdelete"] as $ind)
		{
			$keys=array();
			$keys["cpf"]=refine($_REQUEST["mdelete1"][mdeleteIndex($ind)]);
			$keys["email"]=refine($_REQUEST["mdelete2"][mdeleteIndex($ind)]);
			$selected_recs[]=$keys;
		}
	}
	elseif(@$_REQUEST["selection"])
	{
		foreach(@$_REQUEST["selection"] as $keyblock)
		{
			$arr=explode("&",refine($keyblock));
			if(count($arr)<2)
				continue;
			$keys=array();
			$keys["cpf"]=urldecode($arr[0]);
			$keys["email"]=urldecode($arr[1]);
			$selected_recs[]=$keys;
		}
	}

	foreach($selected_recs as $keys)
	{
		$sWhere = $sWhere . " or ";
		$sWhere.=KeyWhere($keys);
	}
	$strSQL = $gQuery->gSQLWhere($sWhere);
	$strWhereClause=$sWhere;
}
else
{
	$strWhereClause=@$_SESSION[$strTableName."_where"];
	$strHavingClause=@$_SESSION[$strTableName."_having"];
	$strSearchCriteria=@$_SESSION[$strTableName."_criteria"];
	$strSQL = $gQuery->gSQLWhere($strWhereClause, $strHavingClause, $strSearchCriteria);
}
if(postvalue("pdf"))
	$strWhereClause = @$_SESSION[$strTableName."_pdfwhere"];

$_SESSION[$strTableName."_pdfwhere"] = $strWhereClause;


$strOrderBy = $_SESSION[$strTableName."_order"];
if(!$strOrderBy)
	$strOrderBy=$gstrOrderBy;
$strSQL.=" ".trim($strOrderBy);

$strSQLbak = $strSQL;
if($eventObj->exists("BeforeQueryPrint"))
	$eventObj->BeforeQueryPrint($strSQL,$strWhereClause,$strOrderBy, $pageObject);

//	Rebuild SQL if needed

if($strSQL!=$strSQLbak)
{
//	changed $strSQL - old style	
	$numrows=GetRowCount($strSQL);
}
else
{
	$strSQL = $gQuery->gSQLWhere($strWhereClause, $strHavingClause, $strSearchCriteria);
	$strSQL.=" ".trim($strOrderBy);
	
	$rowcount=false;
	if($eventObj->exists("ListGetRowCount"))
	{
		$masterKeysReq=array();
		for($i = 0; $i < count($pageObject->detailKeysByM); $i ++)
			$masterKeysReq[]=$_SESSION[$strTableName."_masterkey".($i + 1)];
			$rowcount=$eventObj->ListGetRowCount($pageObject->searchClauseObj,$_SESSION[$strTableName."_mastertable"],$masterKeysReq,$selected_recs, $pageObject);
	}
	if($rowcount!==false)
		$numrows=$rowcount;
	else
	{
		$numrows = $gQuery->gSQLRowCount($strWhereClause, $strHavingClause, $strSearchCriteria);
	}
}

LogInfo($strSQL);

$mypage=(integer)$_SESSION[$strTableName."_pagenumber"];
if(!$mypage)
	$mypage=1;

//	page size
$PageSize=(integer)$_SESSION[$strTableName."_pagesize"];
if(!$PageSize)
	$PageSize = $pageObject->pSet->getInitialPageSize();

if($PageSize<0)
	$all = 1;	
	
$recno = 1;
$records = 0;	
$maxpages = 1;
$pageindex = 1;
$pageno=1;

// build arrays for sort (to support old code in user-defined events)
if($eventObj->exists("ListQuery"))
{
	$arrFieldForSort = array();
	$arrHowFieldSort = array();
	require_once getabspath('classes/orderclause.php');
	$fieldList = unserialize($_SESSION[$strTableName."_orderFieldsList"]);
	for($i = 0; $i < count($fieldList); $i++)
	{
		$arrFieldForSort[] = $fieldList[$i]->fieldIndex; 
		$arrHowFieldSort[] = $fieldList[$i]->orderDirection; 
	}
}

if(!$all)
{	
	if($numrows)
	{
		$maxRecords = $numrows;
		$maxpages = ceil($maxRecords/$PageSize);
					
		if($mypage > $maxpages)
			$mypage = $maxpages;
		
		if($mypage < 1) 
			$mypage = 1;
		
		$maxrecs = $PageSize;
	}
	$listarray = false;
	if($eventObj->exists("ListQuery"))
		$listarray = $eventObj->ListQuery($pageObject->searchClauseObj, $arrFieldForSort, $arrHowFieldSort, 
			$_SESSION[$strTableName."_mastertable"], $masterKeysReq, $selected_recs, $PageSize, $mypage, $pageObject);
	if($listarray!==false)
		$rs = $listarray;
	else
	{
			if($numrows)
		{
			$strSQL.=" limit ".(($mypage-1)*$PageSize).",".$PageSize;
		}
		$rs = db_query($strSQL,$conn);
	}
	
	//	hide colunm headers if needed
	$recordsonpage = $numrows-($mypage-1)*$PageSize;
	if($recordsonpage>$PageSize)
		$recordsonpage = $PageSize;
		
	$xt->assign("page_number",true);
	$xt->assign("maxpages",$maxpages);
	$xt->assign("pageno",$mypage);
}
else
{
	$listarray = false;
	if($eventObj->exists("ListQuery"))
		$listarray=$eventObj->ListQuery($pageObject->searchClauseObj, $arrFieldForSort, $arrHowFieldSort,
			$_SESSION[$strTableName."_mastertable"], $masterKeysReq, $selected_recs, $PageSize, $mypage, $pageObject);
	if($listarray!==false)
		$rs = $listarray;
	else
		$rs = db_query($strSQL,$conn);
	$recordsonpage = $numrows;
	$maxpages = ceil($recordsonpage/30);
	$xt->assign("page_number",true);
	$xt->assign("maxpages",$maxpages);
}


$fieldsArr = array();
$arr = array();
$arr['fName'] = "nome";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("nome");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "etnia";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("etnia");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "sexo";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("sexo");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "nascimento";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("nascimento");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "cpf";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("cpf");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "email";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("email");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "tel_residencial";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("tel_residencial");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "tel_cel_com";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("tel_cel_com");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "operadora";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("operadora");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "faculdade";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("faculdade");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "campus";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("campus");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "curso";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("curso");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "turno";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("turno");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "bolsa";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("bolsa");
$fieldsArr[] = $arr;
$pageObject->setGoogleMapsParams($fieldsArr);

$colsonpage=1;
if($colsonpage>$recordsonpage)
	$colsonpage=$recordsonpage;
if($colsonpage<1)
	$colsonpage=1;


//	fill $rowinfo array
	$pages = array();
	$rowinfo = array();
	$rowinfo["data"] = array();
	if($eventObj->exists("ListFetchArray"))
		$data = $eventObj->ListFetchArray($rs, $pageObject);
	else
		$data = $cipherer->DecryptFetchedArray($rs);

	while($data)
	{
		if($eventObj->exists("BeforeProcessRowPrint"))
		{
			if(!$eventObj->BeforeProcessRowPrint($data, $pageObject))
			{
				if($eventObj->exists("ListFetchArray"))
					$data = $eventObj->ListFetchArray($rs, $pageObject);
				else
					$data = $cipherer->DecryptFetchedArray($rs);
				continue;
			}
		}
		break;
	}
	
	while($data && ($all || $recno<=$PageSize))
	{
		$row = array();
		$row["grid_record"] = array();
		$row["grid_record"]["data"] = array();
		for($col=1;$data && ($all || $recno<=$PageSize) && $col<=1;$col++)
		{
			$record = array();
			$recno++;
			$records++;
			$keylink="";
			$keylink.="&key1=".htmlspecialchars(rawurlencode(@$data["cpf"]));
			$keylink.="&key2=".htmlspecialchars(rawurlencode(@$data["email"]));

//	nome - 
			$record["nome_value"] = $pageObject->showDBValue("nome", $data, $keylink);
			$record["nome_class"] = $pageObject->fieldClass("nome");
//	etnia - 
			$record["etnia_value"] = $pageObject->showDBValue("etnia", $data, $keylink);
			$record["etnia_class"] = $pageObject->fieldClass("etnia");
//	sexo - 
			$record["sexo_value"] = $pageObject->showDBValue("sexo", $data, $keylink);
			$record["sexo_class"] = $pageObject->fieldClass("sexo");
//	nascimento - Short Date
			$record["nascimento_value"] = $pageObject->showDBValue("nascimento", $data, $keylink);
			$record["nascimento_class"] = $pageObject->fieldClass("nascimento");
//	cpf - 
			$record["cpf_value"] = $pageObject->showDBValue("cpf", $data, $keylink);
			$record["cpf_class"] = $pageObject->fieldClass("cpf");
//	email - 
			$record["email_value"] = $pageObject->showDBValue("email", $data, $keylink);
			$record["email_class"] = $pageObject->fieldClass("email");
//	tel_residencial - 
			$record["tel_residencial_value"] = $pageObject->showDBValue("tel_residencial", $data, $keylink);
			$record["tel_residencial_class"] = $pageObject->fieldClass("tel_residencial");
//	tel_cel_com - 
			$record["tel_cel_com_value"] = $pageObject->showDBValue("tel_cel_com", $data, $keylink);
			$record["tel_cel_com_class"] = $pageObject->fieldClass("tel_cel_com");
//	operadora - 
			$record["operadora_value"] = $pageObject->showDBValue("operadora", $data, $keylink);
			$record["operadora_class"] = $pageObject->fieldClass("operadora");
//	faculdade - 
			$record["faculdade_value"] = $pageObject->showDBValue("faculdade", $data, $keylink);
			$record["faculdade_class"] = $pageObject->fieldClass("faculdade");
//	campus - 
			$record["campus_value"] = $pageObject->showDBValue("campus", $data, $keylink);
			$record["campus_class"] = $pageObject->fieldClass("campus");
//	curso - 
			$record["curso_value"] = $pageObject->showDBValue("curso", $data, $keylink);
			$record["curso_class"] = $pageObject->fieldClass("curso");
//	turno - 
			$record["turno_value"] = $pageObject->showDBValue("turno", $data, $keylink);
			$record["turno_class"] = $pageObject->fieldClass("turno");
//	bolsa - 
			$record["bolsa_value"] = $pageObject->showDBValue("bolsa", $data, $keylink);
			$record["bolsa_class"] = $pageObject->fieldClass("bolsa");
			if($col<$colsonpage)
				$record["endrecord_block"] = true;
			$record["grid_recordheader"] = true;
			$record["grid_vrecord"] = true;
			
			if($eventObj->exists("BeforeMoveNextPrint"))
				$eventObj->BeforeMoveNextPrint($data,$row,$record, $pageObject);
				
			$row["grid_record"]["data"][] = $record;
			
			if($eventObj->exists("ListFetchArray"))
				$data = $eventObj->ListFetchArray($rs, $pageObject);
			else
				$data = $cipherer->DecryptFetchedArray($rs);
				
			while($data)
			{
				if($eventObj->exists("BeforeProcessRowPrint"))
				{
					if(!$eventObj->BeforeProcessRowPrint($data, $pageObject))
					{
						if($eventObj->exists("ListFetchArray"))
							$data = $eventObj->ListFetchArray($rs, $pageObject);
						else
							$data = $cipherer->DecryptFetchedArray($rs);
						continue;
					}
				}
				break;
			}
		}
		if($col <= $colsonpage)
		{
			$row["grid_record"]["data"][count($row["grid_record"]["data"])-1]["endrecord_block"] = false;
		}
		$row["grid_rowspace"]=true;
		$row["grid_recordspace"] = array("data"=>array());
		for($i=0;$i<$colsonpage*2-1;$i++)
			$row["grid_recordspace"]["data"][]=true;
		
		$rowinfo["data"][]=$row;
		
		if($all && $records>=30)
		{
			$page=array("grid_row" =>$rowinfo);
			$page["pageno"]=$pageindex;
			$pageindex++;
			$pages[] = $page;
			$records=0;
			$rowinfo=array();
		}
		
	}
	if(count($rowinfo))
	{
		$page=array("grid_row" =>$rowinfo);
		if($all)
			$page["pageno"]=$pageindex;
		$pages[] = $page;
	}
	
	for($i=0;$i<count($pages);$i++)
	{
	 	if($i<count($pages)-1)
			$pages[$i]["begin"]="<div name=page class=printpage>";
		else
		    $pages[$i]["begin"]="<div name=page>";
			
		$pages[$i]["end"]="</div>";
	}

	$page = array();
	$page["data"] = &$pages;
	$xt->assignbyref("page",$page);

	

$strSQL = $_SESSION[$strTableName."_sql"];

$isPdfView = false;
$hasEvents = false;
if ($pageObject->pSet->isUsebuttonHandlers() || $isPdfView || $hasEvents)
{
	$pageObject->body["begin"] .="<script type=\"text/javascript\" src=\"include/loadfirst.js\"></script>\r\n";
		$pageObject->body["begin"] .= "<script type=\"text/javascript\" src=\"include/lang/".getLangFileName(mlang_getcurrentlang()).".js\"></script>";
	
	$pageObject->fillSetCntrlMaps();
	$pageObject->body['end'] .= '<script>';
	$pageObject->body['end'] .= "window.controlsMap = ".my_json_encode($pageObject->controlsHTMLMap).";";
	$pageObject->body['end'] .= "window.viewControlsMap = ".my_json_encode($pageObject->viewControlsHTMLMap).";";
	$pageObject->body['end'] .= "window.settings = ".my_json_encode($pageObject->jsSettings).";";
	$pageObject->body['end'] .= '</script>';
		$pageObject->body["end"] .= "<script language=\"JavaScript\" src=\"include/runnerJS/RunnerAll.js\"></script>\r\n";
	$pageObject->addCommonJs();
}


if ($pageObject->pSet->isUsebuttonHandlers() || $isPdfView || $hasEvents)
	$pageObject->body["end"] .= "<script>".$pageObject->PrepareJS()."</script>";

$xt->assignbyref("body",$pageObject->body);
$xt->assign("grid_block",true);

$xt->assign("nome_fieldheadercolumn",true);
$xt->assign("nome_fieldheader",true);
$xt->assign("nome_fieldcolumn",true);
$xt->assign("nome_fieldfootercolumn",true);
$xt->assign("etnia_fieldheadercolumn",true);
$xt->assign("etnia_fieldheader",true);
$xt->assign("etnia_fieldcolumn",true);
$xt->assign("etnia_fieldfootercolumn",true);
$xt->assign("sexo_fieldheadercolumn",true);
$xt->assign("sexo_fieldheader",true);
$xt->assign("sexo_fieldcolumn",true);
$xt->assign("sexo_fieldfootercolumn",true);
$xt->assign("nascimento_fieldheadercolumn",true);
$xt->assign("nascimento_fieldheader",true);
$xt->assign("nascimento_fieldcolumn",true);
$xt->assign("nascimento_fieldfootercolumn",true);
$xt->assign("cpf_fieldheadercolumn",true);
$xt->assign("cpf_fieldheader",true);
$xt->assign("cpf_fieldcolumn",true);
$xt->assign("cpf_fieldfootercolumn",true);
$xt->assign("email_fieldheadercolumn",true);
$xt->assign("email_fieldheader",true);
$xt->assign("email_fieldcolumn",true);
$xt->assign("email_fieldfootercolumn",true);
$xt->assign("tel_residencial_fieldheadercolumn",true);
$xt->assign("tel_residencial_fieldheader",true);
$xt->assign("tel_residencial_fieldcolumn",true);
$xt->assign("tel_residencial_fieldfootercolumn",true);
$xt->assign("tel_cel_com_fieldheadercolumn",true);
$xt->assign("tel_cel_com_fieldheader",true);
$xt->assign("tel_cel_com_fieldcolumn",true);
$xt->assign("tel_cel_com_fieldfootercolumn",true);
$xt->assign("operadora_fieldheadercolumn",true);
$xt->assign("operadora_fieldheader",true);
$xt->assign("operadora_fieldcolumn",true);
$xt->assign("operadora_fieldfootercolumn",true);
$xt->assign("faculdade_fieldheadercolumn",true);
$xt->assign("faculdade_fieldheader",true);
$xt->assign("faculdade_fieldcolumn",true);
$xt->assign("faculdade_fieldfootercolumn",true);
$xt->assign("campus_fieldheadercolumn",true);
$xt->assign("campus_fieldheader",true);
$xt->assign("campus_fieldcolumn",true);
$xt->assign("campus_fieldfootercolumn",true);
$xt->assign("curso_fieldheadercolumn",true);
$xt->assign("curso_fieldheader",true);
$xt->assign("curso_fieldcolumn",true);
$xt->assign("curso_fieldfootercolumn",true);
$xt->assign("turno_fieldheadercolumn",true);
$xt->assign("turno_fieldheader",true);
$xt->assign("turno_fieldcolumn",true);
$xt->assign("turno_fieldfootercolumn",true);
$xt->assign("bolsa_fieldheadercolumn",true);
$xt->assign("bolsa_fieldheader",true);
$xt->assign("bolsa_fieldcolumn",true);
$xt->assign("bolsa_fieldfootercolumn",true);

	$record_header=array("data"=>array());
	$record_footer=array("data"=>array());
	for($i=0;$i<$colsonpage;$i++)
	{
		$rheader=array();
		$rfooter=array();
		if($i<$colsonpage-1)
		{
			$rheader["endrecordheader_block"]=true;
			$rfooter["endrecordheader_block"]=true;
		}
		$record_header["data"][]=$rheader;
		$record_footer["data"][]=$rfooter;
	}
	$xt->assignbyref("record_header",$record_header);
	$xt->assignbyref("record_footer",$record_footer);
	$xt->assign("grid_header",true);
	$xt->assign("grid_footer",true);

if($eventObj->exists("BeforeShowPrint"))
	$eventObj->BeforeShowPrint($xt,$pageObject->templatefile, $pageObject);

if(!postvalue("pdf"))
	$xt->display($pageObject->templatefile);
else
{
	$xt->load_template($pageObject->templatefile);
	$page = $xt->fetch_loaded();
	$pagewidth=postvalue("width")*1.05;
	$pageheight=postvalue("height")*1.05;
	$landscape=false;
		if($pagewidth>$pageheight)
		{
			$landscape=true;
			if($pagewidth/$pageheight<297/210)
				$pagewidth = 297/210*$pageheight;
		}
		else
		{
			if($pagewidth/$pageheight<210/297)
				$pagewidth = 210/297*$pageheight;
		}
}
?>
