<?php 
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

include("include/dbcommon.php");
include("include/senuc_nucleo_regional_variables.php");
include('include/xtempl.php');
include('classes/editpage.php');
include("classes/searchclause.php");

add_nocache_headers();

global $globalEvents;

//	check if logged in
if(!isLogged() || CheckPermissionsEvent($strTableName, 'E') && !CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Edit"))
{ 
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	header("Location: login.php?message=expired");
	return;
}

$layout = new TLayout("edit2","BreezeAqua1","MobileAqua1");
$layout->blocks["top"] = array();
$layout->containers["edit"] = array();

$layout->containers["edit"][] = array("name"=>"editheader","block"=>"","substyle"=>2);


$layout->containers["edit"][] = array("name"=>"message","block"=>"message_block","substyle"=>1);


$layout->containers["edit"][] = array("name"=>"wrapper","block"=>"","substyle"=>1, "container"=>"fields");


$layout->containers["fields"] = array();

$layout->containers["fields"][] = array("name"=>"editfields","block"=>"","substyle"=>1);


$layout->containers["fields"][] = array("name"=>"legend","block"=>"legend","substyle"=>3);


$layout->containers["fields"][] = array("name"=>"editbuttons","block"=>"","substyle"=>2);


$layout->skins["fields"] = "fields";

$layout->skins["edit"] = "1";
$layout->blocks["top"][] = "edit";
$layout->skins["details"] = "empty";
$layout->blocks["top"][] = "details";$page_layouts["senuc_nucleo_regional_edit"] = $layout;


$layout = new TLayout("tab","BreezeAqua1","MobileAqua1");
$layout->blocks["bare"] = array();
$layout->containers["1"] = array();

$layout->containers["1"][] = array("name"=>"addtabfield","block"=>"","substyle"=>1);


$layout->skins["1"] = "fields";
$layout->blocks["bare"][] = "1";$page_layouts["senuc_nucleo_regional_edit_Informa__es_Gerais1"] = $layout;

$layout = new TLayout("tab","BreezeAqua1","MobileAqua1");
$layout->blocks["bare"] = array();
$layout->containers["1"] = array();

$layout->containers["1"][] = array("name"=>"addtabfield","block"=>"","substyle"=>1);


$layout->skins["1"] = "fields";
$layout->blocks["bare"][] = "1";$page_layouts["senuc_nucleo_regional_edit_Informa__es_de_Contato1"] = $layout;

$layout = new TLayout("tab","BreezeAqua1","MobileAqua1");
$layout->blocks["bare"] = array();
$layout->containers["1"] = array();

$layout->containers["1"][] = array("name"=>"addtabfield","block"=>"","substyle"=>1);


$layout->skins["1"] = "fields";
$layout->blocks["bare"][] = "1";$page_layouts["senuc_nucleo_regional_edit_Configura__es1"] = $layout;



if ((sizeof($_POST)==0) && (postvalue('ferror')) && (!postvalue("editid1"))){
	$returnJSON['success'] = false;
	$returnJSON['message'] = "Ocorreu um erro!";
	$returnJSON['fatalError'] = true;
	echo "<textarea>".htmlspecialchars(my_json_encode($returnJSON))."</textarea>";
	exit();
}
else if ((sizeof($_POST)==0) && (postvalue('ferror')) && (postvalue("editid1"))){
	if (postvalue('fly')){
		echo -1;
		exit();
	}
	else {
		$_SESSION["message_edit"] = "<< "."Ocorreu um erro!"." >>";
	}
}
/////////////////////////////////////////////////////////////
//init variables
/////////////////////////////////////////////////////////////
if(postvalue("editType")=="inline")
	$inlineedit = EDIT_INLINE;
elseif(postvalue("editType")==EDIT_POPUP)
	$inlineedit = EDIT_POPUP;
else
	$inlineedit = EDIT_SIMPLE;

$id = postvalue("id");
if(intval($id)==0)
	$id = 1;

$flyId = $id+1;
$xt = new Xtempl();

// assign an id
$xt->assign("id",$id);

$templatefile = "senuc_nucleo_regional_edit.htm";

//array of params for classes
$params = array("pageType" => PAGE_EDIT,"id" => $id);


$params['tName'] = $strTableName;
$params['xt'] = &$xt;
$params['mode'] = $inlineedit;
$params['includes_js'] = $includes_js;
$params['includes_jsreq'] = $includes_jsreq;
$params['includes_css'] = $includes_css;
$params['locale_info'] = $locale_info;
$params['templatefile'] = $templatefile;
$params['pageEditLikeInline'] = ($inlineedit == EDIT_INLINE);
//Get array of tabs for edit page
$params['useTabsOnEdit'] = $gSettings->useTabsOnEdit();
if($params['useTabsOnEdit'])
	$params['arrEditTabs'] = $gSettings->getEditTabs();

$pageObject = new EditPage($params);

//	For ajax request 
if($_REQUEST["action"]!="")
{
	if($pageObject->lockingObj)
	{
		$arrkeys = explode("&",refine($_REQUEST["keys"]));
		foreach($arrkeys as $ind=>$val)
			$arrkeys[$ind]=urldecode($val);
		
		if($_REQUEST["action"]=="unlock")
		{
			$pageObject->lockingObj->UnlockRecord($strTableName,$arrkeys,$_REQUEST["sid"]);
			exit();	
		}
		else if($_REQUEST["action"]=="lockadmin" && (IsAdmin() || $_SESSION["AccessLevel"] == ACCESS_LEVEL_ADMINGROUP))
		{
			$pageObject->lockingObj->UnlockAdmin($strTableName,$arrkeys,$_REQUEST["startEdit"]=="yes");
			if($_REQUEST["startEdit"]=="no")
				echo "unlock";
			else if($_REQUEST["startEdit"]=="yes")
				echo "lock";
			exit();	
		}
		else if($_REQUEST["action"]=="confirm")
		{
			if(!$pageObject->lockingObj->ConfirmLock($strTableName,$arrkeys,$message));
				echo $message;
			exit();	
		}
	}
	else
		exit();
}

$filename = $status = $message = $mesClass = $usermessage = $strWhereClause = $bodyonload = "";
$showValues = $showRawValues = $showFields = $showDetailKeys = $key = $next = $prev = array();
$HaveData = $enableCtrlsForEditing = true;
$error_happened = $readevalues = $IsSaved = false;

$auditObj = GetAuditObject($strTableName);

// SearchClause class stuff
$pageObject->searchClauseObj->parseRequest();
$_SESSION[$strTableName.'_advsearch'] = serialize($pageObject->searchClauseObj);

//Get detail table keys	
$detailKeys = $pageObject->detailKeysByM;


if($pageObject->lockingObj)
{
	$system_attrs = "style='display:none;'";
	$system_message = "";
}

if ($inlineedit!=EDIT_INLINE)
{
	// add button events if exist
	$pageObject->addButtonHandlers();
}

$url_page = substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1,12);

//	Before Process event
if($eventObj->exists("BeforeProcessEdit"))
	$eventObj->BeforeProcessEdit($conn, $pageObject);

$keys = array();
$skeys = "";
$savedKeys = array();
$keys["id"] = urldecode(postvalue("editid1"));
$savedKeys["id"] = urldecode(postvalue("editid1"));
$skeys.= rawurlencode(postvalue("editid1"))."&";

$pageObject->setKeys($keys);

if($skeys!="")
	$skeys = substr($skeys,0,-1);

//For show detail tables on master page edit
if($inlineedit!=EDIT_INLINE)
{
	$dpParams = array();
	if($pageObject->isShowDetailTables && !isMobile())
	{
		$ids = $id;
		$pageObject->jsSettings['tableSettings'][$strTableName]['dpParams'] = array('tableNames'=>$dpParams['strTableNames'], 'ids'=>$dpParams['ids']);
	}
}
/////////////////////////////////////////////////////////////
//	process entered data, read and save
/////////////////////////////////////////////////////////////

// proccess captcha
if ($inlineedit!=EDIT_INLINE)
	if($pageObject->captchaExists())
		$pageObject->doCaptchaCode();

if(@$_POST["a"] == "edited")
{
	$strWhereClause = whereAdd($strWhereClause,KeyWhere($keys));
		//	select only owned records
	$strWhereClause = whereAdd($strWhereClause,SecuritySQL("Edit"));
	$oldValuesRead = false;	
	if($eventObj->exists("AfterEdit") || $eventObj->exists("BeforeEdit") || $auditObj || isTableGeoUpdatable($pageObject->cipherer->pSet)
		|| $globalEvents->exists("IsRecordEditable", $strTableName))
	{
		//	read old values
		$rsold = db_query($gQuery->gSQLWhere($strWhereClause), $conn);
		$dataold = $pageObject->cipherer->DecryptFetchedArray($rsold);
		$oldValuesRead = true;
	}
	if($globalEvents->exists("IsRecordEditable", $strTableName))
	{
		if(!$globalEvents->IsRecordEditable($dataold, true, $strTableName))
			return SecurityRedirect($inlineedit);
	}
	$evalues = $efilename_values = $blobfields = array();
	

//	processing login - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_login = $pageObject->getControl("login", $id);
		$control_login->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing login - end
//	processing nome - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_nome = $pageObject->getControl("nome", $id);
		$control_nome->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing nome - end
//	processing responsavel - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_responsavel = $pageObject->getControl("responsavel", $id);
		$control_responsavel->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing responsavel - end
//	processing endereco - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_endereco = $pageObject->getControl("endereco", $id);
		$control_endereco->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing endereco - end
//	processing cep - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_cep = $pageObject->getControl("cep", $id);
		$control_cep->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing cep - end
//	processing estado - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_estado = $pageObject->getControl("estado", $id);
		$control_estado->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing estado - end
//	processing cidade - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_cidade = $pageObject->getControl("cidade", $id);
		$control_cidade->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing cidade - end
//	processing tipo - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_tipo = $pageObject->getControl("tipo", $id);
		$control_tipo->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing tipo - end
//	processing site - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_site = $pageObject->getControl("site", $id);
		$control_site->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing site - end
//	processing email - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_email = $pageObject->getControl("email", $id);
		$control_email->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing email - end
//	processing telefone - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_telefone = $pageObject->getControl("telefone", $id);
		$control_telefone->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing telefone - end
//	processing celular - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_celular = $pageObject->getControl("celular", $id);
		$control_celular->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing celular - end
//	processing operadora - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_operadora = $pageObject->getControl("operadora", $id);
		$control_operadora->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing operadora - end
//	processing data_inicio - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_data_inicio = $pageObject->getControl("data_inicio", $id);
		$control_data_inicio->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing data_inicio - end
//	processing observacao - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_observacao = $pageObject->getControl("observacao", $id);
		$control_observacao->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing observacao - end
//	processing prepara_para - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_prepara_para = $pageObject->getControl("prepara_para", $id);
		$control_prepara_para->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing prepara_para - end
//	processing funciona_em - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_funciona_em = $pageObject->getControl("funciona_em", $id);
		$control_funciona_em->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing funciona_em - end
//	processing ativo - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_ativo = $pageObject->getControl("ativo", $id);
		$control_ativo->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing ativo - end
//	processing motivo - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_motivo = $pageObject->getControl("motivo", $id);
		$control_motivo->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing motivo - end
//	processing meta_funcionamento - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_meta_funcionamento = $pageObject->getControl("meta_funcionamento", $id);
		$control_meta_funcionamento->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing meta_funcionamento - end
//	processing meta_alunos - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_meta_alunos = $pageObject->getControl("meta_alunos", $id);
		$control_meta_alunos->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing meta_alunos - end
//	processing limite_alunos_por_coordenador - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_limite_alunos_por_coordenador = $pageObject->getControl("limite_alunos_por_coordenador", $id);
		$control_limite_alunos_por_coordenador->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing limite_alunos_por_coordenador - end
//	processing min_presenca_coordenador - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_min_presenca_coordenador = $pageObject->getControl("min_presenca_coordenador", $id);
		$control_min_presenca_coordenador->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing min_presenca_coordenador - end
//	processing min_presenca_professor - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_min_presenca_professor = $pageObject->getControl("min_presenca_professor", $id);
		$control_min_presenca_professor->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing min_presenca_professor - end
//	processing min_presenca_aluno - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_min_presenca_aluno = $pageObject->getControl("min_presenca_aluno", $id);
		$control_min_presenca_aluno->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing min_presenca_aluno - end
//	processing min_atividades - begin
	$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode

	if($condition)
	{
		$control_min_atividades = $pageObject->getControl("min_atividades", $id);
		$control_min_atividades->readWebValue($evalues, $blobfields, $strWhereClause, $oldValuesRead, $efilename_values);

		}
//	processing min_atividades - end

	foreach($efilename_values as $ekey=>$value)
		$evalues[$ekey] = $value;
		
	if($pageObject->lockingObj)
	{
		$lockmessage = "";
		if(!$pageObject->lockingObj->ConfirmLock($strTableName,$savedKeys,$lockmessage))
		{
			$enableCtrlsForEditing = false;
			$system_attrs = "style='display:block;'";
			if($inlineedit == EDIT_INLINE)
			{
				if(IsAdmin() || $_SESSION["AccessLevel"] == ACCESS_LEVEL_ADMINGROUP)
					$lockmessage = $pageObject->lockingObj->GetLockInfo($strTableName,$savedKeys,false,$id);
				
				$returnJSON['success'] = false;
				$returnJSON['message'] = $lockmessage;
				$returnJSON['enableCtrls'] = $enableCtrlsForEditing;
				$returnJSON['confirmTime'] = $pageObject->lockingObj->ConfirmTime;
				echo "<textarea>".htmlspecialchars(my_json_encode($returnJSON))."</textarea>";
				exit();
			}
			else
			{
				if(IsAdmin() || $_SESSION["AccessLevel"] == ACCESS_LEVEL_ADMINGROUP)
					$system_message = $pageObject->lockingObj->GetLockInfo($strTableName,$savedKeys,true,$id);
				else
					$system_message = $lockmessage;
			}
			$status = "DECLINED";
			$readevalues = true;
		}
	}
	
	if($readevalues==false)
	{
	//	do event
		$retval = true;
		if($eventObj->exists("BeforeEdit"))
			$retval=$eventObj->BeforeEdit($evalues,$strWhereClause,$dataold,$keys,$usermessage,(bool)$inlineedit, $pageObject);
	
		if($retval && $pageObject->isCaptchaOk)
		{		
			if($inlineedit!=EDIT_INLINE)
				$_SESSION[$strTableName."_count_captcha"] = $_SESSION[$strTableName."_count_captcha"]+1;
		
			//set updated lat-lng values for all map fileds with 'UpdateLatLng' ticked	
            if(isTableGeoUpdatable($pageObject->cipherer->pSet)) {			
				setUpdatedLatLng($evalues, $pageObject->cipherer->pSet, $dataold);
			}	
			
			if(DoUpdateRecord($strOriginalTableName,$evalues,$blobfields,$strWhereClause,$id,$pageObject, $pageObject->cipherer))
			{
				$IsSaved = true;

			// Give possibility to all edit controls to clean their data				
			//	processing login - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_login->afterSuccessfulSave();
				}
	//	processing login - end
			//	processing nome - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_nome->afterSuccessfulSave();
				}
	//	processing nome - end
			//	processing responsavel - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_responsavel->afterSuccessfulSave();
				}
	//	processing responsavel - end
			//	processing endereco - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_endereco->afterSuccessfulSave();
				}
	//	processing endereco - end
			//	processing cep - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_cep->afterSuccessfulSave();
				}
	//	processing cep - end
			//	processing estado - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_estado->afterSuccessfulSave();
				}
	//	processing estado - end
			//	processing cidade - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_cidade->afterSuccessfulSave();
				}
	//	processing cidade - end
			//	processing tipo - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_tipo->afterSuccessfulSave();
				}
	//	processing tipo - end
			//	processing site - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_site->afterSuccessfulSave();
				}
	//	processing site - end
			//	processing email - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_email->afterSuccessfulSave();
				}
	//	processing email - end
			//	processing telefone - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_telefone->afterSuccessfulSave();
				}
	//	processing telefone - end
			//	processing celular - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_celular->afterSuccessfulSave();
				}
	//	processing celular - end
			//	processing operadora - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_operadora->afterSuccessfulSave();
				}
	//	processing operadora - end
			//	processing data_inicio - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_data_inicio->afterSuccessfulSave();
				}
	//	processing data_inicio - end
			//	processing observacao - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_observacao->afterSuccessfulSave();
				}
	//	processing observacao - end
			//	processing prepara_para - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_prepara_para->afterSuccessfulSave();
				}
	//	processing prepara_para - end
			//	processing funciona_em - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_funciona_em->afterSuccessfulSave();
				}
	//	processing funciona_em - end
			//	processing ativo - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_ativo->afterSuccessfulSave();
				}
	//	processing ativo - end
			//	processing motivo - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_motivo->afterSuccessfulSave();
				}
	//	processing motivo - end
			//	processing meta_funcionamento - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_meta_funcionamento->afterSuccessfulSave();
				}
	//	processing meta_funcionamento - end
			//	processing meta_alunos - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_meta_alunos->afterSuccessfulSave();
				}
	//	processing meta_alunos - end
			//	processing limite_alunos_por_coordenador - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_limite_alunos_por_coordenador->afterSuccessfulSave();
				}
	//	processing limite_alunos_por_coordenador - end
			//	processing min_presenca_coordenador - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_min_presenca_coordenador->afterSuccessfulSave();
				}
	//	processing min_presenca_coordenador - end
			//	processing min_presenca_professor - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_min_presenca_professor->afterSuccessfulSave();
				}
	//	processing min_presenca_professor - end
			//	processing min_presenca_aluno - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_min_presenca_aluno->afterSuccessfulSave();
				}
	//	processing min_presenca_aluno - end
			//	processing min_atividades - begin
							$condition = $inlineedit!=EDIT_INLINE;//(!$inlineedit) edit simple mode
			
				if($condition)
				{
					$control_min_atividades->afterSuccessfulSave();
				}
	//	processing min_atividades - end
				
				//	after edit event
				if($pageObject->lockingObj && $inlineedit == EDIT_INLINE)
					$pageObject->lockingObj->UnlockRecord($strTableName,$savedKeys,"");
				if($auditObj || $eventObj->exists("AfterEdit"))
				{
					foreach($dataold as $idx=>$val)
					{
						if(!array_key_exists($idx,$evalues))
							$evalues[$idx] = $val;
					}
				}

				if($auditObj)
					$auditObj->LogEdit($strTableName,$evalues,$dataold,$keys);
				if($eventObj->exists("AfterEdit"))
					$eventObj->AfterEdit($evalues,KeyWhere($keys),$dataold,$keys,(bool)$inlineedit, $pageObject);
							
				$mesClass = "mes_ok";
			}
			elseif($inlineedit!=EDIT_INLINE)
				$mesClass = "mes_not";	
		}
		else
		{
			$message = $usermessage;
			$readevalues = true;
			$status = "DECLINED";
		}
	}
	if($readevalues)
		$keys = $savedKeys;
}
//else
{
	/////////////////////////
	//Locking recors
	/////////////////////////

	if($pageObject->lockingObj)
	{
		$enableCtrlsForEditing = $pageObject->lockingObj->LockRecord($strTableName,$keys);
		if(!$enableCtrlsForEditing)
		{
			if($inlineedit == EDIT_INLINE)
			{
				if(IsAdmin() || $_SESSION["AccessLevel"] == ACCESS_LEVEL_ADMINGROUP)
					$lockmessage = $pageObject->lockingObj->GetLockInfo($strTableName,$keys,false,$id);
				else
					$lockmessage = $pageObject->lockingObj->LockUser;
				$returnJSON['success'] = false;
				$returnJSON['message'] = $lockmessage;
				$returnJSON['enableCtrls'] = $enableCtrlsForEditing;
				$returnJSON['confirmTime'] = $pageObject->lockingObj->ConfirmTime;
				echo my_json_encode($returnJSON);
				exit();
			}
			
			$system_attrs = "style='display:block;'";
			$system_message = $pageObject->lockingObj->LockUser;
			
			if(IsAdmin() || $_SESSION["AccessLevel"] == ACCESS_LEVEL_ADMINGROUP)
			{
				$rb = $pageObject->lockingObj->GetLockInfo($strTableName,$keys,true,$id);
				if($rb!="")
					$system_message = $rb;
			}
		}
	}
}

if($pageObject->lockingObj && $inlineedit!=EDIT_INLINE)
	$pageObject->body["begin"] .='<div class="runner-locking" '.$system_attrs.'>'.$system_message.'</div>';

if($message)
	$message = "<div class='message ".$mesClass."'>".$message."</div>";

// PRG rule, to avoid POSTDATA resend
if ($IsSaved && no_output_done() && $inlineedit == EDIT_SIMPLE)
{
	// saving message
	$_SESSION["message_edit"] = ($message ? $message : "");
	// key get query
	$keyGetQ = "";
		$keyGetQ.="editid1=".rawurldecode($keys["id"])."&";
	// cut last &
	$keyGetQ = substr($keyGetQ, 0, strlen($keyGetQ)-1);	
	// redirect
	header("Location: senuc_nucleo_regional_".$pageObject->getPageType().".php?".$keyGetQ);
	// turned on output buffering, so we need to stop script
	exit();
}
// for PRG rule, to avoid POSTDATA resend. Saving mess in session
if ($inlineedit == EDIT_SIMPLE && isset($_SESSION["message_edit"]))
{
	$message = $_SESSION["message_edit"];
	unset($_SESSION["message_edit"]);
}


$pageObject->setKeys($keys);
$pageObject->readEditValues = $readevalues;
if($readevalues)
	$pageObject->editValues = $evalues;

//	read current values from the database
$data = $pageObject->getCurrentRecordInternal();
if(!$data)
{
	if($inlineedit == EDIT_SIMPLE)
	{
		header("Location: senuc_nucleo_regional_list.php?a=return");
		exit();
	}
	else
		$data = array();
}

if($globalEvents->exists("IsRecordEditable", $strTableName))
{
	if(!$globalEvents->IsRecordEditable($data, true, $strTableName) && $inlineedit != EDIT_INLINE)
	{
		return SecurityRedirect($inlineedit);
	}
}


//global variable use in BuildEditControl function
//	show readonly fields

if($readevalues)
{
	$data["login"] = $evalues["login"];
	$data["nome"] = $evalues["nome"];
	$data["responsavel"] = $evalues["responsavel"];
	$data["endereco"] = $evalues["endereco"];
	$data["cep"] = $evalues["cep"];
	$data["estado"] = $evalues["estado"];
	$data["cidade"] = $evalues["cidade"];
	$data["tipo"] = $evalues["tipo"];
	$data["site"] = $evalues["site"];
	$data["email"] = $evalues["email"];
	$data["telefone"] = $evalues["telefone"];
	$data["celular"] = $evalues["celular"];
	$data["operadora"] = $evalues["operadora"];
	$data["data_inicio"] = $evalues["data_inicio"];
	$data["observacao"] = $evalues["observacao"];
	$data["prepara_para"] = $evalues["prepara_para"];
	$data["funciona_em"] = $evalues["funciona_em"];
	$data["ativo"] = $evalues["ativo"];
	$data["motivo"] = $evalues["motivo"];
	$data["meta_funcionamento"] = $evalues["meta_funcionamento"];
	$data["meta_alunos"] = $evalues["meta_alunos"];
	$data["limite_alunos_por_coordenador"] = $evalues["limite_alunos_por_coordenador"];
	$data["min_presenca_coordenador"] = $evalues["min_presenca_coordenador"];
	$data["min_presenca_professor"] = $evalues["min_presenca_professor"];
	$data["min_presenca_aluno"] = $evalues["min_presenca_aluno"];
	$data["min_atividades"] = $evalues["min_atividades"];
}

/////////////////////////////////////////////////////////////
//	assign values to $xt class, prepare page for displaying
/////////////////////////////////////////////////////////////
//Basic includes js files
$includes = "";
//javascript code
	
if($inlineedit != EDIT_INLINE)
{
	if($inlineedit == EDIT_SIMPLE)
	{
		$includes.= "<script language=\"JavaScript\" src=\"include/loadfirst.js\"></script>\r\n";
				$includes.="<script type=\"text/javascript\" src=\"include/lang/".getLangFileName(mlang_getcurrentlang()).".js\"></script>";
		
		if (!isMobile())
			$includes.= "<div id=\"search_suggest".$id."\"></div>\r\n";
			
		$pageObject->body["begin"].= $includes;
	}	

	if(!$pageObject->isAppearOnTabs("login"))
		$xt->assign("login_fieldblock",true);
	else
		$xt->assign("login_tabfieldblock",true);
	$xt->assign("login_label",true);
	if(isEnableSection508())
		$xt->assign_section("login_label","<label for=\"".GetInputElementId("login", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("nome"))
		$xt->assign("nome_fieldblock",true);
	else
		$xt->assign("nome_tabfieldblock",true);
	$xt->assign("nome_label",true);
	if(isEnableSection508())
		$xt->assign_section("nome_label","<label for=\"".GetInputElementId("nome", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("responsavel"))
		$xt->assign("responsavel_fieldblock",true);
	else
		$xt->assign("responsavel_tabfieldblock",true);
	$xt->assign("responsavel_label",true);
	if(isEnableSection508())
		$xt->assign_section("responsavel_label","<label for=\"".GetInputElementId("responsavel", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("endereco"))
		$xt->assign("endereco_fieldblock",true);
	else
		$xt->assign("endereco_tabfieldblock",true);
	$xt->assign("endereco_label",true);
	if(isEnableSection508())
		$xt->assign_section("endereco_label","<label for=\"".GetInputElementId("endereco", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("cep"))
		$xt->assign("cep_fieldblock",true);
	else
		$xt->assign("cep_tabfieldblock",true);
	$xt->assign("cep_label",true);
	if(isEnableSection508())
		$xt->assign_section("cep_label","<label for=\"".GetInputElementId("cep", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("estado"))
		$xt->assign("estado_fieldblock",true);
	else
		$xt->assign("estado_tabfieldblock",true);
	$xt->assign("estado_label",true);
	if(isEnableSection508())
		$xt->assign_section("estado_label","<label for=\"".GetInputElementId("estado", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("cidade"))
		$xt->assign("cidade_fieldblock",true);
	else
		$xt->assign("cidade_tabfieldblock",true);
	$xt->assign("cidade_label",true);
	if(isEnableSection508())
		$xt->assign_section("cidade_label","<label for=\"".GetInputElementId("cidade", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("tipo"))
		$xt->assign("tipo_fieldblock",true);
	else
		$xt->assign("tipo_tabfieldblock",true);
	$xt->assign("tipo_label",true);
	if(isEnableSection508())
		$xt->assign_section("tipo_label","<label for=\"".GetInputElementId("tipo", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("site"))
		$xt->assign("site_fieldblock",true);
	else
		$xt->assign("site_tabfieldblock",true);
	$xt->assign("site_label",true);
	if(isEnableSection508())
		$xt->assign_section("site_label","<label for=\"".GetInputElementId("site", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("email"))
		$xt->assign("email_fieldblock",true);
	else
		$xt->assign("email_tabfieldblock",true);
	$xt->assign("email_label",true);
	if(isEnableSection508())
		$xt->assign_section("email_label","<label for=\"".GetInputElementId("email", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("telefone"))
		$xt->assign("telefone_fieldblock",true);
	else
		$xt->assign("telefone_tabfieldblock",true);
	$xt->assign("telefone_label",true);
	if(isEnableSection508())
		$xt->assign_section("telefone_label","<label for=\"".GetInputElementId("telefone", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("celular"))
		$xt->assign("celular_fieldblock",true);
	else
		$xt->assign("celular_tabfieldblock",true);
	$xt->assign("celular_label",true);
	if(isEnableSection508())
		$xt->assign_section("celular_label","<label for=\"".GetInputElementId("celular", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("operadora"))
		$xt->assign("operadora_fieldblock",true);
	else
		$xt->assign("operadora_tabfieldblock",true);
	$xt->assign("operadora_label",true);
	if(isEnableSection508())
		$xt->assign_section("operadora_label","<label for=\"".GetInputElementId("operadora", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("data_inicio"))
		$xt->assign("data_inicio_fieldblock",true);
	else
		$xt->assign("data_inicio_tabfieldblock",true);
	$xt->assign("data_inicio_label",true);
	if(isEnableSection508())
		$xt->assign_section("data_inicio_label","<label for=\"".GetInputElementId("data_inicio", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("observacao"))
		$xt->assign("observacao_fieldblock",true);
	else
		$xt->assign("observacao_tabfieldblock",true);
	$xt->assign("observacao_label",true);
	if(isEnableSection508())
		$xt->assign_section("observacao_label","<label for=\"".GetInputElementId("observacao", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("prepara_para"))
		$xt->assign("prepara_para_fieldblock",true);
	else
		$xt->assign("prepara_para_tabfieldblock",true);
	$xt->assign("prepara_para_label",true);
	if(isEnableSection508())
		$xt->assign_section("prepara_para_label","<label for=\"".GetInputElementId("prepara_para", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("funciona_em"))
		$xt->assign("funciona_em_fieldblock",true);
	else
		$xt->assign("funciona_em_tabfieldblock",true);
	$xt->assign("funciona_em_label",true);
	if(isEnableSection508())
		$xt->assign_section("funciona_em_label","<label for=\"".GetInputElementId("funciona_em", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("ativo"))
		$xt->assign("ativo_fieldblock",true);
	else
		$xt->assign("ativo_tabfieldblock",true);
	$xt->assign("ativo_label",true);
	if(isEnableSection508())
		$xt->assign_section("ativo_label","<label for=\"".GetInputElementId("ativo", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("motivo"))
		$xt->assign("motivo_fieldblock",true);
	else
		$xt->assign("motivo_tabfieldblock",true);
	$xt->assign("motivo_label",true);
	if(isEnableSection508())
		$xt->assign_section("motivo_label","<label for=\"".GetInputElementId("motivo", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("meta_funcionamento"))
		$xt->assign("meta_funcionamento_fieldblock",true);
	else
		$xt->assign("meta_funcionamento_tabfieldblock",true);
	$xt->assign("meta_funcionamento_label",true);
	if(isEnableSection508())
		$xt->assign_section("meta_funcionamento_label","<label for=\"".GetInputElementId("meta_funcionamento", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("meta_alunos"))
		$xt->assign("meta_alunos_fieldblock",true);
	else
		$xt->assign("meta_alunos_tabfieldblock",true);
	$xt->assign("meta_alunos_label",true);
	if(isEnableSection508())
		$xt->assign_section("meta_alunos_label","<label for=\"".GetInputElementId("meta_alunos", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("limite_alunos_por_coordenador"))
		$xt->assign("limite_alunos_por_coordenador_fieldblock",true);
	else
		$xt->assign("limite_alunos_por_coordenador_tabfieldblock",true);
	$xt->assign("limite_alunos_por_coordenador_label",true);
	if(isEnableSection508())
		$xt->assign_section("limite_alunos_por_coordenador_label","<label for=\"".GetInputElementId("limite_alunos_por_coordenador", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("min_presenca_coordenador"))
		$xt->assign("min_presenca_coordenador_fieldblock",true);
	else
		$xt->assign("min_presenca_coordenador_tabfieldblock",true);
	$xt->assign("min_presenca_coordenador_label",true);
	if(isEnableSection508())
		$xt->assign_section("min_presenca_coordenador_label","<label for=\"".GetInputElementId("min_presenca_coordenador", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("min_presenca_professor"))
		$xt->assign("min_presenca_professor_fieldblock",true);
	else
		$xt->assign("min_presenca_professor_tabfieldblock",true);
	$xt->assign("min_presenca_professor_label",true);
	if(isEnableSection508())
		$xt->assign_section("min_presenca_professor_label","<label for=\"".GetInputElementId("min_presenca_professor", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("min_presenca_aluno"))
		$xt->assign("min_presenca_aluno_fieldblock",true);
	else
		$xt->assign("min_presenca_aluno_tabfieldblock",true);
	$xt->assign("min_presenca_aluno_label",true);
	if(isEnableSection508())
		$xt->assign_section("min_presenca_aluno_label","<label for=\"".GetInputElementId("min_presenca_aluno", $id, PAGE_EDIT)."\">","</label>");
		
	if(!$pageObject->isAppearOnTabs("min_atividades"))
		$xt->assign("min_atividades_fieldblock",true);
	else
		$xt->assign("min_atividades_tabfieldblock",true);
	$xt->assign("min_atividades_label",true);
	if(isEnableSection508())
		$xt->assign_section("min_atividades_label","<label for=\"".GetInputElementId("min_atividades", $id, PAGE_EDIT)."\">","</label>");
		

	$xt->assign("show_key1", htmlspecialchars($pageObject->showDBValue("id", $data)));
	//$xt->assign('editForm',true);
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Begin Next Prev button
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////    
	if(!@$_SESSION[$strTableName."_noNextPrev"] && $inlineedit == EDIT_SIMPLE)
	{
		$next = array();
		$prev = array();
		$pageObject->getNextPrevRecordKeys($data,"Edit",$next,$prev);
	}
	$nextlink = $prevlink = "";
	if(count($next))
	{
		$xt->assign("next_button",true);
				$nextlink.= "editid1=".htmlspecialchars(rawurlencode($next[1-1]));
		$xt->assign("nextbutton_attrs","id=\"nextButton".$id."\" align=\"absmiddle\"");
	}
	else 
		$xt->assign("next_button",false);
	if(count($prev))
	{
		$xt->assign("prev_button",true);
				$prevlink.= "editid1=".htmlspecialchars(rawurlencode($prev[1-1]));
		$xt->assign("prevbutton_attrs","id=\"prevButton".$id."\" align=\"absmiddle\"");
	}
	else 
		$xt->assign("prev_button",false);
	$xt->assign("resetbutton_attrs",'id="resetButton'.$id.'"');
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//End Next Prev button
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////    
	if($inlineedit == EDIT_SIMPLE)
	{
		$xt->assign("back_button",true);
		$xt->assign("backbutton_attrs","id=\"backButton".$id."\"");
	}
	// onmouseover event, for changing focus. Needed to proper submit form
	//$onmouseover = "this.focus();";
	//$onmouseover = 'onmouseover="'.$onmouseover.'"';
	
	$xt->assign("save_button",true);
	if(!$enableCtrlsForEditing)
		$xt->assign("savebutton_attrs", "id=\"saveButton".$id."\" type=\"disabled\" ");
	else
		$xt->assign("savebutton_attrs", "id=\"saveButton".$id."\"");
		
	$xt->assign("reset_button",true);

}

$xt->assign("message_block",true);
$xt->assign("message",$message);
if(!strlen($message))
{
	$xt->displayBrickHidden("message");
}
/////////////////////////////////////////////////////////////
//process readonly and auto-update fields
/////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////
//	return new data to the List page or report an error
/////////////////////////////////////////////////////////////
if (postvalue("a")=="edited" && ($inlineedit == EDIT_INLINE || $inlineedit == EDIT_POPUP))
{
	if(!$data)
	{
		$data = $evalues;
		$HaveData = false;
	}
	//Preparation   view values

//	detail tables

	$keylink = "";
	$keylink.= "&key1=".htmlspecialchars(rawurlencode(@$data["id"]));


//	id - 
	$value = $pageObject->showDBValue("id", $data, $keylink);
	$showValues["id"] = $value;
	$showFields[] = "id";
		$showRawValues["id"] = substr($data["id"],0,100);

//	idregional - 
	$value = $pageObject->showDBValue("idregional", $data, $keylink);
	$showValues["idregional"] = $value;
	$showFields[] = "idregional";
		$showRawValues["idregional"] = substr($data["idregional"],0,100);

//	login - 
	$value = $pageObject->showDBValue("login", $data, $keylink);
	$showValues["login"] = $value;
	$showFields[] = "login";
		$showRawValues["login"] = substr($data["login"],0,100);

//	senha - 
	$value = $pageObject->showDBValue("senha", $data, $keylink);
	$showValues["senha"] = $value;
	$showFields[] = "senha";
		$showRawValues["senha"] = substr($data["senha"],0,100);

//	nome - 
	$value = $pageObject->showDBValue("nome", $data, $keylink);
	$showValues["nome"] = $value;
	$showFields[] = "nome";
		$showRawValues["nome"] = substr($data["nome"],0,100);

//	responsavel - 
	$value = $pageObject->showDBValue("responsavel", $data, $keylink);
	$showValues["responsavel"] = $value;
	$showFields[] = "responsavel";
		$showRawValues["responsavel"] = substr($data["responsavel"],0,100);

//	endereco - 
	$value = $pageObject->showDBValue("endereco", $data, $keylink);
	$showValues["endereco"] = $value;
	$showFields[] = "endereco";
		$showRawValues["endereco"] = substr($data["endereco"],0,100);

//	cep - 
	$value = $pageObject->showDBValue("cep", $data, $keylink);
	$showValues["cep"] = $value;
	$showFields[] = "cep";
		$showRawValues["cep"] = substr($data["cep"],0,100);

//	estado - 
	$value = $pageObject->showDBValue("estado", $data, $keylink);
	$showValues["estado"] = $value;
	$showFields[] = "estado";
		$showRawValues["estado"] = substr($data["estado"],0,100);

//	cidade - 
	$value = $pageObject->showDBValue("cidade", $data, $keylink);
	$showValues["cidade"] = $value;
	$showFields[] = "cidade";
		$showRawValues["cidade"] = substr($data["cidade"],0,100);

//	tipo - 
	$value = $pageObject->showDBValue("tipo", $data, $keylink);
	$showValues["tipo"] = $value;
	$showFields[] = "tipo";
		$showRawValues["tipo"] = substr($data["tipo"],0,100);

//	site - 
	$value = $pageObject->showDBValue("site", $data, $keylink);
	$showValues["site"] = $value;
	$showFields[] = "site";
		$showRawValues["site"] = substr($data["site"],0,100);

//	email - 
	$value = $pageObject->showDBValue("email", $data, $keylink);
	$showValues["email"] = $value;
	$showFields[] = "email";
		$showRawValues["email"] = substr($data["email"],0,100);

//	telefone - 
	$value = $pageObject->showDBValue("telefone", $data, $keylink);
	$showValues["telefone"] = $value;
	$showFields[] = "telefone";
		$showRawValues["telefone"] = substr($data["telefone"],0,100);

//	celular - 
	$value = $pageObject->showDBValue("celular", $data, $keylink);
	$showValues["celular"] = $value;
	$showFields[] = "celular";
		$showRawValues["celular"] = substr($data["celular"],0,100);

//	operadora - 
	$value = $pageObject->showDBValue("operadora", $data, $keylink);
	$showValues["operadora"] = $value;
	$showFields[] = "operadora";
		$showRawValues["operadora"] = substr($data["operadora"],0,100);

//	data_inicio - Short Date
	$value = $pageObject->showDBValue("data_inicio", $data, $keylink);
	$showValues["data_inicio"] = $value;
	$showFields[] = "data_inicio";
		$showRawValues["data_inicio"] = substr($data["data_inicio"],0,100);

//	observacao - 
	$value = $pageObject->showDBValue("observacao", $data, $keylink);
	$showValues["observacao"] = $value;
	$showFields[] = "observacao";
		$showRawValues["observacao"] = substr($data["observacao"],0,100);

//	prepara_para - 
	$value = $pageObject->showDBValue("prepara_para", $data, $keylink);
	$showValues["prepara_para"] = $value;
	$showFields[] = "prepara_para";
		$showRawValues["prepara_para"] = substr($data["prepara_para"],0,100);

//	funciona_em - 
	$value = $pageObject->showDBValue("funciona_em", $data, $keylink);
	$showValues["funciona_em"] = $value;
	$showFields[] = "funciona_em";
		$showRawValues["funciona_em"] = substr($data["funciona_em"],0,100);

//	ativo - Checkbox
	$value = $pageObject->showDBValue("ativo", $data, $keylink);
	$showValues["ativo"] = $value;
	$showFields[] = "ativo";
		$showRawValues["ativo"] = substr($data["ativo"],0,100);

//	motivo - 
	$value = $pageObject->showDBValue("motivo", $data, $keylink);
	$showValues["motivo"] = $value;
	$showFields[] = "motivo";
		$showRawValues["motivo"] = substr($data["motivo"],0,100);

//	id_mdl - 
	$value = $pageObject->showDBValue("id_mdl", $data, $keylink);
	$showValues["id_mdl"] = $value;
	$showFields[] = "id_mdl";
		$showRawValues["id_mdl"] = substr($data["id_mdl"],0,100);

//	meta_funcionamento - 
	$value = $pageObject->showDBValue("meta_funcionamento", $data, $keylink);
	$showValues["meta_funcionamento"] = $value;
	$showFields[] = "meta_funcionamento";
		$showRawValues["meta_funcionamento"] = substr($data["meta_funcionamento"],0,100);

//	meta_alunos - 
	$value = $pageObject->showDBValue("meta_alunos", $data, $keylink);
	$showValues["meta_alunos"] = $value;
	$showFields[] = "meta_alunos";
		$showRawValues["meta_alunos"] = substr($data["meta_alunos"],0,100);

//	limite_alunos_por_coordenador - 
	$value = $pageObject->showDBValue("limite_alunos_por_coordenador", $data, $keylink);
	$showValues["limite_alunos_por_coordenador"] = $value;
	$showFields[] = "limite_alunos_por_coordenador";
		$showRawValues["limite_alunos_por_coordenador"] = substr($data["limite_alunos_por_coordenador"],0,100);

//	min_presenca_coordenador - 
	$value = $pageObject->showDBValue("min_presenca_coordenador", $data, $keylink);
	$showValues["min_presenca_coordenador"] = $value;
	$showFields[] = "min_presenca_coordenador";
		$showRawValues["min_presenca_coordenador"] = substr($data["min_presenca_coordenador"],0,100);

//	min_presenca_professor - 
	$value = $pageObject->showDBValue("min_presenca_professor", $data, $keylink);
	$showValues["min_presenca_professor"] = $value;
	$showFields[] = "min_presenca_professor";
		$showRawValues["min_presenca_professor"] = substr($data["min_presenca_professor"],0,100);

//	min_presenca_aluno - 
	$value = $pageObject->showDBValue("min_presenca_aluno", $data, $keylink);
	$showValues["min_presenca_aluno"] = $value;
	$showFields[] = "min_presenca_aluno";
		$showRawValues["min_presenca_aluno"] = substr($data["min_presenca_aluno"],0,100);

//	min_atividades - 
	$value = $pageObject->showDBValue("min_atividades", $data, $keylink);
	$showValues["min_atividades"] = $value;
	$showFields[] = "min_atividades";
		$showRawValues["min_atividades"] = substr($data["min_atividades"],0,100);

//	data_ultimo_score - Short Date
	$value = $pageObject->showDBValue("data_ultimo_score", $data, $keylink);
	$showValues["data_ultimo_score"] = $value;
	$showFields[] = "data_ultimo_score";
		$showRawValues["data_ultimo_score"] = substr($data["data_ultimo_score"],0,100);

//	ultimo_score - 
	$value = $pageObject->showDBValue("ultimo_score", $data, $keylink);
	$showValues["ultimo_score"] = $value;
	$showFields[] = "ultimo_score";
		$showRawValues["ultimo_score"] = substr($data["ultimo_score"],0,100);
/////////////////////////////////////////////////////////////
//	start inline output
/////////////////////////////////////////////////////////////
	
	if($IsSaved)
	{
		if($pageObject->lockingObj)
			$pageObject->lockingObj->UnlockRecord($strTableName,$keys,"");
		
		$returnJSON['success'] = true;
		$returnJSON['keys'] = $pageObject->jsKeys;
		$returnJSON['keyFields'] = $pageObject->keyFields;
		$returnJSON['vals'] = $showValues;
		$returnJSON['fields'] = $showFields;
		$returnJSON['rawVals'] = $showRawValues;
		$returnJSON['detKeys'] = $showDetailKeys;
		$returnJSON['userMess'] = $usermessage;
		$returnJSON['hrefs'] = $pageObject->buildDetailGridLinks($showDetailKeys);
		
		if($inlineedit==EDIT_POPUP && isset($_SESSION[$strTableName."_count_captcha"]) || $_SESSION[$strTableName."_count_captcha"]>0 || $_SESSION[$strTableName."_count_captcha"]<5)
			$returnJSON['hideCaptcha'] = true;
			
		if($globalEvents->exists("IsRecordEditable", $strTableName))
		{
			if(!$globalEvents->IsRecordEditable($showRawValues, true, $strTableName))
				$returnJSON['nonEditable'] = true;
		}
	}
	else
	{
		$returnJSON['success'] = false;
		$returnJSON['message'] = $message;
		
		if($pageObject->lockingObj)
			$returnJSON['lockMessage'] = $system_message;
		
		if($inlineedit == EDIT_POPUP && !$pageObject->isCaptchaOk)
			$returnJSON['captcha'] = false;
	}
	echo "<textarea>".htmlspecialchars(my_json_encode($returnJSON))."</textarea>";
	exit();
} 
/////////////////////////////////////////////////////////////
//	prepare Edit Controls
/////////////////////////////////////////////////////////////
//	validation stuff
$regex = '';
$regexmessage = '';
$regextype = '';
$control = array();

foreach($pageObject->editFields as $fName)
{
	$gfName = GoodFieldName($fName);
	$controls = array('controls'=>array());
	if (!$detailKeys || !in_array($fName, $detailKeys))
	{
		$control[$gfName] = array();
		$control[$gfName]["func"]="xt_buildeditcontrol";
		$control[$gfName]["params"] = array();
		$control[$gfName]["params"]["id"] = $id;
		$control[$gfName]["params"]["ptype"] = PAGE_EDIT;
		$control[$gfName]["params"]["field"] = $fName;
		if(!IsNumberType($pageObject->pSet->getFieldType($fName)) || is_null(@$data[$fName]))
			$control[$gfName]["params"]["value"] = @$data[$fName];
		else
		{
			$control[$gfName]["params"]["value"] = str_replace(".",$locale_info["LOCALE_SDECIMAL"],@$data[$fName]);
		}
		$control[$gfName]["params"]["pageObj"] = $pageObject;
		
		//	Begin Add validation
		$arrValidate = $pageObject->pSet->getValidation($fName);
		$control[$gfName]["params"]["validate"] = $arrValidate;
		//	End Add validation	
		$additionalCtrlParams = array();
		$additionalCtrlParams["disabled"] = !$enableCtrlsForEditing;
		$control[$gfName]["params"]["additionalCtrlParams"] = $additionalCtrlParams;
	}
	$controls["controls"]['ctrlInd'] = 0;
	$controls["controls"]['id'] = $id;
	$controls["controls"]['fieldName'] = $fName;
	
	if($inlineedit == EDIT_INLINE)
	{
		if(!$detailKeys || !in_array($fName, $detailKeys))
			$control[$gfName]["params"]["mode"]="inline_edit";
		$controls["controls"]['mode'] = "inline_edit";
	}
	else{
			if (!$detailKeys || !in_array($fName, $detailKeys))
				$control[$gfName]["params"]["mode"] = "edit";
			$controls["controls"]['mode'] = "edit";
		}
																											
	if(!$detailKeys || !in_array($fName, $detailKeys))
		$xt->assignbyref($gfName."_editcontrol",$control[$gfName]);
	elseif($detailKeys && in_array($fName, $detailKeys))
		$controls["controls"]['value'] = @$data[$fName];
		
	// category control field
	$strCategoryControl = $pageObject->isDependOnField($fName);
	
	if($strCategoryControl!==false && in_array($strCategoryControl, $pageObject->editFields))
		$vals = array($fName => @$data[$fName],$strCategoryControl => @$data[$strCategoryControl]);
	else
		$vals = array($fName => @$data[$fName]);
		
	$preload = $pageObject->fillPreload($fName, $vals);
	if($preload!==false)
		$controls["controls"]['preloadData'] = $preload;
	
	$pageObject->fillControlsMap($controls);
	
	//fill field tool tips
	$pageObject->fillFieldToolTips($fName);
	
	// fill special settings for timepicker
	if($pageObject->pSet->getEditFormat($fName) == 'Time')	
		$pageObject->fillTimePickSettings($fName, $data[$fName]);
	
	if($pageObject->pSet->getViewFormat($fName) == FORMAT_MAP)	
		$pageObject->googleMapCfg['isUseGoogleMap'] = true;
		
	if($detailKeys && in_array($fName, $detailKeys) && array_key_exists($fName, $data))
	{
		$value = $pageObject->showDBValue($fName, $data);
		
		$xt->assign($gfName."_editcontrol",$value);
	}
}
//fill tab groups name and sections name to controls
$pageObject->fillCntrlTabGroups();

$pageObject->jsSettings['tableSettings'][$strTableName]["keys"] = $pageObject->jsKeys;
$pageObject->jsSettings['tableSettings'][$strTableName]['keyFields'] = $pageObject->keyFields;
$pageObject->jsSettings['tableSettings'][$strTableName]["prevKeys"] = $prev;
$pageObject->jsSettings['tableSettings'][$strTableName]["nextKeys"] = $next; 
if($pageObject->lockingObj)
{
	$pageObject->jsSettings['tableSettings'][$strTableName]["sKeys"] = $skeys;
	$pageObject->jsSettings['tableSettings'][$strTableName]["enableCtrls"] = $enableCtrlsForEditing;
	$pageObject->jsSettings['tableSettings'][$strTableName]["confirmTime"] = $pageObject->lockingObj->ConfirmTime;
}

/////////////////////////////////////////////////////////////
if($pageObject->isShowDetailTables && $inlineedit!=EDIT_INLINE && !isMobile())
{
	if(count($dpParams['ids']))
	{
		include('classes/listpage.php');
		include('classes/listpage_embed.php');
		include('classes/listpage_dpinline.php');
		$xt->assign("detail_tables",true);	
	}
	
	$dControlsMap = array();
	$dViewControlsMap = array();
	$flyId = $ids+1;
	
	for($d=0;$d<count($dpParams['ids']);$d++)
	{
		$options = array();
		//array of params for classes
		$options["mode"] = LIST_DETAILS;
		$options["pageType"] = PAGE_LIST;
		$options["masterPageType"] = PAGE_EDIT;
		$options["mainMasterPageType"] = PAGE_EDIT;
		$options['masterTable'] = "senuc_nucleo_regional";
		$options['firstTime'] = 1;
		
		$strTableName = $dpParams['strTableNames'][$d];
		
		if(!CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Search")){
			$strTableName = "senuc_nucleo_regional";
			continue;
		}
		
		include_once("include/".GetTableURL($strTableName)."_settings.php");
		
		$layout = GetPageLayout(GoodFieldName($strTableName), PAGE_LIST);
		if($layout)
		{
			$rtl = $xt->getReadingOrder() == 'RTL' ? 'RTL' : '';
			$xt->cssFiles[] = array("stylepath" => "styles/".$layout->style.'/style'.$rtl.".css"
				, "pagestylepath" => "pagestyles/".$layout->name.$rtl.".css");
			$xt->IEcssFiles[] = array("stylepathIE" => "styles/".$layout->style.'/styleIE'.".css");
		}	
		
		$options['xt'] = new Xtempl();
		$options['id'] = $dpParams['ids'][$d];
		$options['flyId'] = $flyId++;
		$masterKeys = array();
		$mkr = 1;
		
		foreach($mKeys[$strTableName] as $mk){
			$options['masterKeysReq'][$mkr] = $data[$mk];
			$masterKeys['masterKey'.$mkr] = $data[$mk];
			$mkr++;
		}
		
		$listPageObject = ListPage::createListPage($strTableName, $options);
		
		// prepare code
		$listPageObject->prepareForBuildPage();
		
		// show page
		if($listPageObject->isDispGrid())
		{
			//set page events
			foreach($listPageObject->eventsObject->events as $event => $name)
				$listPageObject->xt->assign_event($event, $listPageObject->eventsObject, $event, array());
			
			//add detail settings to master settings
			$listPageObject->addControlsJSAndCSS();
			$listPageObject->fillSetCntrlMaps();
			
			$pageObject->jsSettings['tableSettings'][$strTableName]	= $listPageObject->jsSettings['tableSettings'][$strTableName];
			
			foreach($listPageObject->jsSettings["global"]["shortTNames"] as $tName => $shortTName){
				$pageObject->settingsMap["globalSettings"]["shortTNames"][$tName] = $shortTName;
			}
			
			$dControlsMap[$strTableName] = $listPageObject->controlsMap;
			$dControlsMap[$strTableName]['masterKeys'] = $masterKeys;
			$dViewControlsMap[$strTableName] = $listPageObject->viewControlsMap;
			
			//Add detail's js files to master's files
			$pageObject->copyAllJSFiles($listPageObject->grabAllJSFiles());
			
			//Add detail's css files to master's files
			$pageObject->copyAllCSSFiles($listPageObject->grabAllCSSFiles());
			
			$xtParams = array("method"=>'showPage', "params"=> false);
			$xtParams['object'] = $listPageObject;
			$xt->assign("displayDetailTable_".GoodFieldName($listPageObject->tName), $xtParams);
			
			$pageObject->controlsMap['dpTablesParams'][] = array('tName'=>$strTableName, 'id'=>$options['id']);
		}
		$flyId = $listPageObject->recId+1;
	}
	$pageObject->controlsMap['dControlsMap'] = $dControlsMap;
	$pageObject->viewControlsMap['dViewControlsMap'] = $dViewControlsMap; 
	$strTableName = "senuc_nucleo_regional";
}
/////////////////////////////////////////////////////////////
//fill jsSettings and ControlsHTMLMap
$pageObject->flyId = $flyId;
$pageObject->fillSetCntrlMaps();

$pageObject->addCommonJs();

//For mobile version in apple device

if($inlineedit == EDIT_SIMPLE)
{
	// assign body end
	$pageObject->body['end'] = array();
	$pageObject->body['end']["method"] = "assignBodyEnd";
	$pageObject->body['end']["object"] = &$pageObject;
	$xt->assign("body", $pageObject->body);
	$xt->assign("flybody",true);
}

if($inlineedit == EDIT_POPUP){
	$xt->assign("footer",false);
	$xt->assign("header",false);
	$xt->assign("body",$pageObject->body);
}

$xt->assign("style_block",true);

$pageObject->xt->assign("legend", true);

$viewlink = "";
$viewkeys = array();
	$viewkeys["editid1"] = postvalue("editid1");
foreach($viewkeys as $key => $val)
{
	if($viewlink)
		$viewlink.="&";
	$viewlink.=$key."=".$val;
}
$xt->assign("viewlink_attrs","id=\"viewButton".$id."\" name=\"viewButton".$id."\" onclick=\"window.location.href='senuc_nucleo_regional_view.php?".$viewlink."'\"");
if(CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Search") && $inlineedit == EDIT_SIMPLE)
	$xt->assign("view_button",true);
else
	$xt->assign("view_button",false);

/////////////////////////////////////////////////////////////
//display the page
/////////////////////////////////////////////////////////////
if($eventObj->exists("BeforeShowEdit"))
	$eventObj->BeforeShowEdit($xt,$templatefile,$data, $pageObject);

if($inlineedit != EDIT_SIMPLE)
{
	$returnJSON['controlsMap'] = $pageObject->controlsHTMLMap;
	$returnJSON['viewControlsMap'] = $pageObject->viewControlsHTMLMap;
	$returnJSON['settings'] = $pageObject->jsSettings;	
}
	
if($inlineedit == EDIT_POPUP || $inlineedit == EDIT_INLINE)
{
	if($globalEvents->exists("IsRecordEditable", $strTableName))
	{
		if(!$globalEvents->IsRecordEditable($data, true, $strTableName))
			return SecurityRedirect($inlineedit);
	}
}
if($inlineedit == EDIT_POPUP)
{
	$xt->load_template($templatefile);
	$returnJSON['html'] = $xt->fetch_loaded('style_block').$xt->fetch_loaded('body');
	if(count($pageObject->includes_css))
		$returnJSON['CSSFiles'] = array_unique($pageObject->includes_css);
	if(count($pageObject->includes_cssIE))
		$returnJSON['CSSFilesIE'] = array_unique($pageObject->includes_cssIE);
	$returnJSON["additionalJS"] = $pageObject->grabAllJsFiles();
	$returnJSON['idStartFrom'] = $flyId + 1;
	echo (my_json_encode($returnJSON)); 
}
elseif($inlineedit == EDIT_INLINE)
{
	$xt->load_template($templatefile);
	$returnJSON["html"] = array();
	foreach($pageObject->editFields as $fName)
	{
		if($detailKeys && in_array($fName, $detailKeys))
			continue;
		$returnJSON["html"][$fName] = $xt->fetchVar(GoodFieldName($fName)."_editcontrol");
	}
	$returnJSON["additionalJS"] = $pageObject->grabAllJsFiles();
	$returnJSON["additionalCSS"] = $pageObject->grabAllCSSFiles();
	echo (my_json_encode($returnJSON)); 
}
else
	$xt->display($templatefile);
	
function SecurityRedirect($inlineedit)
{
	if($inlineedit == EDIT_INLINE)
	{
		echo my_json_encode(array("success" => false, "message" => "O registro não é editável"));
		return;
	}
	
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	header("Location: menu.php?message=expired");	
}
?>
