<?php
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");

include("include/dbcommon.php");
include("classes/searchclause.php");

add_nocache_headers();

include("include/senuc_professores_regional_variables.php");

if(!isLogged())
{ 
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	header("Location: login.php?message=expired"); 
	return;
}
if(CheckPermissionsEvent($strTableName, 'P') && !CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Export"))
{
	echo "<p>"."Você não tem permissão para acessar esta tabela"."<a href=\"login.php\">"."Voltar à página de Login"."</a></p>";
	return;
}

$layout = new TLayout("print","BreezeAqua1","MobileAqua1");
$layout->blocks["center"] = array();
$layout->containers["grid"] = array();

$layout->containers["grid"][] = array("name"=>"printgrid","block"=>"grid_block","substyle"=>1);


$layout->skins["grid"] = "empty";
$layout->blocks["center"][] = "grid";$layout->blocks["top"] = array();
$layout->skins["master"] = "empty";
$layout->blocks["top"][] = "master";
$layout->skins["pdf"] = "empty";
$layout->blocks["top"][] = "pdf";$page_layouts["senuc_professores_regional_print"] = $layout;


include('include/xtempl.php');
include('classes/runnerpage.php');

$cipherer = new RunnerCipherer($strTableName);

$xt = new Xtempl();
$id = postvalue("id") != "" ? postvalue("id") : 1;
$all = postvalue("all");
$pageName = "print.php";

//array of params for classes
$params = array("id" => $id,
				"tName" => $strTableName,
				"pageType" => PAGE_PRINT);
$params["xt"] = &$xt;
			
$pageObject = new RunnerPage($params);

// add button events if exist
$pageObject->addButtonHandlers();

// Modify query: remove blob fields from fieldlist.
// Blob fields on a print page are shown using imager.php (for example).
// They don't need to be selected from DB in print.php itself.
$noBlobReplace = false;
if(!postvalue("pdf") && !$noBlobReplace)
	$gQuery->ReplaceFieldsWithDummies($pageObject->pSet->getBinaryFieldsIndices());

//	Before Process event
if($eventObj->exists("BeforeProcessPrint"))
	$eventObj->BeforeProcessPrint($conn, $pageObject);

$strWhereClause="";
$strHavingClause="";
$strSearchCriteria="and";

$selected_recs=array();
if (@$_REQUEST["a"]!="") 
{
	$sWhere = "1=0";	
	
//	process selection
	if (@$_REQUEST["mdelete"])
	{
		foreach(@$_REQUEST["mdelete"] as $ind)
		{
			$keys=array();
			$keys["id"]=refine($_REQUEST["mdelete1"][mdeleteIndex($ind)]);
			$selected_recs[]=$keys;
		}
	}
	elseif(@$_REQUEST["selection"])
	{
		foreach(@$_REQUEST["selection"] as $keyblock)
		{
			$arr=explode("&",refine($keyblock));
			if(count($arr)<1)
				continue;
			$keys=array();
			$keys["id"]=urldecode($arr[0]);
			$selected_recs[]=$keys;
		}
	}

	foreach($selected_recs as $keys)
	{
		$sWhere = $sWhere . " or ";
		$sWhere.=KeyWhere($keys);
	}
	$sWhere = whereAdd($sWhere,SecuritySQL("Search"));
	$strSQL = $gQuery->gSQLWhere($sWhere);
	$strWhereClause=$sWhere;
}
else
{
	$strWhereClause=@$_SESSION[$strTableName."_where"];
	$strHavingClause=@$_SESSION[$strTableName."_having"];
	$strSearchCriteria=@$_SESSION[$strTableName."_criteria"];
	if(!$strWhereClause)
		$strWhereClause = whereAdd($strWhereClause,SecuritySQL("Search"));
	$strSQL = $gQuery->gSQLWhere($strWhereClause, $strHavingClause, $strSearchCriteria);
}
if(postvalue("pdf"))
	$strWhereClause = @$_SESSION[$strTableName."_pdfwhere"];

$_SESSION[$strTableName."_pdfwhere"] = $strWhereClause;


$strOrderBy = $_SESSION[$strTableName."_order"];
if(!$strOrderBy)
	$strOrderBy=$gstrOrderBy;
$strSQL.=" ".trim($strOrderBy);

$strSQLbak = $strSQL;
if($eventObj->exists("BeforeQueryPrint"))
	$eventObj->BeforeQueryPrint($strSQL,$strWhereClause,$strOrderBy, $pageObject);

//	Rebuild SQL if needed

if($strSQL!=$strSQLbak)
{
//	changed $strSQL - old style	
	$numrows=GetRowCount($strSQL);
}
else
{
	$strSQL = $gQuery->gSQLWhere($strWhereClause, $strHavingClause, $strSearchCriteria);
	$strSQL.=" ".trim($strOrderBy);
	
	$rowcount=false;
	if($eventObj->exists("ListGetRowCount"))
	{
		$masterKeysReq=array();
		for($i = 0; $i < count($pageObject->detailKeysByM); $i ++)
			$masterKeysReq[]=$_SESSION[$strTableName."_masterkey".($i + 1)];
			$rowcount=$eventObj->ListGetRowCount($pageObject->searchClauseObj,$_SESSION[$strTableName."_mastertable"],$masterKeysReq,$selected_recs, $pageObject);
	}
	if($rowcount!==false)
		$numrows=$rowcount;
	else
	{
		$numrows = $gQuery->gSQLRowCount($strWhereClause, $strHavingClause, $strSearchCriteria);
	}
}

LogInfo($strSQL);

$mypage=(integer)$_SESSION[$strTableName."_pagenumber"];
if(!$mypage)
	$mypage=1;

//	page size
$PageSize=(integer)$_SESSION[$strTableName."_pagesize"];
if(!$PageSize)
	$PageSize = $pageObject->pSet->getInitialPageSize();

if($PageSize<0)
	$all = 1;	
	
$recno = 1;
$records = 0;	
$maxpages = 1;
$pageindex = 1;
$pageno=1;

// build arrays for sort (to support old code in user-defined events)
if($eventObj->exists("ListQuery"))
{
	$arrFieldForSort = array();
	$arrHowFieldSort = array();
	require_once getabspath('classes/orderclause.php');
	$fieldList = unserialize($_SESSION[$strTableName."_orderFieldsList"]);
	for($i = 0; $i < count($fieldList); $i++)
	{
		$arrFieldForSort[] = $fieldList[$i]->fieldIndex; 
		$arrHowFieldSort[] = $fieldList[$i]->orderDirection; 
	}
}

if(!$all)
{	
	if($numrows)
	{
		$maxRecords = $numrows;
		$maxpages = ceil($maxRecords/$PageSize);
					
		if($mypage > $maxpages)
			$mypage = $maxpages;
		
		if($mypage < 1) 
			$mypage = 1;
		
		$maxrecs = $PageSize;
	}
	$listarray = false;
	if($eventObj->exists("ListQuery"))
		$listarray = $eventObj->ListQuery($pageObject->searchClauseObj, $arrFieldForSort, $arrHowFieldSort, 
			$_SESSION[$strTableName."_mastertable"], $masterKeysReq, $selected_recs, $PageSize, $mypage, $pageObject);
	if($listarray!==false)
		$rs = $listarray;
	else
	{
			if($numrows)
		{
			$strSQL.=" limit ".(($mypage-1)*$PageSize).",".$PageSize;
		}
		$rs = db_query($strSQL,$conn);
	}
	
	//	hide colunm headers if needed
	$recordsonpage = $numrows-($mypage-1)*$PageSize;
	if($recordsonpage>$PageSize)
		$recordsonpage = $PageSize;
		
	$xt->assign("page_number",true);
	$xt->assign("maxpages",$maxpages);
	$xt->assign("pageno",$mypage);
}
else
{
	$listarray = false;
	if($eventObj->exists("ListQuery"))
		$listarray=$eventObj->ListQuery($pageObject->searchClauseObj, $arrFieldForSort, $arrHowFieldSort,
			$_SESSION[$strTableName."_mastertable"], $masterKeysReq, $selected_recs, $PageSize, $mypage, $pageObject);
	if($listarray!==false)
		$rs = $listarray;
	else
		$rs = db_query($strSQL,$conn);
	$recordsonpage = $numrows;
	$maxpages = ceil($recordsonpage/30);
	$xt->assign("page_number",true);
	$xt->assign("maxpages",$maxpages);
}


$fieldsArr = array();
$arr = array();
$arr['fName'] = "nome";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("nome");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "email";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("email");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "cpf";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("cpf");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "telefone";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("telefone");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "celular";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("celular");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "operadora";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("operadora");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "nascimento";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("nascimento");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "etnia";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("etnia");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "renda";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("renda");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "estado";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("estado");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "cidade";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("cidade");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "escolaridade";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("escolaridade");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "curso";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("curso");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "materias";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("materias");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "ingresso_nucleo";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("ingresso_nucleo");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "bolsista";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("bolsista");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "motivo";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("motivo");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "ativo";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("ativo");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "nome_nucleo";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("nome_nucleo");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "nome_regional";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("nome_regional");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "ultimo_score";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("ultimo_score");
$fieldsArr[] = $arr;
$arr = array();
$arr['fName'] = "data_ultimo_score";
$arr['viewFormat'] = $pageObject->pSet->getViewFormat("data_ultimo_score");
$fieldsArr[] = $arr;
$pageObject->setGoogleMapsParams($fieldsArr);

$colsonpage=1;
if($colsonpage>$recordsonpage)
	$colsonpage=$recordsonpage;
if($colsonpage<1)
	$colsonpage=1;


//	fill $rowinfo array
	$pages = array();
	$rowinfo = array();
	$rowinfo["data"] = array();
	if($eventObj->exists("ListFetchArray"))
		$data = $eventObj->ListFetchArray($rs, $pageObject);
	else
		$data = $cipherer->DecryptFetchedArray($rs);

	while($data)
	{
		if($eventObj->exists("BeforeProcessRowPrint"))
		{
			if(!$eventObj->BeforeProcessRowPrint($data, $pageObject))
			{
				if($eventObj->exists("ListFetchArray"))
					$data = $eventObj->ListFetchArray($rs, $pageObject);
				else
					$data = $cipherer->DecryptFetchedArray($rs);
				continue;
			}
		}
		break;
	}
	
	while($data && ($all || $recno<=$PageSize))
	{
		$row = array();
		$row["grid_record"] = array();
		$row["grid_record"]["data"] = array();
		for($col=1;$data && ($all || $recno<=$PageSize) && $col<=1;$col++)
		{
			$record = array();
			$recno++;
			$records++;
			$keylink="";
			$keylink.="&key1=".htmlspecialchars(rawurlencode(@$data["id"]));

//	ultimo_score - 
			$record["ultimo_score_value"] = $pageObject->showDBValue("ultimo_score", $data, $keylink);
			$record["ultimo_score_class"] = $pageObject->fieldClass("ultimo_score");
//	nome_regional - 
			$record["nome_regional_value"] = $pageObject->showDBValue("nome_regional", $data, $keylink);
			$record["nome_regional_class"] = $pageObject->fieldClass("nome_regional");
//	nome_nucleo - 
			$record["nome_nucleo_value"] = $pageObject->showDBValue("nome_nucleo", $data, $keylink);
			$record["nome_nucleo_class"] = $pageObject->fieldClass("nome_nucleo");
//	data_ultimo_score - Short Date
			$record["data_ultimo_score_value"] = $pageObject->showDBValue("data_ultimo_score", $data, $keylink);
			$record["data_ultimo_score_class"] = $pageObject->fieldClass("data_ultimo_score");
//	nome - 
			$record["nome_value"] = $pageObject->showDBValue("nome", $data, $keylink);
			$record["nome_class"] = $pageObject->fieldClass("nome");
//	cpf - 
			$record["cpf_value"] = $pageObject->showDBValue("cpf", $data, $keylink);
			$record["cpf_class"] = $pageObject->fieldClass("cpf");
//	estado - 
			$record["estado_value"] = $pageObject->showDBValue("estado", $data, $keylink);
			$record["estado_class"] = $pageObject->fieldClass("estado");
//	cidade - 
			$record["cidade_value"] = $pageObject->showDBValue("cidade", $data, $keylink);
			$record["cidade_class"] = $pageObject->fieldClass("cidade");
//	email - 
			$record["email_value"] = $pageObject->showDBValue("email", $data, $keylink);
			$record["email_class"] = $pageObject->fieldClass("email");
//	telefone - 
			$record["telefone_value"] = $pageObject->showDBValue("telefone", $data, $keylink);
			$record["telefone_class"] = $pageObject->fieldClass("telefone");
//	celular - 
			$record["celular_value"] = $pageObject->showDBValue("celular", $data, $keylink);
			$record["celular_class"] = $pageObject->fieldClass("celular");
//	operadora - 
			$record["operadora_value"] = $pageObject->showDBValue("operadora", $data, $keylink);
			$record["operadora_class"] = $pageObject->fieldClass("operadora");
//	nascimento - Short Date
			$record["nascimento_value"] = $pageObject->showDBValue("nascimento", $data, $keylink);
			$record["nascimento_class"] = $pageObject->fieldClass("nascimento");
//	renda - 
			$record["renda_value"] = $pageObject->showDBValue("renda", $data, $keylink);
			$record["renda_class"] = $pageObject->fieldClass("renda");
//	etnia - 
			$record["etnia_value"] = $pageObject->showDBValue("etnia", $data, $keylink);
			$record["etnia_class"] = $pageObject->fieldClass("etnia");
//	escolaridade - 
			$record["escolaridade_value"] = $pageObject->showDBValue("escolaridade", $data, $keylink);
			$record["escolaridade_class"] = $pageObject->fieldClass("escolaridade");
//	curso - 
			$record["curso_value"] = $pageObject->showDBValue("curso", $data, $keylink);
			$record["curso_class"] = $pageObject->fieldClass("curso");
//	materias - 
			$record["materias_value"] = $pageObject->showDBValue("materias", $data, $keylink);
			$record["materias_class"] = $pageObject->fieldClass("materias");
//	ingresso_nucleo - Short Date
			$record["ingresso_nucleo_value"] = $pageObject->showDBValue("ingresso_nucleo", $data, $keylink);
			$record["ingresso_nucleo_class"] = $pageObject->fieldClass("ingresso_nucleo");
//	bolsista - Checkbox
			$record["bolsista_value"] = $pageObject->showDBValue("bolsista", $data, $keylink);
			$record["bolsista_class"] = $pageObject->fieldClass("bolsista");
//	ativo - Checkbox
			$record["ativo_value"] = $pageObject->showDBValue("ativo", $data, $keylink);
			$record["ativo_class"] = $pageObject->fieldClass("ativo");
//	motivo - Custom
			$record["motivo_value"] = $pageObject->showDBValue("motivo", $data, $keylink);
			$record["motivo_class"] = $pageObject->fieldClass("motivo");
			if($col<$colsonpage)
				$record["endrecord_block"] = true;
			$record["grid_recordheader"] = true;
			$record["grid_vrecord"] = true;
			
			if($eventObj->exists("BeforeMoveNextPrint"))
				$eventObj->BeforeMoveNextPrint($data,$row,$record, $pageObject);
				
			$row["grid_record"]["data"][] = $record;
			
			if($eventObj->exists("ListFetchArray"))
				$data = $eventObj->ListFetchArray($rs, $pageObject);
			else
				$data = $cipherer->DecryptFetchedArray($rs);
				
			while($data)
			{
				if($eventObj->exists("BeforeProcessRowPrint"))
				{
					if(!$eventObj->BeforeProcessRowPrint($data, $pageObject))
					{
						if($eventObj->exists("ListFetchArray"))
							$data = $eventObj->ListFetchArray($rs, $pageObject);
						else
							$data = $cipherer->DecryptFetchedArray($rs);
						continue;
					}
				}
				break;
			}
		}
		if($col <= $colsonpage)
		{
			$row["grid_record"]["data"][count($row["grid_record"]["data"])-1]["endrecord_block"] = false;
		}
		$row["grid_rowspace"]=true;
		$row["grid_recordspace"] = array("data"=>array());
		for($i=0;$i<$colsonpage*2-1;$i++)
			$row["grid_recordspace"]["data"][]=true;
		
		$rowinfo["data"][]=$row;
		
		if($all && $records>=30)
		{
			$page=array("grid_row" =>$rowinfo);
			$page["pageno"]=$pageindex;
			$pageindex++;
			$pages[] = $page;
			$records=0;
			$rowinfo=array();
		}
		
	}
	if(count($rowinfo))
	{
		$page=array("grid_row" =>$rowinfo);
		if($all)
			$page["pageno"]=$pageindex;
		$pages[] = $page;
	}
	
	for($i=0;$i<count($pages);$i++)
	{
	 	if($i<count($pages)-1)
			$pages[$i]["begin"]="<div name=page class=printpage>";
		else
		    $pages[$i]["begin"]="<div name=page>";
			
		$pages[$i]["end"]="</div>";
	}

	$page = array();
	$page["data"] = &$pages;
	$xt->assignbyref("page",$page);

	

$strSQL = $_SESSION[$strTableName."_sql"];

$isPdfView = false;
$hasEvents = true;
if ($pageObject->pSet->isUsebuttonHandlers() || $isPdfView || $hasEvents)
{
	$pageObject->body["begin"] .="<script type=\"text/javascript\" src=\"include/loadfirst.js\"></script>\r\n";
		$pageObject->body["begin"] .= "<script type=\"text/javascript\" src=\"include/lang/".getLangFileName(mlang_getcurrentlang()).".js\"></script>";
	
	$pageObject->fillSetCntrlMaps();
	$pageObject->body['end'] .= '<script>';
	$pageObject->body['end'] .= "window.controlsMap = ".my_json_encode($pageObject->controlsHTMLMap).";";
	$pageObject->body['end'] .= "window.viewControlsMap = ".my_json_encode($pageObject->viewControlsHTMLMap).";";
	$pageObject->body['end'] .= "window.settings = ".my_json_encode($pageObject->jsSettings).";";
	$pageObject->body['end'] .= '</script>';
		$pageObject->body["end"] .= "<script language=\"JavaScript\" src=\"include/runnerJS/RunnerAll.js\"></script>\r\n";
	$pageObject->addCommonJs();
}


if ($pageObject->pSet->isUsebuttonHandlers() || $isPdfView || $hasEvents)
	$pageObject->body["end"] .= "<script>".$pageObject->PrepareJS()."</script>";

$xt->assignbyref("body",$pageObject->body);
$xt->assign("grid_block",true);

$xt->assign("ultimo_score_fieldheadercolumn",true);
$xt->assign("ultimo_score_fieldheader",true);
$xt->assign("ultimo_score_fieldcolumn",true);
$xt->assign("ultimo_score_fieldfootercolumn",true);
$xt->assign("nome_regional_fieldheadercolumn",true);
$xt->assign("nome_regional_fieldheader",true);
$xt->assign("nome_regional_fieldcolumn",true);
$xt->assign("nome_regional_fieldfootercolumn",true);
$xt->assign("nome_nucleo_fieldheadercolumn",true);
$xt->assign("nome_nucleo_fieldheader",true);
$xt->assign("nome_nucleo_fieldcolumn",true);
$xt->assign("nome_nucleo_fieldfootercolumn",true);
$xt->assign("data_ultimo_score_fieldheadercolumn",true);
$xt->assign("data_ultimo_score_fieldheader",true);
$xt->assign("data_ultimo_score_fieldcolumn",true);
$xt->assign("data_ultimo_score_fieldfootercolumn",true);
$xt->assign("nome_fieldheadercolumn",true);
$xt->assign("nome_fieldheader",true);
$xt->assign("nome_fieldcolumn",true);
$xt->assign("nome_fieldfootercolumn",true);
$xt->assign("cpf_fieldheadercolumn",true);
$xt->assign("cpf_fieldheader",true);
$xt->assign("cpf_fieldcolumn",true);
$xt->assign("cpf_fieldfootercolumn",true);
$xt->assign("estado_fieldheadercolumn",true);
$xt->assign("estado_fieldheader",true);
$xt->assign("estado_fieldcolumn",true);
$xt->assign("estado_fieldfootercolumn",true);
$xt->assign("cidade_fieldheadercolumn",true);
$xt->assign("cidade_fieldheader",true);
$xt->assign("cidade_fieldcolumn",true);
$xt->assign("cidade_fieldfootercolumn",true);
$xt->assign("email_fieldheadercolumn",true);
$xt->assign("email_fieldheader",true);
$xt->assign("email_fieldcolumn",true);
$xt->assign("email_fieldfootercolumn",true);
$xt->assign("telefone_fieldheadercolumn",true);
$xt->assign("telefone_fieldheader",true);
$xt->assign("telefone_fieldcolumn",true);
$xt->assign("telefone_fieldfootercolumn",true);
$xt->assign("celular_fieldheadercolumn",true);
$xt->assign("celular_fieldheader",true);
$xt->assign("celular_fieldcolumn",true);
$xt->assign("celular_fieldfootercolumn",true);
$xt->assign("operadora_fieldheadercolumn",true);
$xt->assign("operadora_fieldheader",true);
$xt->assign("operadora_fieldcolumn",true);
$xt->assign("operadora_fieldfootercolumn",true);
$xt->assign("nascimento_fieldheadercolumn",true);
$xt->assign("nascimento_fieldheader",true);
$xt->assign("nascimento_fieldcolumn",true);
$xt->assign("nascimento_fieldfootercolumn",true);
$xt->assign("renda_fieldheadercolumn",true);
$xt->assign("renda_fieldheader",true);
$xt->assign("renda_fieldcolumn",true);
$xt->assign("renda_fieldfootercolumn",true);
$xt->assign("etnia_fieldheadercolumn",true);
$xt->assign("etnia_fieldheader",true);
$xt->assign("etnia_fieldcolumn",true);
$xt->assign("etnia_fieldfootercolumn",true);
$xt->assign("escolaridade_fieldheadercolumn",true);
$xt->assign("escolaridade_fieldheader",true);
$xt->assign("escolaridade_fieldcolumn",true);
$xt->assign("escolaridade_fieldfootercolumn",true);
$xt->assign("curso_fieldheadercolumn",true);
$xt->assign("curso_fieldheader",true);
$xt->assign("curso_fieldcolumn",true);
$xt->assign("curso_fieldfootercolumn",true);
$xt->assign("materias_fieldheadercolumn",true);
$xt->assign("materias_fieldheader",true);
$xt->assign("materias_fieldcolumn",true);
$xt->assign("materias_fieldfootercolumn",true);
$xt->assign("ingresso_nucleo_fieldheadercolumn",true);
$xt->assign("ingresso_nucleo_fieldheader",true);
$xt->assign("ingresso_nucleo_fieldcolumn",true);
$xt->assign("ingresso_nucleo_fieldfootercolumn",true);
$xt->assign("bolsista_fieldheadercolumn",true);
$xt->assign("bolsista_fieldheader",true);
$xt->assign("bolsista_fieldcolumn",true);
$xt->assign("bolsista_fieldfootercolumn",true);
$xt->assign("ativo_fieldheadercolumn",true);
$xt->assign("ativo_fieldheader",true);
$xt->assign("ativo_fieldcolumn",true);
$xt->assign("ativo_fieldfootercolumn",true);
$xt->assign("motivo_fieldheadercolumn",true);
$xt->assign("motivo_fieldheader",true);
$xt->assign("motivo_fieldcolumn",true);
$xt->assign("motivo_fieldfootercolumn",true);

	$record_header=array("data"=>array());
	$record_footer=array("data"=>array());
	for($i=0;$i<$colsonpage;$i++)
	{
		$rheader=array();
		$rfooter=array();
		if($i<$colsonpage-1)
		{
			$rheader["endrecordheader_block"]=true;
			$rfooter["endrecordheader_block"]=true;
		}
		$record_header["data"][]=$rheader;
		$record_footer["data"][]=$rfooter;
	}
	$xt->assignbyref("record_header",$record_header);
	$xt->assignbyref("record_footer",$record_footer);
	$xt->assign("grid_header",true);
	$xt->assign("grid_footer",true);

if($eventObj->exists("BeforeShowPrint"))
	$eventObj->BeforeShowPrint($xt,$pageObject->templatefile, $pageObject);

if(!postvalue("pdf"))
	$xt->display($pageObject->templatefile);
else
{
	$xt->load_template($pageObject->templatefile);
	$page = $xt->fetch_loaded();
	$pagewidth=postvalue("width")*1.05;
	$pageheight=postvalue("height")*1.05;
	$landscape=false;
		if($pagewidth>$pageheight)
		{
			$landscape=true;
			if($pagewidth/$pageheight<297/210)
				$pagewidth = 297/210*$pageheight;
		}
		else
		{
			if($pagewidth/$pageheight<210/297)
				$pagewidth = 210/297*$pageheight;
		}
}
?>
