<?php 
@ini_set("display_errors","1");
@ini_set("display_startup_errors","1");
include("include/dbcommon.php");
include("classes/searchclause.php");
session_cache_limiter("none");

include("include/senuc_score_variables.php");

if(!isLogged())
{ 
	$_SESSION["MyURL"]=$_SERVER["SCRIPT_NAME"]."?".$_SERVER["QUERY_STRING"];
	header("Location: login.php?message=expired"); 
	return;
}
if(CheckPermissionsEvent($strTableName, 'P') && !CheckSecurity(@$_SESSION["_".$strTableName."_OwnerID"],"Export"))
{
	echo "<p>"."Você não tem permissão para acessar esta tabela"."<a href=\"login.php\">"."Voltar à página de Login"."</a></p>";
	return;
}

$layout = new TLayout("export","BreezeAqua1","MobileAqua1");
$layout->blocks["top"] = array();
$layout->containers["export"] = array();

$layout->containers["export"][] = array("name"=>"exportheader","block"=>"","substyle"=>2);


$layout->containers["export"][] = array("name"=>"exprange_header","block"=>"rangeheader_block","substyle"=>3);


$layout->containers["export"][] = array("name"=>"exprange","block"=>"range_block","substyle"=>1);


$layout->containers["export"][] = array("name"=>"expoutput_header","block"=>"","substyle"=>3);


$layout->containers["export"][] = array("name"=>"expoutput","block"=>"","substyle"=>1);


$layout->containers["export"][] = array("name"=>"expbuttons","block"=>"","substyle"=>2);


$layout->skins["export"] = "fields";
$layout->blocks["top"][] = "export";$page_layouts["senuc_score_export"] = $layout;


// Modify query: remove blob fields from fieldlist.
// Blob fields on an export page are shown using imager.php (for example).
// They don't need to be selected from DB in export.php itself.
//$gQuery->ReplaceFieldsWithDummies(GetBinaryFieldsIndices());

$cipherer = new RunnerCipherer($strTableName);

$strWhereClause = "";
$strHavingClause = "";
$strSearchCriteria = "and";
$selected_recs = array();
$options = "1";

header("Expires: Thu, 01 Jan 1970 00:00:01 GMT"); 
include('include/xtempl.php');
include('classes/runnerpage.php');
$xt = new Xtempl();
$id = postvalue("id") != "" ? postvalue("id") : 1;

$phpVersion = (int)substr(phpversion(), 0, 1); 
if($phpVersion > 4)
{
	include("include/export_functions.php");
	$xt->assign("groupExcel", true);
}
else
	$xt->assign("excel", true);

//array of params for classes
$params = array("pageType" => PAGE_EXPORT, "id" => $id, "tName" => $strTableName);
$params["xt"] = &$xt;
if(!$eventObj->exists("ListGetRowCount") && !$eventObj->exists("ListQuery"))
	$params["needSearchClauseObj"] = false;
$pageObject = new RunnerPage($params);

//	Before Process event
if($eventObj->exists("BeforeProcessExport"))
	$eventObj->BeforeProcessExport($conn, $pageObject);

if (@$_REQUEST["a"]!="")
{
	$options = "";
	$sWhere = "1=0";	

//	process selection
	$selected_recs = array();
	if (@$_REQUEST["mdelete"])
	{
		foreach(@$_REQUEST["mdelete"] as $ind)
		{
			$keys=array();
			$keys["id"] = refine($_REQUEST["mdelete1"][mdeleteIndex($ind)]);
			$selected_recs[] = $keys;
		}
	}
	elseif(@$_REQUEST["selection"])
	{
		foreach(@$_REQUEST["selection"] as $keyblock)
		{
			$arr=explode("&",refine($keyblock));
			if(count($arr)<1)
				continue;
			$keys = array();
			$keys["id"] = urldecode($arr[0]);
			$selected_recs[] = $keys;
		}
	}

	foreach($selected_recs as $keys)
	{
		$sWhere = $sWhere . " or ";
		$sWhere.=KeyWhere($keys);
	}

	$sWhere = whereAdd($sWhere,SecuritySQL("Search"));

	$strSQL = $gQuery->gSQLWhere($sWhere);
	$strWhereClause=$sWhere;
	
	$_SESSION[$strTableName."_SelectedSQL"] = $strSQL;
	$_SESSION[$strTableName."_SelectedWhere"] = $sWhere;
	$_SESSION[$strTableName."_SelectedRecords"] = $selected_recs;
}

if ($_SESSION[$strTableName."_SelectedSQL"]!="" && @$_REQUEST["records"]=="") 
{
	$strSQL = $_SESSION[$strTableName."_SelectedSQL"];
	$strWhereClause = @$_SESSION[$strTableName."_SelectedWhere"];
	$selected_recs = $_SESSION[$strTableName."_SelectedRecords"];
}
else
{
	$strWhereClause = @$_SESSION[$strTableName."_where"];
	$strHavingClause = @$_SESSION[$strTableName."_having"];
	$strSearchCriteria = @$_SESSION[$strTableName."_criteria"];
	if($strWhereClause == "")
		$strWhereClause = whereAdd($strWhereClause,SecuritySQL("Search"));
	$strSQL = $gQuery->gSQLWhere($strWhereClause, $strHavingClause, $strSearchCriteria);
}

$mypage = 1;
if(@$_REQUEST["type"])
{
//	order by
	$strOrderBy = $_SESSION[$strTableName."_order"];
	if(!$strOrderBy)
		$strOrderBy = $gstrOrderBy;
	$strSQL.=" ".trim($strOrderBy);

	$strSQLbak = $strSQL;
	if($eventObj->exists("BeforeQueryExport"))
		$eventObj->BeforeQueryExport($strSQL,$strWhereClause,$strOrderBy, $pageObject);
//	Rebuild SQL if needed
	if($strSQL!=$strSQLbak)
	{
//	changed $strSQL - old style	
		$numrows=GetRowCount($strSQL);
	}
	else
	{
		$strSQL = $gQuery->gSQLWhere($strWhereClause, $strHavingClause, $strSearchCriteria);
		$strSQL.=" ".trim($strOrderBy);
		$rowcount=false;
		if($eventObj->exists("ListGetRowCount"))
		{
			$masterKeysReq=array();
			for($i = 0; $i < count($pageObject->detailKeysByM); $i ++)
				$masterKeysReq[] = $_SESSION[$strTableName."_masterkey".($i + 1)];
			$rowcount = $eventObj->ListGetRowCount($pageObject->searchClauseObj,$_SESSION[$strTableName."_mastertable"],$masterKeysReq,$selected_recs, $pageObject);
		}
		if($rowcount !== false)
			$numrows = $rowcount;
		else
			$numrows = $gQuery->gSQLRowCount($strWhereClause,$strHavingClause,$strSearchCriteria);
	}
	LogInfo($strSQL);

//	 Pagination:

	$nPageSize = 0;
	if(@$_REQUEST["records"]=="page" && $numrows)
	{
		$mypage = (integer)@$_SESSION[$strTableName."_pagenumber"];
		$nPageSize = (integer)@$_SESSION[$strTableName."_pagesize"];
		
		if(!$nPageSize)
			$nPageSize = $gSettings->getInitialPageSize();
				
		if($nPageSize<0)
			$nPageSize = 0;
			
		if($nPageSize>0)
		{
			if($numrows<=($mypage-1)*$nPageSize)
				$mypage = ceil($numrows/$nPageSize);
		
			if(!$mypage)
				$mypage = 1;
			
					$strSQL.=" limit ".(($mypage-1)*$nPageSize).",".$nPageSize;
		}
	}
	$listarray = false;
	if($eventObj->exists("ListQuery"))
	{
		$arrFieldForSort = array();
		$arrHowFieldSort = array();
		require_once getabspath('classes/orderclause.php');
		$fieldList = unserialize($_SESSION[$strTableName."_orderFieldsList"]);
		for($i = 0; $i < count($fieldList); $i++)
		{
			$arrFieldForSort[] = $fieldList[$i]->fieldIndex; 
			$arrHowFieldSort[] = $fieldList[$i]->orderDirection; 
		}
		$listarray = $eventObj->ListQuery($pageObject->searchClauseObj, $arrFieldForSort, $arrHowFieldSort,
			$_SESSION[$strTableName."_mastertable"], $masterKeysReq, $selected_recs, $nPageSize, $mypage, $pageObject);
	}
	if($listarray!==false)
		$rs = $listarray;
	elseif($nPageSize>0)
	{
					$rs = db_query($strSQL,$conn);
	}
	else
		$rs = db_query($strSQL,$conn);

	if(!ini_get("safe_mode"))
		set_time_limit(300);
	
	if(substr(@$_REQUEST["type"],0,5)=="excel")
	{
//	remove grouping
		$locale_info["LOCALE_SGROUPING"]="0";
		$locale_info["LOCALE_SMONGROUPING"]="0";
				if($phpVersion > 4)
			ExportToExcel($cipherer, $pageObject);
		else
			ExportToExcel_old($cipherer);
	}
	else if(@$_REQUEST["type"]=="word")
	{
		ExportToWord($cipherer);
	}
	else if(@$_REQUEST["type"]=="xml")
	{
		ExportToXML($cipherer);
	}
	else if(@$_REQUEST["type"]=="csv")
	{
		$locale_info["LOCALE_SGROUPING"]="0";
		$locale_info["LOCALE_SDECIMAL"]=".";
		$locale_info["LOCALE_SMONGROUPING"]="0";
		$locale_info["LOCALE_SMONDECIMALSEP"]=".";
		ExportToCSV($cipherer);
	}
	db_close($conn);
	return;
}

// add button events if exist
$pageObject->addButtonHandlers();

if($options)
{
	$xt->assign("rangeheader_block",true);
	$xt->assign("range_block",true);
}

$xt->assign("exportlink_attrs", 'id="saveButton'.$pageObject->id.'"');

$pageObject->body["begin"] .="<script type=\"text/javascript\" src=\"include/loadfirst.js\"></script>\r\n";
$pageObject->body["begin"] .= "<script type=\"text/javascript\" src=\"include/lang/".getLangFileName(mlang_getcurrentlang()).".js\"></script>";

$pageObject->fillSetCntrlMaps();
$pageObject->body['end'] .= '<script>';
$pageObject->body['end'] .= "window.controlsMap = ".my_json_encode($pageObject->controlsHTMLMap).";";
$pageObject->body['end'] .= "window.viewControlsMap = ".my_json_encode($pageObject->viewControlsHTMLMap).";";
$pageObject->body['end'] .= "window.settings = ".my_json_encode($pageObject->jsSettings).";";
$pageObject->body['end'] .= '</script>';
$pageObject->body["end"] .= "<script language=\"JavaScript\" src=\"include/runnerJS/RunnerAll.js\"></script>\r\n";
$pageObject->addCommonJs();

$pageObject->body["end"] .= "<script>".$pageObject->PrepareJS()."</script>";
$xt->assignbyref("body",$pageObject->body);

$xt->display("senuc_score_export.htm");

function ExportToExcel_old($cipherer)
{
	global $cCharset;
	header("Content-Type: application/vnd.ms-excel");
	header("Content-Disposition: attachment;Filename=senuc_score.xls");

	echo "<html>";
	echo "<html xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:x=\"urn:schemas-microsoft-com:office:excel\" xmlns=\"http://www.w3.org/TR/REC-html40\">";
	
	echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=".$cCharset."\">";
	echo "<body>";
	echo "<table border=1>";

	WriteTableData($cipherer);

	echo "</table>";
	echo "</body>";
	echo "</html>";
}

function ExportToWord($cipherer)
{
	global $cCharset;
	header("Content-Type: application/vnd.ms-word");
	header("Content-Disposition: attachment;Filename=senuc_score.doc");

	echo "<html>";
	echo "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=".$cCharset."\">";
	echo "<body>";
	echo "<table border=1>";

	WriteTableData($cipherer);

	echo "</table>";
	echo "</body>";
	echo "</html>";
}

function ExportToXML($cipherer)
{
	global $nPageSize,$rs,$strTableName,$conn,$eventObj, $pageObject;
	header("Content-Type: text/xml");
	header("Content-Disposition: attachment;Filename=senuc_score.xml");
	if($eventObj->exists("ListFetchArray"))
		$row = $eventObj->ListFetchArray($rs, $pageObject);
	else
		$row = $cipherer->DecryptFetchedArray($rs);	
	//if(!$row)
	//	return;
		
	global $cCharset;
	
	echo "<?xml version=\"1.0\" encoding=\"".$cCharset."\" standalone=\"yes\"?>\r\n";
	echo "<table>\r\n";
	$i = 0;
	$pageObject->viewControls->forExport = "xml";
	while((!$nPageSize || $i<$nPageSize) && $row)
	{
		$values = array();
			$values["tipo_nucleo"] = $pageObject->showDBValue("tipo_nucleo", $row);
			$values["ano"] = $pageObject->showDBValue("ano", $row);
			$values["mes"] = $pageObject->showDBValue("mes", $row);
			$values["coordenadores"] = $pageObject->showDBValue("coordenadores", $row);
			$values["professores"] = $pageObject->showDBValue("professores", $row);
			$values["alunos"] = $pageObject->showDBValue("alunos", $row);
			$values["meta_alunos"] = $pageObject->showDBValue("meta_alunos", $row);
			$values["dias_funcionamento"] = $pageObject->showDBValue("dias_funcionamento", $row);
			$values["meta_funcionamento"] = $pageObject->showDBValue("meta_funcionamento", $row);
			$values["alunos_por_coordenador"] = $pageObject->showDBValue("alunos_por_coordenador", $row);
			$values["meta_alunos_por_coordenador"] = $pageObject->showDBValue("meta_alunos_por_coordenador", $row);
			$values["freq_media_coordenador"] = $pageObject->showDBValue("freq_media_coordenador", $row);
			$values["min_freq_coordenador"] = $pageObject->showDBValue("min_freq_coordenador", $row);
			$values["freq_media_aluno"] = $pageObject->showDBValue("freq_media_aluno", $row);
			$values["min_freq_aluno"] = $pageObject->showDBValue("min_freq_aluno", $row);
			$values["freq_media_professor"] = $pageObject->showDBValue("freq_media_professor", $row);
			$values["min_freq_professor"] = $pageObject->showDBValue("min_freq_professor", $row);
			$values["meta_atividades"] = $pageObject->showDBValue("meta_atividades", $row);
			$values["atividades_elaboradas"] = $pageObject->showDBValue("atividades_elaboradas", $row);
			$values["atividades_realizadas"] = $pageObject->showDBValue("atividades_realizadas", $row);
			$values["score"] = $pageObject->showDBValue("score", $row);
			$values["operador"] = $pageObject->showDBValue("operador", $row);
			$values["data_insercao"] = $pageObject->showDBValue("data_insercao", $row);
		
		$eventRes = true;
		if ($eventObj->exists('BeforeOut'))
			$eventRes = $eventObj->BeforeOut($row, $values, $pageObject);
		
		if ($eventRes)
		{
			$i++;
			echo "<row>\r\n";
			foreach ($values as $fName => $val)
			{
				$field = htmlspecialchars(XMLNameEncode($fName));
				echo "<".$field.">";
				echo $values[$fName];
				echo "</".$field.">\r\n";
			}
			echo "</row>\r\n";
		}
		
		
		if($eventObj->exists("ListFetchArray"))
			$row = $eventObj->ListFetchArray($rs, $pageObject);
		else
			$row = $cipherer->DecryptFetchedArray($rs);
	}
	echo "</table>\r\n";
}

function ExportToCSV($cipherer)
{
	global $rs,$nPageSize,$strTableName,$conn,$eventObj, $pageObject;
	header("Content-Type: application/csv");
	header("Content-Disposition: attachment;Filename=senuc_score.csv");
	
	if($eventObj->exists("ListFetchArray"))
		$row = $eventObj->ListFetchArray($rs, $pageObject);
	else
		$row = $cipherer->DecryptFetchedArray($rs);

// write header
	$outstr = "";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"tipo_nucleo\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"ano\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"mes\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"coordenadores\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"professores\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"alunos\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"meta_alunos\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"dias_funcionamento\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"meta_funcionamento\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"alunos_por_coordenador\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"meta_alunos_por_coordenador\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"freq_media_coordenador\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"min_freq_coordenador\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"freq_media_aluno\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"min_freq_aluno\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"freq_media_professor\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"min_freq_professor\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"meta_atividades\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"atividades_elaboradas\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"atividades_realizadas\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"score\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"operador\"";
	if($outstr!="")
		$outstr.=",";
	$outstr.= "\"data_insercao\"";
	echo $outstr;
	echo "\r\n";

// write data rows
	$iNumberOfRows = 0;
	$pageObject->viewControls->forExport = "csv";
	while((!$nPageSize || $iNumberOfRows < $nPageSize) && $row)
	{
		$values = array();
			$values["tipo_nucleo"] = $pageObject->getViewControl("tipo_nucleo")->showDBValue($row, "");
			$values["ano"] = $pageObject->getViewControl("ano")->showDBValue($row, "");
			$values["mes"] = $pageObject->getViewControl("mes")->showDBValue($row, "");
			$values["coordenadores"] = $pageObject->getViewControl("coordenadores")->showDBValue($row, "");
			$values["professores"] = $pageObject->getViewControl("professores")->showDBValue($row, "");
			$values["alunos"] = $pageObject->getViewControl("alunos")->showDBValue($row, "");
			$values["meta_alunos"] = $pageObject->getViewControl("meta_alunos")->showDBValue($row, "");
			$values["dias_funcionamento"] = $pageObject->getViewControl("dias_funcionamento")->showDBValue($row, "");
			$values["meta_funcionamento"] = $pageObject->getViewControl("meta_funcionamento")->showDBValue($row, "");
			$values["alunos_por_coordenador"] = $pageObject->getViewControl("alunos_por_coordenador")->showDBValue($row, "");
			$values["meta_alunos_por_coordenador"] = $pageObject->getViewControl("meta_alunos_por_coordenador")->showDBValue($row, "");
			$values["freq_media_coordenador"] = $pageObject->getViewControl("freq_media_coordenador")->showDBValue($row, "");
			$values["min_freq_coordenador"] = $pageObject->getViewControl("min_freq_coordenador")->showDBValue($row, "");
			$values["freq_media_aluno"] = $pageObject->getViewControl("freq_media_aluno")->showDBValue($row, "");
			$values["min_freq_aluno"] = $pageObject->getViewControl("min_freq_aluno")->showDBValue($row, "");
			$values["freq_media_professor"] = $pageObject->getViewControl("freq_media_professor")->showDBValue($row, "");
			$values["min_freq_professor"] = $pageObject->getViewControl("min_freq_professor")->showDBValue($row, "");
			$values["meta_atividades"] = $pageObject->getViewControl("meta_atividades")->showDBValue($row, "");
			$values["atividades_elaboradas"] = $pageObject->getViewControl("atividades_elaboradas")->showDBValue($row, "");
			$values["atividades_realizadas"] = $pageObject->getViewControl("atividades_realizadas")->showDBValue($row, "");
			$values["score"] = $pageObject->getViewControl("score")->showDBValue($row, "");
			$values["operador"] = $pageObject->getViewControl("operador")->showDBValue($row, "");
			$values["data_insercao"] = $pageObject->getViewControl("data_insercao")->showDBValue($row, "");

		$eventRes = true;
		if ($eventObj->exists('BeforeOut'))
		{
			$eventRes = $eventObj->BeforeOut($row,$values, $pageObject);
		}
		if ($eventRes)
		{
			$outstr="";
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["tipo_nucleo"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["ano"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["mes"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["coordenadores"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["professores"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["alunos"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["meta_alunos"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["dias_funcionamento"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["meta_funcionamento"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["alunos_por_coordenador"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["meta_alunos_por_coordenador"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["freq_media_coordenador"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["min_freq_coordenador"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["freq_media_aluno"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["min_freq_aluno"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["freq_media_professor"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["min_freq_professor"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["meta_atividades"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["atividades_elaboradas"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["atividades_realizadas"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["score"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["operador"]).'"';
			if($outstr!="")
				$outstr.=",";
			$outstr.='"'.str_replace('"', '""', $values["data_insercao"]).'"';
			echo $outstr;
		}
		
		$iNumberOfRows++;
		if($eventObj->exists("ListFetchArray"))
			$row = $eventObj->ListFetchArray($rs, $pageObject);
		else
			$row = $cipherer->DecryptFetchedArray($rs);
			
		if(((!$nPageSize || $iNumberOfRows<$nPageSize) && $row) && $eventRes)
			echo "\r\n";
	}
}

function WriteTableData($cipherer)
{
	global $rs,$nPageSize,$strTableName,$conn,$eventObj, $pageObject;
	
	if($eventObj->exists("ListFetchArray"))
		$row = $eventObj->ListFetchArray($rs, $pageObject);
	else
		$row = $cipherer->DecryptFetchedArray($rs);
//	if(!$row)
//		return;
// write header
	echo "<tr>";
	if($_REQUEST["type"]=="excel")
	{
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Tipo Nucleo").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Ano").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Mes").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Coordenadores").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Professores").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Alunos").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Meta Alunos").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Dias Funcionamento").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Meta Funcionamento").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Alunos Por Coordenador").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Meta Alunos Por Coordenador").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Freq Media Coordenador").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Min Freq Coordenador").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Freq Media Aluno").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Min Freq Aluno").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Freq Media Professor").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Min Freq Professor").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Meta Atividades").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Atividades Elaboradas").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Atividades Realizadas").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Score").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Operador").'</td>';	
		echo '<td style="width: 100" x:str>'.PrepareForExcel("Data Insercao").'</td>';	
	}
	else
	{
		echo "<td>"."Tipo Nucleo"."</td>";
		echo "<td>"."Ano"."</td>";
		echo "<td>"."Mes"."</td>";
		echo "<td>"."Coordenadores"."</td>";
		echo "<td>"."Professores"."</td>";
		echo "<td>"."Alunos"."</td>";
		echo "<td>"."Meta Alunos"."</td>";
		echo "<td>"."Dias Funcionamento"."</td>";
		echo "<td>"."Meta Funcionamento"."</td>";
		echo "<td>"."Alunos Por Coordenador"."</td>";
		echo "<td>"."Meta Alunos Por Coordenador"."</td>";
		echo "<td>"."Freq Media Coordenador"."</td>";
		echo "<td>"."Min Freq Coordenador"."</td>";
		echo "<td>"."Freq Media Aluno"."</td>";
		echo "<td>"."Min Freq Aluno"."</td>";
		echo "<td>"."Freq Media Professor"."</td>";
		echo "<td>"."Min Freq Professor"."</td>";
		echo "<td>"."Meta Atividades"."</td>";
		echo "<td>"."Atividades Elaboradas"."</td>";
		echo "<td>"."Atividades Realizadas"."</td>";
		echo "<td>"."Score"."</td>";
		echo "<td>"."Operador"."</td>";
		echo "<td>"."Data Insercao"."</td>";
	}
	echo "</tr>";
	
// write data rows
	$iNumberOfRows = 0;
	$pageObject->viewControls->forExport = "export";
	while((!$nPageSize || $iNumberOfRows<$nPageSize) && $row)
	{
		countTotals($totals, $totalsFields, $row);
		
		$values = array();
	
					$values["tipo_nucleo"] = $pageObject->getViewControl("tipo_nucleo")->showDBValue($row, "");
					$values["ano"] = $pageObject->getViewControl("ano")->showDBValue($row, "");
					$values["mes"] = $pageObject->getViewControl("mes")->showDBValue($row, "");
					$values["coordenadores"] = $pageObject->getViewControl("coordenadores")->showDBValue($row, "");
					$values["professores"] = $pageObject->getViewControl("professores")->showDBValue($row, "");
					$values["alunos"] = $pageObject->getViewControl("alunos")->showDBValue($row, "");
					$values["meta_alunos"] = $pageObject->getViewControl("meta_alunos")->showDBValue($row, "");
					$values["dias_funcionamento"] = $pageObject->getViewControl("dias_funcionamento")->showDBValue($row, "");
					$values["meta_funcionamento"] = $pageObject->getViewControl("meta_funcionamento")->showDBValue($row, "");
					$values["alunos_por_coordenador"] = $pageObject->getViewControl("alunos_por_coordenador")->showDBValue($row, "");
					$values["meta_alunos_por_coordenador"] = $pageObject->getViewControl("meta_alunos_por_coordenador")->showDBValue($row, "");
					$values["freq_media_coordenador"] = $pageObject->getViewControl("freq_media_coordenador")->showDBValue($row, "");
					$values["min_freq_coordenador"] = $pageObject->getViewControl("min_freq_coordenador")->showDBValue($row, "");
					$values["freq_media_aluno"] = $pageObject->getViewControl("freq_media_aluno")->showDBValue($row, "");
					$values["min_freq_aluno"] = $pageObject->getViewControl("min_freq_aluno")->showDBValue($row, "");
					$values["freq_media_professor"] = $pageObject->getViewControl("freq_media_professor")->showDBValue($row, "");
					$values["min_freq_professor"] = $pageObject->getViewControl("min_freq_professor")->showDBValue($row, "");
					$values["meta_atividades"] = $pageObject->getViewControl("meta_atividades")->showDBValue($row, "");
					$values["atividades_elaboradas"] = $pageObject->getViewControl("atividades_elaboradas")->showDBValue($row, "");
					$values["atividades_realizadas"] = $pageObject->getViewControl("atividades_realizadas")->showDBValue($row, "");
					$values["score"] = $pageObject->getViewControl("score")->showDBValue($row, "");
					$values["operador"] = $pageObject->getViewControl("operador")->showDBValue($row, "");
					$values["data_insercao"] = $pageObject->getViewControl("data_insercao")->showDBValue($row, "");
		
		$eventRes = true;
		if ($eventObj->exists('BeforeOut'))
		{
			$eventRes = $eventObj->BeforeOut($row, $values, $pageObject);
		}
		if ($eventRes)
		{
			$iNumberOfRows++;
			echo "<tr>";
		
							echo '<td>';
			
									echo $values["tipo_nucleo"];
			echo '</td>';
							echo '<td>';
			
									echo $values["ano"];
			echo '</td>';
							echo '<td>';
			
									echo $values["mes"];
			echo '</td>';
							echo '<td>';
			
									echo $values["coordenadores"];
			echo '</td>';
							echo '<td>';
			
									echo $values["professores"];
			echo '</td>';
							echo '<td>';
			
									echo $values["alunos"];
			echo '</td>';
							echo '<td>';
			
									echo $values["meta_alunos"];
			echo '</td>';
							echo '<td>';
			
									echo $values["dias_funcionamento"];
			echo '</td>';
							echo '<td>';
			
									echo $values["meta_funcionamento"];
			echo '</td>';
							echo '<td>';
			
									echo $values["alunos_por_coordenador"];
			echo '</td>';
							echo '<td>';
			
									echo $values["meta_alunos_por_coordenador"];
			echo '</td>';
							echo '<td>';
			
									echo $values["freq_media_coordenador"];
			echo '</td>';
							echo '<td>';
			
									echo $values["min_freq_coordenador"];
			echo '</td>';
							echo '<td>';
			
									echo $values["freq_media_aluno"];
			echo '</td>';
							echo '<td>';
			
									echo $values["min_freq_aluno"];
			echo '</td>';
							echo '<td>';
			
									echo $values["freq_media_professor"];
			echo '</td>';
							echo '<td>';
			
									echo $values["min_freq_professor"];
			echo '</td>';
							echo '<td>';
			
									echo $values["meta_atividades"];
			echo '</td>';
							echo '<td>';
			
									echo $values["atividades_elaboradas"];
			echo '</td>';
							echo '<td>';
			
									echo $values["atividades_realizadas"];
			echo '</td>';
							echo '<td>';
			
									echo $values["score"];
			echo '</td>';
							if($_REQUEST["type"]=="excel")
					echo '<td x:str>';
				else
					echo '<td>';
			
									if($_REQUEST["type"]=="excel")
						echo PrepareForExcel($values["operador"]);
					else
						echo $values["operador"];
			echo '</td>';
							echo '<td>';
			
									if($_REQUEST["type"]=="excel")
						echo PrepareForExcel($values["data_insercao"]);
					else
						echo $values["data_insercao"];
			echo '</td>';
			echo "</tr>";
		}
		
		
		if($eventObj->exists("ListFetchArray"))
			$row = $eventObj->ListFetchArray($rs, $pageObject);
		else
			$row = $cipherer->DecryptFetchedArray($rs);
	}
	
}

function XMLNameEncode($strValue)
{
	$search = array(" ","#","'","/","\\","(",")",",","[");
	$ret = str_replace($search,"",$strValue);
	$search = array("]","+","\"","-","_","|","}","{","=");
	$ret = str_replace($search,"",$ret);
	return $ret;
}

function PrepareForExcel($ret)
{
	//$ret = htmlspecialchars($str); commented for bug #6823
	if (substr($ret,0,1)== "=") 
		$ret = "&#61;".substr($ret,1);
	return $ret;

}

function countTotals(&$totals, $totalsFields, $data)
{
	for($i = 0; $i < count($totalsFields); $i ++) 
	{
		if($totalsFields[$i]['totalsType'] == 'COUNT') 
			$totals[$totalsFields[$i]['fName']]["value"] += ($data[$totalsFields[$i]['fName']]!= "");
		else if($totalsFields[$i]['viewFormat'] == "Time") 
		{
			$time = GetTotalsForTime($data[$totalsFields[$i]['fName']]);
			$totals[$totalsFields[$i]['fName']]["value"] += $time[2]+$time[1]*60 + $time[0]*3600;
		} 
		else 
			$totals[$totalsFields[$i]['fName']]["value"] += ($data[$totalsFields[$i]['fName']]+ 0);
		
		if($totalsFields[$i]['totalsType'] == 'AVERAGE')
		{
			if(!is_null($data[$totalsFields[$i]['fName']]) && $data[$totalsFields[$i]['fName']]!=="")
				$totals[$totalsFields[$i]['fName']]['numRows']++;
		}
	}
}
?>
